/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler;

import java.util.Collection;
import java.util.Collections;
import java.util.LongSummaryStatistics;
import java.util.Map;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.TruffleContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.CPUSampler;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.ProfilerNode;

public final class CPUSamplerData {
    final TruffleContext context;
    final Map<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> threadData;
    final LongSummaryStatistics biasStatistics;
    final LongSummaryStatistics durationStatistics;
    final long samplesTaken;
    final long intervalMs;
    final long missedSamples;

    CPUSamplerData(TruffleContext context, Map<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> threadData, LongSummaryStatistics biasStatistics, LongSummaryStatistics durationStatistics, long samplesTaken, long intervalMs, long missedSamples) {
        this.context = context;
        this.threadData = threadData;
        this.biasStatistics = biasStatistics;
        this.durationStatistics = durationStatistics;
        this.samplesTaken = samplesTaken;
        this.intervalMs = intervalMs;
        this.missedSamples = missedSamples;
    }

    public TruffleContext getContext() {
        return this.context;
    }

    public Map<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> getThreadData() {
        return Collections.unmodifiableMap(this.threadData);
    }

    public long getSamples() {
        return this.samplesTaken;
    }

    public long getSampleInterval() {
        return this.intervalMs;
    }

    public LongSummaryStatistics getSampleBias() {
        LongSummaryStatistics statistics = new LongSummaryStatistics();
        statistics.combine(this.biasStatistics);
        return statistics;
    }

    public LongSummaryStatistics getSampleDuration() {
        LongSummaryStatistics statistics = new LongSummaryStatistics();
        statistics.combine(this.durationStatistics);
        return statistics;
    }

    public long missedSamples() {
        return this.missedSamples;
    }
}

