/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.interpreter.logic.operations;

import kasuga.lib.vendor_modules.interpreter.logic.infrastructure.LogicalData;
import kasuga.lib.vendor_modules.interpreter.logic.infrastructure.LogicalOperator;
import kasuga.lib.vendor_modules.interpreter.logic.operations.BoolType;

public class BoolOperation
implements LogicalData,
LogicalOperator {
    private final BoolType type;

    public BoolOperation(BoolType type) {
        this.type = type;
    }

    public BoolOperation(String type) {
        this.type = BoolType.fromString(type);
    }

    @Override
    public boolean operate(LogicalData former, LogicalData rear) {
        switch (this.type) {
            case AND: {
                return former.getResult() && rear.getResult();
            }
            case OR: {
                return former.getResult() || rear.getResult();
            }
            case NOT: {
                return !rear.getResult();
            }
        }
        return false;
    }

    public static boolean isBoolOperation(String typeFlag) {
        return BoolType.fromString(typeFlag.replace(" ", "")) != BoolType.INVALID;
    }

    @Override
    public boolean is(Object type) {
        if (type instanceof BoolType) {
            return type == this.type;
        }
        return false;
    }

    @Override
    public boolean getResult() {
        return false;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public String toString() {
        return this.type.toString();
    }

    @Override
    public BoolOperation clone() {
        return new BoolOperation(this.type);
    }
}

