/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.taczaddon.common;

import com.mafuyu404.taczaddon.init.NetworkHandler;
import com.mafuyu404.taczaddon.init.RuleRegistry;
import com.mafuyu404.taczaddon.init.VirtualInventory;
import com.mafuyu404.taczaddon.network.PrimitivePacket;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.item.AttachmentItem;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class LiberateAttachment {
    public static ArrayList<ItemStack> getAttachmentItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<AttachmentType> types = new ArrayList<AttachmentType>();
        types.add(AttachmentType.SCOPE);
        types.add(AttachmentType.MUZZLE);
        types.add(AttachmentType.STOCK);
        types.add(AttachmentType.GRIP);
        types.add(AttachmentType.LASER);
        types.add(AttachmentType.EXTENDED_MAG);
        types.forEach(type -> items.addAll((Collection<ItemStack>)AttachmentItem.fillItemCategory((AttachmentType)type)));
        return items;
    }

    public static Inventory useVirtualInventory(Inventory inventory) {
        ArrayList<ItemStack> AttachmentItems = LiberateAttachment.getAttachmentItems();
        int size = AttachmentItems.size() + 9;
        VirtualInventory virtualInventory = new VirtualInventory(size, inventory.f_35978_);
        for (int i = 0; i < size; ++i) {
            if (i < 9) {
                virtualInventory.m_6836_(i, inventory.m_36056_());
                continue;
            }
            virtualInventory.m_6836_(i, AttachmentItems.get(i - 9));
        }
        return virtualInventory;
    }

    public static void onRuleChange(MinecraftServer server, GameRules.BooleanValue value) {
        server.m_6846_().m_11314_().forEach(player -> {
            boolean liberateAttachment = player.m_9236_().m_46469_().m_46207_(RuleRegistry.LIBERATE_ATTACHMENT);
            NetworkHandler.sendToClient(player, new PrimitivePacket("gamerule.liberateAttachment", liberateAttachment));
            boolean showAttachmentDetail = player.m_9236_().m_46469_().m_46207_(RuleRegistry.SHOW_ATTACHMENT_DETAIL);
            NetworkHandler.sendToClient(player, new PrimitivePacket("gamerule.showAttachmentDetail", showAttachmentDetail));
        });
    }

    public static void syncRuleWhenLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        boolean liberateAttachment = serverPlayer.m_9236_().m_46469_().m_46207_(RuleRegistry.LIBERATE_ATTACHMENT);
        NetworkHandler.sendToClient(serverPlayer, new PrimitivePacket("gamerule.liberateAttachment", liberateAttachment));
        boolean showAttachmentDetail = serverPlayer.m_9236_().m_46469_().m_46207_(RuleRegistry.SHOW_ATTACHMENT_DETAIL);
        NetworkHandler.sendToClient(serverPlayer, new PrimitivePacket("gamerule.showAttachmentDetail", showAttachmentDetail));
    }
}

