/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.taczaddon.network;

import com.google.gson.Gson;
import com.mafuyu404.taczaddon.init.DataStorage;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PrimitivePacket {
    private final String packet;
    private static final Gson gson = new Gson();

    public PrimitivePacket(String k, Object v) {
        this.packet = gson.toJson((Object)new Packet(k, v));
    }

    public static void encode(PrimitivePacket msg, FriendlyByteBuf buffer) {
        buffer.m_130070_(msg.packet);
    }

    public static PrimitivePacket decode(FriendlyByteBuf buffer) {
        Packet data = (Packet)gson.fromJson(buffer.m_130277_(), Packet.class);
        return new PrimitivePacket(data.key, data.value);
    }

    public static void handle(PrimitivePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Packet data = (Packet)gson.fromJson(msg.packet, Packet.class);
            DataStorage.set(data.key, data.value);
        });
        ctx.get().setPacketHandled(true);
    }

    public static class Packet {
        public String key;
        public Object value;

        public Packet(String k, Object v) {
            this.key = k;
            this.value = v;
        }
    }
}

