/*
 * Decompiled with CFR 0.152.
 */
package net.puzzlemc.gui;

import eu.midnightdust.core.MidnightLib;
import eu.midnightdust.lib.util.PlatformFunctions;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.ReloadableTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.puzzlemc.core.PuzzleCore;
import net.puzzlemc.core.config.PuzzleConfig;
import net.puzzlemc.gui.PuzzleApi;
import net.puzzlemc.gui.compat.BorderlessMiningCompat;
import net.puzzlemc.gui.compat.CITRCompat;
import net.puzzlemc.gui.compat.ColormaticCompat;
import net.puzzlemc.gui.compat.ContinuityCompat;
import net.puzzlemc.gui.compat.CullLeavesCompat;
import net.puzzlemc.gui.compat.EMFCompat;
import net.puzzlemc.gui.compat.ETFCompat;
import net.puzzlemc.gui.compat.IrisCompat;
import net.puzzlemc.gui.compat.LBGCompat;
import net.puzzlemc.gui.compat.LDLCompat;
import net.puzzlemc.gui.screen.widget.PuzzleWidget;
import net.puzzlemc.splashscreen.PuzzleSplashScreen;

public class PuzzleGui {
    public static final Component YES = Component.translatable((String)"gui.yes").withStyle(ChatFormatting.GREEN);
    public static final Component NO = Component.translatable((String)"gui.no").withStyle(ChatFormatting.RED);
    public static final ResourceLocation PUZZLE_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"puzzle", (String)"icon/button");
    public static boolean lateInitDone = false;

    public static void init() {
        MidnightLib.hiddenMods.add("puzzle");
        PuzzleApi.addToMiscOptions(new PuzzleWidget((Component)Component.literal((String)"\ud83e\udde9 Puzzle")));
        PuzzleApi.addToMiscOptions(new PuzzleWidget((Component)Component.translatable((String)"puzzle.midnightconfig.title"), button -> button.setMessage((Component)Component.literal((String)"OPEN")), button -> Minecraft.getInstance().setScreen((Screen)PuzzleConfig.getScreen((Screen)Minecraft.getInstance().screen, (String)"puzzle"))));
        PuzzleApi.addToResourceOptions(new PuzzleWidget((Component)Component.literal((String)"\ud83e\udde9 Puzzle")));
        PuzzleApi.addToResourceOptions(new PuzzleWidget((Component)Component.translatable((String)"puzzle.option.resourcepack_splash_screen"), button -> button.setMessage(PuzzleConfig.resourcepackSplashScreen ? YES : NO), button -> {
            PuzzleConfig.resourcepackSplashScreen = !PuzzleConfig.resourcepackSplashScreen;
            PuzzleSplashScreen.resetColors();
            PuzzleConfig.write((String)"puzzle");
            Minecraft.getInstance().getTextureManager().registerAndLoad(PuzzleSplashScreen.LOGO, (ReloadableTexture)new PuzzleSplashScreen.LogoTexture(PuzzleSplashScreen.LOGO));
        }));
        PuzzleApi.addToResourceOptions(new PuzzleWidget((Component)Component.translatable((String)"puzzle.option.unlimited_model_rotations"), button -> button.setMessage(PuzzleConfig.unlimitedRotations ? YES : NO), button -> {
            PuzzleConfig.unlimitedRotations = !PuzzleConfig.unlimitedRotations;
            PuzzleConfig.write((String)"puzzle");
        }));
        PuzzleApi.addToResourceOptions(new PuzzleWidget((Component)Component.translatable((String)"puzzle.option.bigger_custom_models"), button -> button.setMessage(PuzzleConfig.biggerModels ? YES : NO), button -> {
            PuzzleConfig.biggerModels = !PuzzleConfig.biggerModels;
            PuzzleConfig.write((String)"puzzle");
        }));
        if (PuzzleGui.isActive("cullleaves")) {
            CullLeavesCompat.init();
        }
        if (PuzzleGui.isActive("colormatic")) {
            ColormaticCompat.init();
        }
        if (PuzzleGui.isActive("borderlessmining")) {
            BorderlessMiningCompat.init();
        }
        if (PuzzleGui.isActive("iris")) {
            IrisCompat.init();
        }
    }

    public static void lateInit() {
        if (PuzzleGui.isActive("lambdynlights")) {
            LDLCompat.init();
        }
        if (PuzzleGui.isActive("citresewn")) {
            CITRCompat.init();
        }
        if (PuzzleGui.isActive("lambdabettergrass")) {
            LBGCompat.init();
        }
        if (PuzzleGui.isActive("continuity")) {
            ContinuityCompat.init();
        }
        try {
            if (PuzzleGui.isActive("entity_texture_features")) {
                ETFCompat.init();
            }
            if (PuzzleGui.isActive("entity_model_features")) {
                EMFCompat.init();
            }
        }
        catch (Exception e) {
            PuzzleCore.LOGGER.error("ETF/EMF config structure changed. Again...", (Throwable)e);
        }
        lateInitDone = true;
    }

    public static boolean isActive(String modid) {
        return PlatformFunctions.isModLoaded((String)modid) && !PuzzleConfig.disabledIntegrations.contains(modid);
    }
}

