/*
 * Decompiled with CFR 0.152.
 */
package net.puzzlemc.gui.compat;

import java.util.EnumSet;
import java.util.Objects;
import java.util.TreeSet;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.puzzlemc.gui.PuzzleApi;
import net.puzzlemc.gui.PuzzleGui;
import net.puzzlemc.gui.screen.widget.PuzzleWidget;
import traben.entity_model_features.EMF;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.config.screens.ETFConfigScreenMain;

public class EMFCompat {
    public static void init() {
        PuzzleApi.addToResourceOptions(new PuzzleWidget((Component)Component.literal((String)"\ud83d\udc37 ").append((Component)Component.translatable((String)"entity_model_features.title"))));
        EMFConfig emfConfig = (EMFConfig)EMF.config().getConfig();
        PuzzleApi.addToResourceOptions(new PuzzleWidget((Component)Component.translatable((String)"entity_model_features.config.update"), button -> button.setMessage((Component)Component.literal((String)emfConfig.modelUpdateFrequency.toString())), button -> {
            TreeSet<ETFConfig.UpdateFrequency> set = new TreeSet<ETFConfig.UpdateFrequency>(EnumSet.allOf(ETFConfig.UpdateFrequency.class));
            emfConfig.modelUpdateFrequency = Objects.requireNonNullElseGet(set.higher(emfConfig.modelUpdateFrequency), set::first);
            EMF.config().saveToFile();
        }));
        PuzzleApi.addToResourceOptions(new PuzzleWidget(0, 65, (Component)Component.translatable((String)"entity_model_features.config.lod"), () -> emfConfig.animationLODDistance, button -> button.setMessage(EMFCompat.lodMessage(emfConfig.animationLODDistance)), slider -> {
            try {
                emfConfig.animationLODDistance = slider.getInt();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            EMF.config().saveToFile();
        }));
        PuzzleApi.addToGraphicsOptions(new PuzzleWidget((Component)Component.translatable((String)"entity_model_features.config.low_fps_lod"), button -> button.setMessage(emfConfig.retainDetailOnLowFps ? PuzzleGui.YES : PuzzleGui.NO), button -> {
            emfConfig.retainDetailOnLowFps = !emfConfig.retainDetailOnLowFps;
            EMF.config().saveToFile();
        }));
        PuzzleApi.addToGraphicsOptions(new PuzzleWidget((Component)Component.translatable((String)"entity_model_features.config.large_mob_lod"), button -> button.setMessage(emfConfig.retainDetailOnLargerMobs ? PuzzleGui.YES : PuzzleGui.NO), button -> {
            emfConfig.retainDetailOnLargerMobs = !emfConfig.retainDetailOnLargerMobs;
            EMF.config().saveToFile();
        }));
        PuzzleApi.addToResourceOptions(new PuzzleWidget((Component)Component.translatable((String)"puzzle.action.open_config_screen"), button -> button.setMessage(Component.nullToEmpty((String)"OPEN")), button -> Minecraft.getInstance().setScreen((Screen)new ETFConfigScreenMain(Minecraft.getInstance().screen))));
    }

    public static Component lodMessage(int value) {
        if (value == 20) {
            return Component.literal((String)(value + " (Default)"));
        }
        if (value == 0 || value == 65) {
            return CommonComponents.OPTION_OFF.copy().withStyle(ChatFormatting.RED);
        }
        return Component.literal((String)String.valueOf(value)).withStyle(ChatFormatting.AQUA);
    }
}

