/*
 * Decompiled with CFR 0.152.
 */
package net.puzzlemc.gui.screen;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.puzzlemc.gui.PuzzleApi;
import net.puzzlemc.gui.PuzzleGui;
import net.puzzlemc.gui.screen.widget.PuzzleOptionListWidget;

public class PuzzleOptionsScreen
extends Screen {
    public PuzzleOptionListWidget list;
    public List<Component> tooltip = null;
    public TabManager tabManager = new TabManager(a -> {}, a -> {});
    public Tab prevTab;
    public TabNavigationBar tabNavigation;
    public static Component graphicsTab = Component.translatable((String)"puzzle.page.graphics");
    public static Component miscTab = Component.translatable((String)"puzzle.page.misc");
    public static Component performanceTab = Component.translatable((String)"puzzle.page.performance");
    public static Component resourcesTab = Component.translatable((String)"puzzle.page.resources");
    private final Screen parent;

    public PuzzleOptionsScreen(Screen parent) {
        super((Component)Component.translatable((String)"puzzle.screen.title"));
        this.parent = parent;
    }

    protected void init() {
        if (!PuzzleGui.lateInitDone) {
            PuzzleGui.lateInit();
        }
        ArrayList tabs = Lists.newArrayList();
        if (!PuzzleApi.GRAPHICS_OPTIONS.isEmpty()) {
            tabs.add(new GridLayoutTab(graphicsTab));
        }
        if (!PuzzleApi.RESOURCE_OPTIONS.isEmpty()) {
            tabs.add(new GridLayoutTab(resourcesTab));
        }
        if (!PuzzleApi.PERFORMANCE_OPTIONS.isEmpty()) {
            tabs.add(new GridLayoutTab(performanceTab));
        }
        if (!PuzzleApi.MISC_OPTIONS.isEmpty()) {
            tabs.add(new GridLayoutTab(miscTab));
        }
        this.tabNavigation = TabNavigationBar.builder((TabManager)this.tabManager, (int)this.width).addTabs(tabs.toArray(new Tab[0])).build();
        this.tabNavigation.selectTab(0, false);
        this.tabNavigation.arrangeElements();
        this.prevTab = this.tabManager.getCurrentTab();
        this.list = new PuzzleOptionListWidget(this.minecraft, this.width, this.height - 57, 24, 25);
        this.fillList();
        if (tabs.size() > 1) {
            this.addRenderableWidget((GuiEventListener)this.tabNavigation);
            this.list.renderHeaderSeparator = false;
        }
        this.addWidget((GuiEventListener)this.list);
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> Objects.requireNonNull(this.minecraft).setScreen(this.parent)).bounds(this.width / 2 - 100, this.height - 26, 200, 20).build());
    }

    private void fillList() {
        List<Object> options = List.of();
        if (this.tabManager.getCurrentTab() == null) {
            return;
        }
        Component title = this.tabManager.getCurrentTab().getTabTitle();
        if (title.equals((Object)graphicsTab)) {
            options = PuzzleApi.GRAPHICS_OPTIONS;
        } else if (title.equals((Object)miscTab)) {
            options = PuzzleApi.MISC_OPTIONS;
        } else if (title.equals((Object)performanceTab)) {
            options = PuzzleApi.PERFORMANCE_OPTIONS;
        } else if (title.equals((Object)resourcesTab)) {
            options = PuzzleApi.RESOURCE_OPTIONS;
        }
        this.list.addAll(options);
    }

    public void tick() {
        super.tick();
        if (this.prevTab != null && this.prevTab != this.tabManager.getCurrentTab()) {
            this.prevTab = this.tabManager.getCurrentTab();
            this.list.clear();
            this.fillList();
            this.list.setScrollAmount(0.0);
        }
    }

    public boolean keyPressed(KeyEvent input) {
        return this.tabNavigation.keyPressed(input) || super.keyPressed(input);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.list.render(context, mouseX, mouseY, delta);
    }
}

