/*
 * Decompiled with CFR 0.152.
 */
package net.puzzlemc.splashscreen;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.SourceFactor;
import eu.midnightdust.lib.util.MidnightColorUtil;
import eu.midnightdust.lib.util.PlatformFunctions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ReloadableTexture;
import net.minecraft.client.renderer.texture.TextureContents;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.puzzlemc.core.PuzzleCore;
import net.puzzlemc.core.config.PuzzleConfig;
import net.puzzlemc.splashscreen.mixin.RenderPipelinesAccessor;
import org.jetbrains.annotations.NotNull;

public class PuzzleSplashScreen {
    public static final ResourceLocation LOGO = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/title/mojangstudios.png");
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"puzzle/splash_background.png");
    public static File CONFIG_PATH = new File(String.valueOf(PlatformFunctions.getConfigDirectory().resolve(".puzzle_cache")));
    public static Path LOGO_TEXTURE = Paths.get(String.valueOf(CONFIG_PATH) + "/mojangstudios.png", new String[0]);
    public static Path BACKGROUND_TEXTURE = Paths.get(String.valueOf(CONFIG_PATH) + "/splash_background.png", new String[0]);
    private static Minecraft client = Minecraft.getInstance();
    private static boolean keepBackground = false;
    public static RenderPipeline CUSTOM_LOGO_PIPELINE;

    public static void init() {
        if (!CONFIG_PATH.exists() && CONFIG_PATH.mkdir() && Util.getPlatform().equals((Object)Util.OS.WINDOWS)) {
            try {
                Files.setAttribute(CONFIG_PATH.toPath(), "dos:hidden", true, new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        PuzzleSplashScreen.buildRenderLayer();
    }

    public static void buildRenderLayer() {
        if (PuzzleConfig.resourcepackSplashScreen) {
            BlendFunction blendFunction = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE);
            if (PuzzleConfig.disableBlend) {
                blendFunction = null;
            } else if (PuzzleConfig.customBlendFunction.size() == 4) {
                try {
                    blendFunction = new BlendFunction(SourceFactor.valueOf((String)PuzzleConfig.customBlendFunction.get(0)), DestFactor.valueOf((String)PuzzleConfig.customBlendFunction.get(1)), SourceFactor.valueOf((String)PuzzleConfig.customBlendFunction.get(2)), DestFactor.valueOf((String)PuzzleConfig.customBlendFunction.get(3)));
                }
                catch (Exception e) {
                    PuzzleCore.LOGGER.error("Incorrect blend function defined in color.properties: {}{}", PuzzleConfig.customBlendFunction, (Object)e.getMessage());
                }
            }
            RenderPipeline.Builder CUSTOM_LOGO_PIPELINE_BUILDER = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelinesAccessor.getGUI_TEXTURED_SNIPPET()}).withLocation("pipeline/mojang_logo_puzzle").withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withDepthWrite(false);
            CUSTOM_LOGO_PIPELINE_BUILDER = blendFunction != null ? CUSTOM_LOGO_PIPELINE_BUILDER.withBlend(blendFunction) : CUSTOM_LOGO_PIPELINE_BUILDER.withoutBlend();
            CUSTOM_LOGO_PIPELINE = CUSTOM_LOGO_PIPELINE_BUILDER.build();
        }
    }

    public static void resetColors() {
        PuzzleConfig.backgroundColor = 15675965;
        PuzzleConfig.progressBarColor = 0xFFFFFF;
        PuzzleConfig.progressBarBackgroundColor = 15675965;
        PuzzleConfig.progressFrameColor = 0xFFFFFF;
        PuzzleConfig.disableBlend = false;
        PuzzleConfig.customBlendFunction = new ArrayList<String>();
        PuzzleConfig.hasCustomSplashScreen = false;
    }

    public static class DynamicLogoTexture
    extends ReloadableTexture {
        public DynamicLogoTexture() {
            super(LOGO);
        }

        @NotNull
        public TextureContents loadContents(ResourceManager resourceManager) {
            TextureContents textureContents;
            FileInputStream input = new FileInputStream(String.valueOf(LOGO_TEXTURE));
            try {
                textureContents = new TextureContents(NativeImage.read((InputStream)input), new TextureMetadataSection(true, true));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    PuzzleCore.LOGGER.error("Encountered an error during logo loading: ", (Throwable)e);
                    try {
                        return TextureContents.load((ResourceManager)resourceManager, (ResourceLocation)LOGO);
                    }
                    catch (IOException ex) {
                        return TextureContents.createMissing();
                    }
                }
            }
            ((InputStream)input).close();
            return textureContents;
        }
    }

    public static class LogoTexture
    extends ReloadableTexture {
        public LogoTexture(ResourceLocation logo) {
            super(logo);
        }

        @NotNull
        public TextureContents loadContents(ResourceManager resourceManager) {
            TextureContents textureContents;
            block8: {
                Minecraft client = Minecraft.getInstance();
                VanillaPackResources defaultResourcePack = client.getVanillaPackResources();
                InputStream input = (InputStream)Objects.requireNonNull(defaultResourcePack.getResource(PackType.CLIENT_RESOURCES, LOGO)).get();
                try {
                    textureContents = new TextureContents(NativeImage.read((InputStream)input), new TextureMetadataSection(true, true));
                    if (input == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        return TextureContents.createMissing();
                    }
                }
                input.close();
            }
            return textureContents;
        }
    }

    public static class ReloadListener
    implements ResourceManagerReloadListener {
        public static final ReloadListener INSTANCE = new ReloadListener();

        private ReloadListener() {
        }

        public void onResourceManagerReload(ResourceManager manager) {
            client = Minecraft.getInstance();
            if (PuzzleConfig.resourcepackSplashScreen) {
                PuzzleSplashScreen.resetColors();
                client.getTextureManager().registerAndLoad(LOGO, (ReloadableTexture)new LogoTexture(LOGO));
                client.getTextureManager().registerAndLoad(BACKGROUND, (ReloadableTexture)new LogoTexture(BACKGROUND));
                manager.listResources("optifine", path -> path.getPath().contains("color.properties")).forEach((id, resource) -> {
                    try (InputStream stream = resource.open();){
                        Properties properties = new Properties();
                        properties.load(stream);
                        if (properties.get("screen.loading") != null) {
                            PuzzleConfig.backgroundColor = MidnightColorUtil.hex2Rgb((String)properties.get("screen.loading").toString()).getRGB();
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                        if (properties.get("screen.loading.bar") != null) {
                            PuzzleConfig.progressBarBackgroundColor = MidnightColorUtil.hex2Rgb((String)properties.get("screen.loading.bar").toString()).getRGB();
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                        if (properties.get("screen.loading.progress") != null) {
                            PuzzleConfig.progressBarColor = MidnightColorUtil.hex2Rgb((String)properties.get("screen.loading.progress").toString()).getRGB();
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                        if (properties.get("screen.loading.outline") != null) {
                            PuzzleConfig.progressFrameColor = MidnightColorUtil.hex2Rgb((String)properties.get("screen.loading.outline").toString()).getRGB();
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                        if (properties.get("screen.loading.blend") != null) {
                            PuzzleConfig.disableBlend = properties.get("screen.loading.blend").toString().equals("off");
                            PuzzleConfig.customBlendFunction = new ArrayList<String>(Arrays.stream(properties.get("screen.loading.blend").toString().split(" ")).toList());
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                    }
                    catch (Exception e) {
                        PuzzleCore.LOGGER.error("Error occurred while loading color.properties {}", (Object)id.toString(), (Object)e);
                    }
                });
                AtomicInteger logoCount = new AtomicInteger();
                manager.listResources("textures", path -> path.getPath().contains("mojangstudios.png")).forEach((id, resource) -> {
                    try (InputStream stream = resource.open();){
                        Files.copy(stream, LOGO_TEXTURE, StandardCopyOption.REPLACE_EXISTING);
                        client.getTextureManager().registerAndLoad(LOGO, (ReloadableTexture)new DynamicLogoTexture());
                        if (logoCount.get() > 0) {
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                        logoCount.getAndIncrement();
                    }
                    catch (Exception e) {
                        PuzzleCore.LOGGER.error("Error occurred while loading custom minecraft logo {}", (Object)id.toString(), (Object)e);
                    }
                });
                manager.listResources("puzzle", path -> path.getPath().contains("splash_background.png")).forEach((id, resource) -> {
                    try (InputStream stream = resource.open();){
                        Files.copy(stream, BACKGROUND_TEXTURE, StandardCopyOption.REPLACE_EXISTING);
                        FileInputStream input = new FileInputStream(String.valueOf(BACKGROUND_TEXTURE));
                        client.getTextureManager().register(BACKGROUND, (AbstractTexture)new DynamicTexture(() -> "splash_screen_background", NativeImage.read((InputStream)input)));
                        keepBackground = true;
                        PuzzleConfig.hasCustomSplashScreen = true;
                    }
                    catch (Exception e) {
                        PuzzleCore.LOGGER.error("Error occurred while loading custom splash background {}", (Object)id.toString(), (Object)e);
                    }
                });
                if (!keepBackground) {
                    try {
                        Files.delete(BACKGROUND_TEXTURE);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                keepBackground = false;
                PuzzleConfig.write((String)"puzzle");
                PuzzleSplashScreen.buildRenderLayer();
            }
        }
    }
}

