/*
 * Decompiled with CFR 0.152.
 */
package net.puzzlemc.splashscreen.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.function.IntSupplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ReloadableTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.puzzlemc.core.config.PuzzleConfig;
import net.puzzlemc.splashscreen.PuzzleSplashScreen;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LoadingOverlay.class}, priority=2000)
public abstract class MixinSplashScreen
extends Overlay {
    @Shadow
    private long fadeInStart;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private boolean fadeIn;
    @Shadow
    private long fadeOutStart;

    @Shadow
    private static int replaceAlpha(int color, int alpha) {
        return 0;
    }

    @Inject(method={"registerTextures(Lnet/minecraft/client/renderer/texture/TextureManager;)V"}, at={@At(value="TAIL")})
    private static void puzzle$initSplashscreen(TextureManager textureManager, CallbackInfo ci) {
        if (PuzzleConfig.resourcepackSplashScreen) {
            if (PuzzleSplashScreen.LOGO_TEXTURE.toFile().exists()) {
                textureManager.registerAndLoad(LoadingOverlay.MOJANG_STUDIOS_LOGO_LOCATION, (ReloadableTexture)new PuzzleSplashScreen.DynamicLogoTexture());
            }
            if (PuzzleSplashScreen.BACKGROUND_TEXTURE.toFile().exists()) {
                try {
                    FileInputStream input = new FileInputStream(String.valueOf(PuzzleSplashScreen.BACKGROUND_TEXTURE));
                    textureManager.register(PuzzleSplashScreen.BACKGROUND, (AbstractTexture)new DynamicTexture(() -> "splash_screen_background", NativeImage.read((InputStream)input)));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Redirect(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Ljava/util/function/IntSupplier;getAsInt()I"))
    private int puzzle$modifyBackground(IntSupplier instance) {
        return !PuzzleConfig.resourcepackSplashScreen || PuzzleConfig.progressBarBackgroundColor == 15675965 ? instance.getAsInt() : PuzzleConfig.backgroundColor | 0xFF000000;
    }

    @WrapOperation(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIFFIIIIIII)V")})
    private void puzzle$modifyRenderLayer(GuiGraphics context, RenderPipeline pipeline, ResourceLocation sprite, int x, int y, float u, float v, int width, int height, int regionWidth, int regionHeight, int textureWidth, int textureHeight, int color, Operation<Void> original) {
        if (PuzzleConfig.resourcepackSplashScreen) {
            context.blit(PuzzleSplashScreen.CUSTOM_LOGO_PIPELINE, sprite, x, y, u, v, width, height, regionWidth, regionHeight, textureWidth, textureHeight, color);
        } else {
            context.blit(pipeline, sprite, x, y, u, v, width, height, textureWidth, textureHeight, color);
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;guiWidth()I", ordinal=2)})
    private void puzzle$renderSplashBackground(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (Files.exists(PuzzleSplashScreen.BACKGROUND_TEXTURE, new LinkOption[0]) && PuzzleConfig.resourcepackSplashScreen) {
            float g;
            int width = this.minecraft.getWindow().getGuiScaledWidth();
            int height = this.minecraft.getWindow().getGuiScaledHeight();
            long l = Util.getMillis();
            float f = this.fadeOutStart > -1L ? (float)(l - this.fadeOutStart) / 1000.0f : -1.0f;
            float f2 = g = this.fadeInStart > -1L ? (float)(l - this.fadeInStart) / 500.0f : -1.0f;
            float s = f >= 1.0f ? 1.0f - Mth.clamp((float)(f - 1.0f), (float)0.0f, (float)1.0f) : (this.fadeIn ? Mth.clamp((float)g, (float)0.0f, (float)1.0f) : 1.0f);
            context.blit(RenderPipelines.GUI_TEXTURED, PuzzleSplashScreen.BACKGROUND, 0, 0, 0.0f, 0.0f, width, height, width, height, ARGB.white((float)s));
        }
    }

    @Inject(method={"drawProgressBar(Lnet/minecraft/client/gui/GuiGraphics;IIIIF)V"}, at={@At(value="HEAD")})
    private void puzzle$addProgressBarBackground(GuiGraphics context, int minX, int minY, int maxX, int maxY, float opacity, CallbackInfo ci) {
        if (!PuzzleConfig.resourcepackSplashScreen || PuzzleConfig.progressBarBackgroundColor == 15675965) {
            return;
        }
        long l = Util.getMillis();
        float f = this.fadeOutStart > -1L ? (float)(l - this.fadeOutStart) / 1000.0f : -1.0f;
        int m = Mth.ceil((float)((1.0f - Mth.clamp((float)(f - 1.0f), (float)0.0f, (float)1.0f)) * 255.0f));
        context.fill(minX, minY, maxX, maxY, MixinSplashScreen.replaceAlpha(PuzzleConfig.progressBarBackgroundColor, m));
    }

    @ModifyArg(method={"drawProgressBar(Lnet/minecraft/client/gui/GuiGraphics;IIIIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V"), index=4)
    private int puzzle$modifyProgressFrame(int color) {
        return !PuzzleConfig.resourcepackSplashScreen || PuzzleConfig.progressFrameColor == 0xFFFFFF ? color : PuzzleConfig.progressFrameColor | 0xFF000000;
    }

    @ModifyArg(method={"drawProgressBar(Lnet/minecraft/client/gui/GuiGraphics;IIIIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V", ordinal=0), index=4)
    private int puzzle$modifyProgressColor(int color) {
        return !PuzzleConfig.resourcepackSplashScreen || PuzzleConfig.progressBarColor == 0xFFFFFF ? color : PuzzleConfig.progressBarColor | 0xFF000000;
    }
}

