/*
 * Decompiled with CFR 0.152.
 */
package net.puzzlemc.gui.screen.widget;

import eu.midnightdust.lib.config.ButtonEntry;
import eu.midnightdust.lib.config.EntryInfo;
import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.lib.config.MidnightConfigListWidget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.puzzlemc.core.PuzzleCore;
import net.puzzlemc.gui.screen.PuzzleOptionsScreen;
import net.puzzlemc.gui.screen.widget.ButtonType;
import net.puzzlemc.gui.screen.widget.PuzzleButtonWidget;
import net.puzzlemc.gui.screen.widget.PuzzleSliderWidget;
import net.puzzlemc.gui.screen.widget.PuzzleTextFieldWidget;
import net.puzzlemc.gui.screen.widget.PuzzleWidget;

public class PuzzleOptionListWidget
extends MidnightConfigListWidget {
    Font textRenderer;

    public PuzzleOptionListWidget(Minecraft minecraftClient, int i, int j, int k, int l) {
        super(minecraftClient, i, j, k, l);
        this.centerListVertically = false;
        this.textRenderer = minecraftClient.font;
    }

    public void addAll(List<PuzzleWidget> buttons) {
        int buttonX = this.width - 160;
        for (PuzzleWidget button : buttons) {
            try {
                if (button.buttonType == ButtonType.TEXT) {
                    this.addButton(List.of(), (Component)Component.literal((String)"").append(button.descriptionText).withStyle(ChatFormatting.BOLD));
                    continue;
                }
                if (button.buttonType == ButtonType.BUTTON) {
                    this.addButton(List.of(new PuzzleButtonWidget(buttonX, 0, 150, 20, button.buttonTextAction, button.onPress)), button.descriptionText);
                    continue;
                }
                if (button.buttonType == ButtonType.SLIDER) {
                    this.addButton(List.of(new PuzzleSliderWidget(button.min, button.max, buttonX, 0, 150, 20, button.defaultSliderValue.getAsInt(), button.buttonTextAction, button.changeSliderValue)), button.descriptionText);
                    continue;
                }
                if (button.buttonType == ButtonType.TEXT_FIELD) {
                    this.addButton(List.of(new PuzzleTextFieldWidget(this.textRenderer, buttonX, 0, 150, 20, button.setTextValue, button.changeTextValue)), button.descriptionText);
                    continue;
                }
                PuzzleCore.LOGGER.warn("Button {} is missing the buttonType variable. This shouldn't happen!", (Object)button);
            }
            catch (Exception e) {
                PuzzleCore.LOGGER.error("Failed to add button {}. Likely caused by an update of the specific mod.", (Object)button.descriptionText);
            }
        }
    }

    public void addButton(List<AbstractWidget> buttons, Component text) {
        EntryInfo info = new EntryInfo(null, "puzzle");
        if (buttons.isEmpty()) {
            info.comment = new MidnightConfig.Comment(this){

                public Class<? extends Annotation> annotationType() {
                    return null;
                }

                public boolean centered() {
                    return true;
                }

                public String category() {
                    return "";
                }

                public String name() {
                    return "";
                }

                public String url() {
                    return "";
                }

                public String requiredMod() {
                    return "";
                }
            };
        }
        ButtonEntry entry = new ButtonEntry(buttons, text, info);
        this.addEntry((AbstractSelectionList.Entry)entry);
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.renderWidget(context, mouseX, mouseY, delta);
        ButtonEntry e = this.getHovered();
        Screen screen = this.minecraft.screen;
        if (screen instanceof PuzzleOptionsScreen) {
            PuzzleOptionsScreen page = (PuzzleOptionsScreen)screen;
            if (e != null && !e.buttons.isEmpty() && (screen = e.text.getContents()) instanceof TranslatableContents) {
                TranslatableContents content = (TranslatableContents)screen;
                AbstractWidget button = (AbstractWidget)e.buttons.get(0);
                String key = null;
                if (I18n.exists((String)(content.getKey() + ".tooltip"))) {
                    key = content.getKey() + ".tooltip";
                } else if (I18n.exists((String)(content.getKey() + ".desc"))) {
                    key = content.getKey() + ".desc";
                }
                if (key == null && content.getKey().endsWith(".title")) {
                    String strippedContent = content.getKey().substring(0, content.getKey().length() - 6);
                    if (I18n.exists((String)(strippedContent + ".tooltip"))) {
                        key = strippedContent + ".tooltip";
                    } else if (I18n.exists((String)(strippedContent + ".desc"))) {
                        key = strippedContent + ".desc";
                    }
                }
                if (key != null) {
                    ArrayList<Component> list = new ArrayList<Component>();
                    for (String str : I18n.get((String)key, (Object[])new Object[0]).split("\n")) {
                        list.add((Component)Component.literal((String)str));
                    }
                    page.tooltip = list;
                    if (!button.isMouseOver((double)mouseX, (double)mouseY)) {
                        context.renderComponentTooltip(this.textRenderer, list, button.getX(), button.getY() + button.getHeight() * 2);
                    } else {
                        context.renderComponentTooltip(this.textRenderer, list, mouseX, mouseY);
                    }
                }
            }
        }
    }

    public ButtonEntry getHovered() {
        return (ButtonEntry)super.getHovered();
    }
}

