/*
 * Decompiled with CFR 0.152.
 */
package net.puzzlemc.models.mixin;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.util.GsonHelper;
import net.puzzlemc.core.config.PuzzleConfig;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockElement.Deserializer.class})
public abstract class MixinModelElementDeserializer {
    @Shadow
    protected abstract Vector3f getVector3f(JsonObject var1, String var2);

    @Inject(at={@At(value="HEAD")}, method={"getAngle(Lcom/google/gson/JsonObject;)F"}, cancellable=true)
    private void puzzle$deserializeRotationAngle(JsonObject object, CallbackInfoReturnable<Float> cir) {
        if (PuzzleConfig.unlimitedRotations) {
            float angle = GsonHelper.getAsFloat((JsonObject)object, (String)"angle");
            cir.setReturnValue((Object)Float.valueOf(angle));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getTo(Lcom/google/gson/JsonObject;)Lorg/joml/Vector3f;"}, cancellable=true)
    private void puzzle$deserializeTo(JsonObject object, CallbackInfoReturnable<Vector3f> cir) {
        if (PuzzleConfig.biggerModels) {
            Vector3f vec3f = this.getVector3f(object, "to");
            if (!(vec3f.x < -32.0f || vec3f.y < -32.0f || vec3f.z < -32.0f || vec3f.x > 48.0f || vec3f.y > 48.0f || vec3f.z > 48.0f)) {
                cir.setReturnValue((Object)vec3f);
            } else {
                throw new JsonParseException("'to' specifier exceeds the allowed boundaries: " + String.valueOf(vec3f));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getFrom(Lcom/google/gson/JsonObject;)Lorg/joml/Vector3f;"}, cancellable=true)
    private void puzzle$deserializeFrom(JsonObject object, CallbackInfoReturnable<Vector3f> cir) {
        if (PuzzleConfig.biggerModels) {
            Vector3f vec3f = this.getVector3f(object, "from");
            if (!(vec3f.x < -32.0f || vec3f.y < -32.0f || vec3f.z < -32.0f || vec3f.x > 48.0f || vec3f.y > 48.0f || vec3f.z > 48.0f)) {
                cir.setReturnValue((Object)vec3f);
            } else {
                throw new JsonParseException("'from' specifier exceeds the allowed boundaries: " + String.valueOf(vec3f));
            }
        }
    }
}

