package io.github.viciscat.bhc;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Locale;

public class BetterHypixelChatMod implements ModInitializer {
    // This logger is used to write text to the console and the log file.
    // It is considered best practice to use your mod id as the logger's name.
    // That way, it's clear which mod wrote info, warnings, and errors.
    public static final Logger LOGGER = LoggerFactory.getLogger("BetterHypixelChat");
    public static final String VERSION = /*$ mod_version*/ "0.1.0";
    public static final String MINECRAFT = /*$ minecraft*/ "1.21.9";
    public static final String NAMESPACE = "better_hypixel_chat";

    private static boolean onHypixel = false;

    public static boolean isOnHypixel() {
        return onHypixel;
    }

    @Override
    public void onInitialize() {
        // This code runs as soon as Minecraft is in a mod-load-ready state.
        // However, some things (like resources) may still be uninitialized.
        // Proceed with mild caution.

        LOGGER.info("Hello Fabric world!");
        //? if >=1.21.9 {
        net.fabricmc.fabric.api.resource.v1.ResourceLoader.get(class_3264.field_14188)
                .registerReloader(AddVanillaFont.ID, new AddVanillaFont());
        net.fabricmc.fabric.api.resource.v1.ResourceLoader.get(class_3264.field_14188)
                .addReloaderOrdering(
                        net.fabricmc.fabric.api.resource.v1.reloader.ResourceReloaderKeys.Client.FONTS,
                        AddVanillaFont.ID
                );
        //?} else {
        /*net.fabricmc.fabric.api.resource.ResourceManagerHelper.get(ResourceType.CLIENT_RESOURCES).registerReloadListener(new AddVanillaFont());
        *///?}

        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            String serverAddress = (client.method_1558() != null) ? client.method_1558().field_3761.toLowerCase(Locale.ENGLISH) : "";
            String serverBrand = (client.field_1724 != null && client.field_1724.field_3944 != null && client.field_1724.field_3944.method_52790() != null) ? client.field_1724.field_3944.method_52790() : "";

            onHypixel = serverAddress.contains("hypixel.net") || serverAddress.contains("hypixel.io") || serverBrand.contains("Hypixel BungeeCord");
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, sender) -> {
            onHypixel = false;
        });
    }

    /**
     * Adapts to the {@link class_2960} changes introduced in 1.21.
     */
    public static class_2960 id(String path) {
        return class_2960.method_60655(NAMESPACE, path);
    }
}