package io.github.viciscat.bhc;

import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5481;
import net.minecraft.class_9848;

public record CenteredSeparationLine(class_5481 text, int lineColor) implements CustomLineRenderer {
    private static final int THICKNESS = 1;
    @Override
    public void render(class_327 textRenderer, class_332 context, class_5481 text, int x, int y, int textColor, int chatWidth) {
        int center = x + (chatWidth / 2);
        context.method_35719(textRenderer, this.text, center, y, textColor);

        int width = textRenderer.method_30880(this.text);
        int start = x + (chatWidth - width) / 2;
        int end = start + width;

        int lineY = y + (textRenderer.field_2000 - THICKNESS) / 2;
        int color1 = class_9848.method_61330(class_9848.method_61326(class_9848.method_65100(this.lineColor) * class_9848.method_65100(textColor)), this.lineColor);
        int color2 = class_9848.method_61321(color1, 0.25f);
        context.method_25294(x + 2, lineY + 1, start, lineY + THICKNESS + 1, color2);
        context.method_25294(x + 1, lineY, start - 1, lineY + THICKNESS, color1);

        context.method_25294(end + 2, lineY + 1, x + chatWidth, lineY + THICKNESS + 1, color2);
        context.method_25294(end + 1, lineY, x + chatWidth - 1, lineY + THICKNESS, color1);

    }

    @Override
    public class_2583 getStyleAt(class_327 textRenderer, int x, int mouseX, int chatWidth) {
        double offset = x + (chatWidth - textRenderer.method_30880(this.text)) / 2.0;
        return mouseX < offset ? null : textRenderer.method_27527().method_30876(this.text, class_3532.method_15357(mouseX - offset));
    }
}
