/*
 * Decompiled with CFR 0.152.
 */
package io.github.viciscat.bhc.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.github.viciscat.bhc.BetterHypixelChatMod;
import io.github.viciscat.bhc.CenteredLine;
import io.github.viciscat.bhc.CenteredSeparationLine;
import io.github.viciscat.bhc.ChatConstants;
import io.github.viciscat.bhc.CustomLineRenderer;
import io.github.viciscat.bhc.SeparationLine;
import io.github.viciscat.bhc.TextBuilder;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_338;
import net.minecraft.class_341;
import net.minecraft.class_3532;
import net.minecraft.class_5224;
import net.minecraft.class_5225;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_9848;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_338.class})
public abstract class ChatHudMixin {
    @Shadow
    @Final
    private List<class_303.class_7590> field_2064;
    @Shadow
    @Final
    private class_310 field_2062;
    @Unique
    private final Map<class_303.class_7590, CustomLineRenderer> customLineRenderers = new Reference2ObjectOpenHashMap();

    @Shadow
    public abstract int method_1811();

    @Shadow
    public abstract double method_1814();

    @Inject(method={"method_1808(Z)V"}, at={@At(value="HEAD")})
    private void clear(boolean clearHistory, CallbackInfo ci) {
        this.customLineRenderers.clear();
    }

    @WrapOperation(method={"method_1815(Lnet/minecraft/class_303;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_341;method_1850(Lnet/minecraft/class_5348;ILnet/minecraft/class_327;)Ljava/util/List;")})
    private List<class_5481> processCustomLines(class_5348 stringVisitable, int width, class_327 textRenderer, Operation<List<class_5481>> original, @Share(value="custom_line_renderers") LocalRef<List<CustomLineRenderer>> renderersRef, @Local(argsOnly=true) class_303 message) {
        if (!BetterHypixelChatMod.isOnHypixel()) {
            return (List)original.call(new Object[]{stringVisitable, width, textRenderer});
        }
        TextBuilder builder = new TextBuilder();
        message.comp_893().method_30937().accept((class_5224)builder);
        List<class_5250> texts = builder.getTexts();
        ArrayList<class_5481> result = new ArrayList<class_5481>(texts.size());
        ArrayList<Record> renderers = new ArrayList<Record>(texts.size());
        for (class_5250 text : texts) {
            String string = text.getString();
            String trimmed = string.trim();
            if (trimmed.length() > 4 && trimmed.chars().allMatch(c -> c == 45 || c == 8212)) {
                result.add(text.method_30937());
                renderers.add(new SeparationLine(this.getFirstColor(text).map(color -> class_9848.method_61334((int)color.method_27716())).orElse(-1), 1));
                continue;
            }
            if (trimmed.length() > 4 && trimmed.chars().allMatch(c -> c == 9644)) {
                result.add(text.method_30937());
                renderers.add(new SeparationLine(this.getFirstColor(text).map(color -> class_9848.method_61334((int)color.method_27716())).orElse(-1), 3));
                continue;
            }
            if (trimmed.startsWith("-") && trimmed.endsWith("-") && textRenderer.method_27525((class_5348)this.withFont((class_2561)text)) > 310) {
                int end;
                int start;
                for (start = 0; start < string.length() && string.charAt(start) == '-'; ++start) {
                }
                for (end = string.length() - 1; end >= 0 && string.charAt(end) == '-'; --end) {
                }
                TextBuilder textBuilder = new TextBuilder(start, end);
                text.method_30937().accept((class_5224)textBuilder);
                List list = class_341.method_1850((class_5348)((class_5348)textBuilder.getTexts().getFirst()), (int)this.getScaledWidth(), (class_327)textRenderer);
                for (int i = 0; i < list.size(); ++i) {
                    class_5481 orderedText = (class_5481)list.get(i);
                    result.add(orderedText);
                    renderers.add(i == 0 ? new CenteredSeparationLine(orderedText, this.getFirstColor(text).map(color -> class_9848.method_61334((int)color.method_27716())).orElse(-1)) : new CenteredLine(orderedText));
                }
                continue;
            }
            if (string.startsWith(" ") && !trimmed.isEmpty()) {
                int firstNonSpaceChar;
                for (firstNonSpaceChar = 0; firstNonSpaceChar < string.length() && string.charAt(firstNonSpaceChar) == ' '; ++firstNonSpaceChar) {
                }
                MutableBoolean reachedText = new MutableBoolean(false);
                class_5250 trimmedText = class_2561.method_43473();
                text.method_27658((style, asString) -> {
                    if (reachedText.booleanValue()) {
                        trimmedText.method_10852((class_2561)class_2561.method_43470((String)asString).method_10862(style));
                    } else {
                        if (asString.isBlank()) {
                            return Optional.empty();
                        }
                        trimmedText.method_10852((class_2561)class_2561.method_43470((String)asString.stripLeading()).method_10862(style));
                        reachedText.setTrue();
                    }
                    return Optional.empty();
                }, class_2583.field_24360);
                String s = string.substring(0, firstNonSpaceChar);
                int leadingSpace = textRenderer.method_27525((class_5348)this.withFont((class_2561)class_2561.method_43470((String)s)));
                int textWidth = textRenderer.method_27525((class_5348)this.withFont((class_2561)trimmedText));
                int abs = Math.abs(160 - (leadingSpace + textWidth / 2));
                if (abs < 6) {
                    List list = class_341.method_1850((class_5348)trimmedText, (int)this.getScaledWidth(), (class_327)textRenderer);
                    for (class_5481 orderedText : list) {
                        result.add(orderedText);
                        renderers.add(new CenteredLine(orderedText));
                    }
                    continue;
                }
                List orderedTexts = class_341.method_1850((class_5348)text, (int)this.getScaledWidth(), (class_327)textRenderer);
                result.addAll(orderedTexts);
                for (int i = 0; i < orderedTexts.size(); ++i) {
                    renderers.add(null);
                }
                continue;
            }
            List orderedTexts = class_341.method_1850((class_5348)text, (int)this.getScaledWidth(), (class_327)textRenderer);
            result.addAll(orderedTexts);
            for (int i = 0; i < orderedTexts.size(); ++i) {
                renderers.add(null);
            }
        }
        if (result.size() != renderers.size()) {
            throw new IllegalStateException("Result and Renderer lists aren't the same size!");
        }
        renderersRef.set(renderers);
        return result;
    }

    @Inject(method={"method_1815(Lnet/minecraft/class_303;)V"}, at={@At(value="INVOKE", target="Ljava/util/List;add(ILjava/lang/Object;)V", shift=At.Shift.AFTER)})
    private void addCustomLineRenderer(CallbackInfo ci, @Share(value="custom_line_renderers") LocalRef<List<CustomLineRenderer>> renderersRef, @Local(ordinal=1) int i) {
        if (!BetterHypixelChatMod.isOnHypixel()) {
            return;
        }
        List renderers = (List)renderersRef.get();
        if (renderers == null || i >= renderers.size()) {
            BetterHypixelChatMod.LOGGER.warn("Custom line renderer not found or is too small! {}", (Object)this.field_2064.getFirst());
            return;
        }
        CustomLineRenderer renderer = (CustomLineRenderer)renderers.get(i);
        if (renderer != null) {
            this.customLineRenderers.put(this.field_2064.getFirst(), renderer);
        }
    }

    @WrapOperation(method={"method_1815(Lnet/minecraft/class_303;)V"}, at={@At(value="INVOKE", target="Ljava/util/List;remove(I)Ljava/lang/Object;")})
    private <E> E removeCustomLineRenderer(List<E> instance, int i, Operation<E> original) {
        class_303.class_7590 visible = (class_303.class_7590)instance.get(i);
        this.customLineRenderers.remove(visible);
        return (E)original.call(new Object[]{instance, i});
    }

    @WrapOperation(method={"method_1816(DD)Lnet/minecraft/class_2583;"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_5225;method_30876(Lnet/minecraft/class_5481;I)Lnet/minecraft/class_2583;")})
    private class_2583 customLineStyle(class_5225 instance, class_5481 text, int x, Operation<class_2583> original, @Local class_303.class_7590 visible) {
        CustomLineRenderer renderer = this.customLineRenderers.get(visible);
        if (renderer == null) {
            return (class_2583)original.call(new Object[]{instance, text, x});
        }
        return renderer.getStyleAt(this.field_2062.field_1772, 0, x, this.getScaledWidth());
    }

    @Unique
    private Optional<class_5251> getFirstColor(class_5250 text) {
        return text.method_27658((style, asString) -> Optional.ofNullable(style.method_10973()), class_2583.field_24360);
    }

    @Inject(method={"method_44813()V"}, at={@At(value="HEAD")})
    private void clearOnRefresh(CallbackInfo ci) {
        this.customLineRenderers.clear();
    }

    @WrapOperation(method={"method_1805(Lnet/minecraft/class_332;IIIZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_332;method_35720(Lnet/minecraft/class_327;Lnet/minecraft/class_5481;III)I")})
    private int drawCustomRenderers(class_332 instance, class_327 textRenderer, class_5481 orderedText, int x, int y, int color, Operation<Void> original, @Local class_303.class_7590 visible) {
        CustomLineRenderer renderer = this.customLineRenderers.get(visible);
        if (renderer == null) {
            original.call(new Object[]{instance, textRenderer, orderedText, x, y, color});
        } else {
            renderer.render(textRenderer, instance, orderedText, x, y, color, this.getScaledWidth());
        }
        return 0;
    }

    @Unique
    private int getScaledWidth() {
        return class_3532.method_15357((double)((double)this.method_1811() / this.method_1814()));
    }

    @Unique
    class_5250 withFont(class_2561 text) {
        return class_2561.method_43473().method_10862(class_2583.field_24360.method_27704(ChatConstants.VANILLA_FONT)).method_10852(text);
    }
}

