package io.github.viciscat.bhc.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.github.viciscat.bhc.*;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_338;
import net.minecraft.class_341;
import net.minecraft.class_3532;
import net.minecraft.class_5225;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_9848;
import net.minecraft.text.*;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.*;

@Mixin(class_338.class)
public abstract class ChatHudMixin {

    @Shadow
    @Final
    private List<class_303.class_7590> visibleMessages;

    @Shadow
    private int scrolledLines;

    @Shadow
    public abstract int getWidth();

    @Shadow
    public abstract double getChatScale();

    @Shadow
    @Final
    private class_310 client;

    @Unique
    private final Map<class_303.class_7590, CustomLineRenderer> customLineRenderers = new Reference2ObjectOpenHashMap<>();

    @Inject(method = "clear", at = @At("HEAD"))
    private void clear(boolean clearHistory, CallbackInfo ci) {
        customLineRenderers.clear();
    }

    @WrapOperation(method = "addVisibleMessage", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/util/ChatMessages;breakRenderedChatMessageLines(Lnet/minecraft/text/StringVisitable;ILnet/minecraft/client/font/TextRenderer;)Ljava/util/List;"))
    private List<class_5481> processCustomLines(class_5348 stringVisitable, int width, class_327 textRenderer, Operation<List<class_5481>> original, @Share("custom_line_renderers") LocalRef<List<CustomLineRenderer>> renderersRef, @Local(argsOnly = true) class_303 message) {
        if (!BetterHypixelChatMod.isOnHypixel()) return original.call(stringVisitable, width, textRenderer);
        // split all inner linebreaks and remove chat formattings.
        TextBuilder builder = new TextBuilder();
        message.comp_893().method_30937().accept(builder);
        Collection<class_5250> texts = builder.getTexts();

        List<class_5481> result = new ArrayList<>(texts.size());
        List<CustomLineRenderer> renderers = new ArrayList<>(texts.size());

        for (class_5250 text : texts) {
            String string = text.getString();
            String trimmed = string.trim();
            // check if the text is all -
            if (trimmed.length() > 4 && trimmed.chars().allMatch(c -> c == '-' || c == '—')) {
                result.add(text.method_30937());
                renderers.add(new SeparationLine(getFirstColor(text).map(color -> class_9848.method_61334(color.method_27716())).orElse(-1), 1));
            } else if (trimmed.length() > 4 && trimmed.chars().allMatch(c -> c == '▬')) {
                result.add(text.method_30937());
                renderers.add(new SeparationLine(getFirstColor(text).map(color -> class_9848.method_61334(color.method_27716())).orElse(-1), 3));
            } else if (trimmed.startsWith("-") && trimmed.endsWith("-") && textRenderer.method_27525(withFont(text)) > ChatConstants.DEFAULT_WIDTH - 10) {
                int start;
                for (start = 0; start < string.length(); start++) {
                    if (string.charAt(start) != '-') break;
                }
                int end;
                for (end = string.length() - 1; end >= 0; end--) {
                    if (string.charAt(end) != '-') break;
                }

                TextBuilder textBuilder = new TextBuilder(start, end);
                text.method_30937().accept(textBuilder);

                List<class_5481> list = class_341.method_1850(textBuilder.getTexts().getFirst(), getScaledWidth(), textRenderer);
                for (int i = 0; i < list.size(); i++) {
                    class_5481 orderedText = list.get(i);
                    result.add(orderedText);
                    renderers.add(i == 0 ? new CenteredSeparationLine(orderedText, getFirstColor(text).map(color -> class_9848.method_61334(color.method_27716())).orElse(-1)) : new CenteredLine(orderedText));
                }
            } else if (string.startsWith(" ") && !trimmed.isEmpty()) {
                // find last space in the string
                int firstNonSpaceChar;
                for (firstNonSpaceChar = 0; firstNonSpaceChar < string.length(); firstNonSpaceChar++) {
                    if (string.charAt(firstNonSpaceChar) != ' ') break;
                }
                MutableBoolean reachedText = new MutableBoolean(false);
                class_5250 trimmedText = class_2561.method_43473(); // still has trailing spaces, shouldn't be an issue?
                text.method_27658((style, asString) -> {
                    if (reachedText.booleanValue()) {
                        trimmedText.method_10852(class_2561.method_43470(asString).method_10862(style));
                    } else {
                        if (asString.isBlank()) return Optional.empty();
                        trimmedText.method_10852(class_2561.method_43470(asString.stripLeading()).method_10862(style));
                        reachedText.setTrue();
                    }
                    return Optional.empty();
                }, class_2583.field_24360);

                String s = string.substring(0, firstNonSpaceChar);
                int leadingSpace = textRenderer.method_27525(withFont(class_2561.method_43470(s)));
                int textWidth = textRenderer.method_27525(withFont(trimmedText));
                int abs = Math.abs(ChatConstants.DEFAULT_WIDTH / 2 - (leadingSpace + textWidth / 2));
                //System.out.println("trimmedText: " + withFont(trimmedText));
                //System.out.println("leadingSpace: " +  leadingSpace + " textWidth: " + textWidth + " abs: " + abs);
                if (abs < 6) { // if true this text is supposed to be centered!
                    List<class_5481> list = class_341.method_1850(trimmedText, getScaledWidth(), textRenderer);
                    for (class_5481 orderedText : list) {
                        result.add(orderedText);
                        renderers.add(new CenteredLine(orderedText));
                    }
                } else {
                    List<class_5481> orderedTexts = class_341.method_1850(text, getScaledWidth(), textRenderer);
                    result.addAll(orderedTexts);
                    for (int i = 0; i < orderedTexts.size(); i++) renderers.add(null);
                }

            } else {
                List<class_5481> orderedTexts = class_341.method_1850(text, getScaledWidth(), textRenderer);
                result.addAll(orderedTexts);
                for (int i = 0; i < orderedTexts.size(); i++) renderers.add(null);
            }
        }
        if (result.size() != renderers.size()) throw new IllegalStateException("Result and Renderer lists aren't the same size!");
        renderersRef.set(renderers);
        return result;
    }

    @Inject(method = "addVisibleMessage", at = @At(value = "INVOKE", target = "Ljava/util/List;add(ILjava/lang/Object;)V", shift = At.Shift.AFTER))
    private void addCustomLineRenderer(CallbackInfo ci, @Share("custom_line_renderers") LocalRef<List<CustomLineRenderer>> renderersRef, @Local(ordinal = 1) int i) {
        if (!BetterHypixelChatMod.isOnHypixel()) return;
        List<CustomLineRenderer> renderers = renderersRef.get();
        if (renderers == null || i >= renderers.size()) {
            BetterHypixelChatMod.LOGGER.warn("Custom line renderer not found or is too small! {}", visibleMessages.getFirst());
            return;
        }
        CustomLineRenderer renderer = renderers.get(i);
        if (renderer != null) {
            customLineRenderers.put(visibleMessages.getFirst(), renderer);
        }
    }

    @WrapOperation(method = "addVisibleMessage", at = @At(value = "INVOKE", target = "Ljava/util/List;remove(I)Ljava/lang/Object;"))
    private <E> E removeCustomLineRenderer(List<E> instance, int i, Operation<E> original) {
        class_303.class_7590 visible = (class_303.class_7590) instance.get(i);
        customLineRenderers.remove(visible);
        return original.call(instance, i);
    }

    @WrapOperation(method = "getTextStyleAt", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/font/TextHandler;getStyleAt(Lnet/minecraft/text/OrderedText;I)Lnet/minecraft/text/Style;"))
    private class_2583 customLineStyle(class_5225 instance, class_5481 text, int x, Operation<class_2583> original, @Local class_303.class_7590 visible) {
        CustomLineRenderer renderer = customLineRenderers.get(visible);
        if (renderer == null) return original.call(instance, text, x);
        return renderer.getStyleAt(client.field_1772, 0, x, getScaledWidth());
    }

    @Unique
    private Optional<class_5251> getFirstColor(class_5250 text) {
        return text.method_27658((style, asString) -> Optional.ofNullable(style.method_10973()), class_2583.field_24360);
    }

    @Inject(method = "refresh", at = @At("HEAD"))
    private void clearOnRefresh(CallbackInfo ci) {
        customLineRenderers.clear();
    }

    //? if >=1.21.6 {
    /*@WrapOperation(method = "method_71991", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawTextWithShadow(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/OrderedText;III)V"))
    *///?} else {
    @WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawTextWithShadow(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/OrderedText;III)I"))
    //?}
    private /*? if <=1.21.5 {*/ int /*?} else {*/ /*void *//*?}*/
    drawCustomRenderers(class_332 instance, class_327 textRenderer, class_5481 orderedText, int x, int y, int color, Operation<Void> original,
                        /*? if <=1.21.5 {*/@Local(ordinal = 12)/*?} else {*//*@Local(argsOnly = true, ordinal = 4)*//*?}*/ int index) {
        index += this.scrolledLines;
        CustomLineRenderer renderer = customLineRenderers.get(visibleMessages.get(index));
        if (renderer == null) original.call(instance, textRenderer, orderedText, x, y, color);
        else {
            renderer.render(textRenderer, instance, orderedText, x, y, color, getScaledWidth());
        }
        //? if <=1.21.5
        return index;
    }

    @Unique
    private int getScaledWidth() {
        return class_3532.method_15357(getWidth() / getChatScale());
    }

    @Unique
    class_5250 withFont(class_2561 text) {
        //? if >=1.21.9 {
        /*return Text.empty().setStyle(Style.EMPTY.withFont(new StyleSpriteSource.Font(ChatConstants.VANILLA_FONT))).append(text);
        *///?} else {
        return class_2561.method_43473().method_10862(class_2583.field_24360.method_27704(ChatConstants.VANILLA_FONT)).method_10852(text);
        //?}
    }
}