/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.acatar.fluid;

import net.mcreator.acatar.init.AcatarModBlocks;
import net.mcreator.acatar.init.AcatarModFluidTypes;
import net.mcreator.acatar.init.AcatarModFluids;
import net.mcreator.acatar.init.AcatarModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class PottedwaterFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)AcatarModFluidTypes.POTTED_WATER_TYPE.get(), () -> (Fluid)AcatarModFluids.POTTED_WATER.get(), () -> (Fluid)AcatarModFluids.FLOWING_POTTED_WATER.get()).explosionResistance(100.0f).bucket(() -> (Item)AcatarModItems.POTTED_WATER_BUCKET.get()).block(() -> (LiquidBlock)AcatarModBlocks.POTTED_WATER.get());

    private PottedwaterFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.FALLING_WATER;
    }

    public static class Flowing
    extends PottedwaterFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends PottedwaterFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

