/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.acatar.init;

import net.mcreator.acatar.entity.CeruleancreeperEntity;
import net.mcreator.acatar.entity.ColossumEntity;
import net.mcreator.acatar.entity.ExtermateEntity;
import net.mcreator.acatar.entity.LyvorawolfEntity;
import net.mcreator.acatar.entity.WavegelEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class AcatarModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"acatar");
    public static final DeferredHolder<EntityType<?>, EntityType<ColossumEntity>> COLOSSUM = AcatarModEntities.register("colossum", EntityType.Builder.of(ColossumEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<ExtermateEntity>> EXTERMATE = AcatarModEntities.register("extermate", EntityType.Builder.of(ExtermateEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(32).setUpdateInterval(3).fireImmune().sized(1.0f, 3.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<WavegelEntity>> WAVEGEL = AcatarModEntities.register("wavegel", EntityType.Builder.of(WavegelEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<CeruleancreeperEntity>> CERULEANCREEPER = AcatarModEntities.register("ceruleancreeper", EntityType.Builder.of(CeruleancreeperEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<LyvorawolfEntity>> LYVORAWOLF = AcatarModEntities.register("lyvorawolf", EntityType.Builder.of(LyvorawolfEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 0.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        ColossumEntity.init(event);
        ExtermateEntity.init(event);
        WavegelEntity.init(event);
        CeruleancreeperEntity.init(event);
        LyvorawolfEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)COLOSSUM.get(), ColossumEntity.createAttributes().build());
        event.put((EntityType)EXTERMATE.get(), ExtermateEntity.createAttributes().build());
        event.put((EntityType)WAVEGEL.get(), WavegelEntity.createAttributes().build());
        event.put((EntityType)CERULEANCREEPER.get(), CeruleancreeperEntity.createAttributes().build());
        event.put((EntityType)LYVORAWOLF.get(), LyvorawolfEntity.createAttributes().build());
    }
}

