/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.acatar.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelColossum
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"acatar", (String)"model_colossum"), "main");
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart arm0;
    public final ModelPart arm1;
    public final ModelPart leg0;
    public final ModelPart leg1;

    public ModelColossum(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.arm0 = root.getChild("arm0");
        this.arm1 = root.getChild("arm1");
        this.leg0 = root.getChild("leg0");
        this.leg1 = root.getChild("leg1");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 40).addBox(-9.0f, -2.0f, -6.0f, 18.0f, 12.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 70).addBox(-4.5f, 10.0f, -3.0f, 9.0f, 5.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -12.0f, -5.5f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-1.0f, -5.0f, -7.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)-2.0f));
        PartDefinition arm0 = partdefinition.addOrReplaceChild("arm0", CubeListBuilder.create().texOffs(60, 21).addBox(9.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition arm1 = partdefinition.addOrReplaceChild("arm1", CubeListBuilder.create().texOffs(60, 58).addBox(-13.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition leg0 = partdefinition.addOrReplaceChild("leg0", CubeListBuilder.create().texOffs(37, 0).addBox(-2.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)11.0f, (float)0.0f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(60, 0).addBox(-2.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)11.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.leg0.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leg1.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.arm1.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.arm0.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

