/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.acatar.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelExtermate
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"acatar", (String)"model_extermate"), "main");
    public final ModelPart head;
    public final ModelPart left_tendril;
    public final ModelPart right_tendril;
    public final ModelPart torso;
    public final ModelPart left_ribcage;
    public final ModelPart right_ribcage;
    public final ModelPart left_arm;
    public final ModelPart right_arm;
    public final ModelPart left_leg;
    public final ModelPart right_leg;

    public ModelExtermate(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.left_tendril = root.getChild("left_tendril");
        this.right_tendril = root.getChild("right_tendril");
        this.torso = root.getChild("torso");
        this.left_ribcage = root.getChild("left_ribcage");
        this.right_ribcage = root.getChild("right_ribcage");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 32).addBox(-8.0f, -16.0f, -5.0f, 16.0f, 16.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-10.0f, (float)-1.0f));
        PartDefinition left_tendril = partdefinition.addOrReplaceChild("left_tendril", CubeListBuilder.create().texOffs(58, 0).addBox(0.0f, -13.0f, 0.0f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)-22.0f, (float)0.0f));
        PartDefinition right_tendril = partdefinition.addOrReplaceChild("right_tendril", CubeListBuilder.create().texOffs(52, 32).addBox(-16.0f, -13.0f, 0.0f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)-22.0f, (float)0.0f));
        PartDefinition torso = partdefinition.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, -13.0f, -4.0f, 18.0f, 21.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)-1.0f));
        PartDefinition left_ribcage = partdefinition.addOrReplaceChild("left_ribcage", CubeListBuilder.create().texOffs(90, 11).mirror().addBox(-7.0f, -11.0f, -0.1f, 9.0f, 21.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)7.0f, (float)1.0f, (float)-5.0f));
        PartDefinition right_ribcage = partdefinition.addOrReplaceChild("right_ribcage", CubeListBuilder.create().texOffs(90, 11).addBox(-2.0f, -11.0f, -0.1f, 9.0f, 21.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)1.0f, (float)-5.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 58).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 28.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)13.0f, (float)-10.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(44, 50).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 28.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-13.0f, (float)-10.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(76, 76).addBox(-2.9f, 0.0f, -3.0f, 6.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)11.0f, (float)-1.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(76, 48).addBox(-3.1f, 0.0f, -3.0f, 6.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)11.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.right_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.left_arm.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

