/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.acatar.fluid;

import net.mcreator.acatar.init.AcatarModBlocks;
import net.mcreator.acatar.init.AcatarModFluidTypes;
import net.mcreator.acatar.init.AcatarModFluids;
import net.mcreator.acatar.init.AcatarModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class ElixirofLifeFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)AcatarModFluidTypes.ELIXIROF_LIFE_TYPE.get(), () -> (Fluid)AcatarModFluids.ELIXIROF_LIFE.get(), () -> (Fluid)AcatarModFluids.FLOWING_ELIXIROF_LIFE.get()).explosionResistance(100.0f).bucket(() -> (Item)AcatarModItems.ELIXIROF_LIFE_BUCKET.get()).block(() -> (LiquidBlock)AcatarModBlocks.ELIXIROF_LIFE.get());

    private ElixirofLifeFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_WATER;
    }

    public static class Flowing
    extends ElixirofLifeFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends ElixirofLifeFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

