/*
 * Decompiled with CFR 0.152.
 */
package com.cosmeticsmod.external.software.bernie.geckolib3.model;

import com.cosmeticsmod.external.software.bernie.geckolib3.animation.AnimationTicker;
import com.cosmeticsmod.external.software.bernie.geckolib3.core.IAnimatable;
import com.cosmeticsmod.external.software.bernie.geckolib3.core.IAnimatableModel;
import com.cosmeticsmod.external.software.bernie.geckolib3.core.builder.Animation;
import com.cosmeticsmod.external.software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import com.cosmeticsmod.external.software.bernie.geckolib3.core.manager.AnimationData;
import com.cosmeticsmod.external.software.bernie.geckolib3.core.processor.AnimationProcessor;
import com.cosmeticsmod.external.software.bernie.geckolib3.core.processor.IBone;
import com.cosmeticsmod.external.software.bernie.geckolib3.file.AnimationFile;
import com.cosmeticsmod.external.software.bernie.geckolib3.geo.render.built.GeoBone;
import com.cosmeticsmod.external.software.bernie.geckolib3.geo.render.built.GeoModel;
import com.cosmeticsmod.morecosmetics.MoreCosmetics;
import com.cosmeticsmod.morecosmetics.utils.GeckoBridge;
import com.cosmeticsmod.morecosmetics.utils.SharedVars;
import java.util.Collections;

public abstract class AnimatedGeoModel<T extends IAnimatable>
implements IAnimatableModel<T> {
    public double seekTime;
    public double lastGameTickTime;
    public boolean shouldCrashOnMissing = false;
    private final AnimationProcessor animationProcessor = new AnimationProcessor(this);
    private GeoModel currentModel;
    private AnimationFile animationFile;

    protected AnimatedGeoModel(GeoModel model, AnimationFile animationFile) {
        this.animationProcessor.clearModelRendererList();
        for (GeoBone bone : model.topLevelBones) {
            this.registerBone(bone);
        }
        this.currentModel = model;
        this.animationFile = animationFile;
    }

    public void registerBone(GeoBone bone) {
        this.registerModelRenderer(bone);
        for (GeoBone childBone : bone.childBones) {
            this.registerBone(childBone);
        }
    }

    @Override
    public void setLivingAnimations(T entity, Integer uniqueID, AnimationEvent customPredicate) {
        AnimationData data = entity.getFactory().getOrCreateAnimationData(uniqueID);
        if (data.ticker == null) {
            AnimationTicker ticker = new AnimationTicker(data);
            data.ticker = ticker;
            MoreCosmetics.getInstance().registerTickListener(ticker);
        }
        this.seekTime = data.tick + (double)SharedVars.PARTIAL_TICKS;
        AnimationEvent<T> predicate = customPredicate == null ? new AnimationEvent<T>(entity, 0.0f, 0.0f, 0.0f, false, Collections.emptyList()) : customPredicate;
        predicate.animationTick = this.seekTime;
        this.animationProcessor.preAnimationSetup((IAnimatable)predicate.getAnimatable(), this.seekTime);
        if (!this.animationProcessor.getModelRendererList().isEmpty()) {
            this.animationProcessor.tickAnimation((IAnimatable)entity, uniqueID, this.seekTime, predicate, GeckoBridge.MOLANG_PARSER, this.shouldCrashOnMissing);
        }
    }

    @Override
    public AnimationProcessor getAnimationProcessor() {
        return this.animationProcessor;
    }

    public void registerModelRenderer(IBone modelRenderer) {
        this.animationProcessor.registerModelRenderer(modelRenderer);
    }

    @Override
    public Animation getAnimation(String name, IAnimatable animatable) {
        return this.animationFile.getAnimation(name);
    }

    public GeoModel getModel() {
        return this.currentModel;
    }

    public AnimationFile getAnimationFile() {
        return this.animationFile;
    }

    @Override
    public void setMolangQueries(IAnimatable animatable, double currentTick) {
    }
}

