/*
 * Decompiled with CFR 0.152.
 */
package com.cosmeticsmod.morecosmetics.gui;

import com.cosmeticsmod.morecosmetics.MoreCosmetics;
import com.cosmeticsmod.morecosmetics.gui.core.UIConstants;
import com.cosmeticsmod.morecosmetics.gui.core.box.BoxElementBuilder;
import com.cosmeticsmod.morecosmetics.gui.core.box.BoxManager;
import com.cosmeticsmod.morecosmetics.gui.core.box.CustomBoxGui;
import com.cosmeticsmod.morecosmetics.gui.core.box.utils.BoxCategory;
import com.cosmeticsmod.morecosmetics.gui.core.box.utils.BoxComponent;
import com.cosmeticsmod.morecosmetics.gui.core.list.ListComponent;
import com.cosmeticsmod.morecosmetics.gui.core.list.ListElementBuilder;
import com.cosmeticsmod.morecosmetics.gui.core.notification.NotificationHandler;
import com.cosmeticsmod.morecosmetics.gui.core.texture.TextureCategory;
import com.cosmeticsmod.morecosmetics.gui.core.texture.TextureCategoryBuilder;
import com.cosmeticsmod.morecosmetics.gui.core.texture.TextureEntry;
import com.cosmeticsmod.morecosmetics.models.ModelHandler;
import com.cosmeticsmod.morecosmetics.models.ModelLoader;
import com.cosmeticsmod.morecosmetics.models.config.ConfigAccessor;
import com.cosmeticsmod.morecosmetics.models.config.ModelConfig;
import com.cosmeticsmod.morecosmetics.models.config.ModelData;
import com.cosmeticsmod.morecosmetics.models.config.SettingType;
import com.cosmeticsmod.morecosmetics.models.editor.LocalServer;
import com.cosmeticsmod.morecosmetics.models.model.CosmeticModel;
import com.cosmeticsmod.morecosmetics.models.model.util.ModelCategory;
import com.cosmeticsmod.morecosmetics.nametags.EnumNametag;
import com.cosmeticsmod.morecosmetics.nametags.Nametag;
import com.cosmeticsmod.morecosmetics.nametags.NametagHandler;
import com.cosmeticsmod.morecosmetics.nametags.font.FontImage;
import com.cosmeticsmod.morecosmetics.nametags.logo.EnumLogo;
import com.cosmeticsmod.morecosmetics.networking.packets.PacketInfo;
import com.cosmeticsmod.morecosmetics.networking.utils.EnumInfo;
import com.cosmeticsmod.morecosmetics.user.CosmeticUser;
import com.cosmeticsmod.morecosmetics.user.presets.PresetManager;
import com.cosmeticsmod.morecosmetics.user.presets.UserPreset;
import com.cosmeticsmod.morecosmetics.utils.Authenticator;
import com.cosmeticsmod.morecosmetics.utils.CompatibilityManager;
import com.cosmeticsmod.morecosmetics.utils.LanguageHandler;
import com.cosmeticsmod.morecosmetics.utils.ModConfig;
import com.cosmeticsmod.morecosmetics.utils.OpenMode;
import com.cosmeticsmod.morecosmetics.utils.Utils;
import com.cosmeticsmod.morecosmetics.utils.debug.DebugConsole;
import com.cosmeticsmod.morecosmetics.utils.debug.DebugInfo;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

public class ModelGui
implements CustomBoxGui {
    private static ModelGui instance;
    private BoxElementBuilder boxBuilder;
    private ListElementBuilder listBuilder;
    private MoreCosmetics mod;
    private ModelLoader modelLoader;
    private PresetManager presetManager;
    private HashMap<Integer, BoxCategory> catMap = new HashMap();
    private BoxManager.BoxGuiInstance guiInstance;
    private int lastTextureUpload = -1;
    private long lastProfileAdded;
    private static final int[] NONVALID;

    public ModelGui(BoxManager.BoxGuiInstance guiInstance) {
        this.guiInstance = guiInstance;
        instance = this;
        this.mod = MoreCosmetics.getInstance();
        this.modelLoader = this.mod.getModelLoader();
        this.boxBuilder = this.mod.getBoxElementBuilder();
        this.listBuilder = this.mod.getListElementBuilder();
        this.presetManager = new PresetManager();
        this.presetManager.loadPresets();
        for (ModelCategory cat : ModelCategory.VALUES) {
            this.catMap.put(cat.getId(), new BoxCategory(cat.getTitle(), cat.getLocationName()).setTitle(cat.getTitle() + " Cosmetics"));
        }
    }

    @Override
    public void fillGui(List<BoxCategory> list) {
        boolean online = this.mod.getUserHandler().isOnlineMode();
        boolean onModdingPlatform = !"Vanilla".equals(CompatibilityManager.PLATFORM);
        ModConfig config = ModConfig.getConfig();
        list.clear();
        this.catMap.values().forEach(boxCat -> boxCat.getEntries().clear());
        this.modelLoader.getCosmetics().values().stream().filter(model -> !online || this.mod.getUserHandler().getOnlineCosmetics().containsKey(model.getId())).forEach(model -> this.catMap.get(model.getCategory()).getEntries().add(this.getComponent((CosmeticModel)model)));
        this.catMap.values().stream().filter(l -> !l.getEntries().isEmpty()).forEach(list::add);
        if (NametagHandler.isNametagEnabled() && !online) {
            Nametag nametag = this.getUser().hasNametag() ? this.getUser().getNametag() : new Nametag("Nametag");
            list.add(new BoxCategory("Nametag", "nametag").fillEntries(guiComponents -> {
                guiComponents.add(this.listBuilder.getSwitchElement("Nametag", this.getUser().hasNametag(), false, enabled -> this.getUser().setNametag(enabled != false ? nametag : null)));
                guiComponents.add(this.listBuilder.getTextBoxElement("First Line", Utils.replaceColorCodesReverse(nametag.getTag()), null, null, nametag::setTag));
                guiComponents.add(this.listBuilder.getTextBoxElement("Second Line", Utils.replaceColorCodesReverse(nametag.getSecondTag()), null, null, nametag::setSecondTag));
                guiComponents.add(this.listBuilder.getSliderElement("Size", 1, 5, nametag.getScaleNum(), nametag::setScaleNum));
                guiComponents.add(this.listBuilder.getListElement("Mode", Stream.of(EnumNametag.values()).map(Enum::name).collect(Collectors.toList()), nametag.getMode().ordinal(), mode -> nametag.setMode(EnumNametag.valueOf(mode))));
                TreeMap<String, FontImage> map = new TreeMap<String, FontImage>();
                ArrayList<Integer> ids = new ArrayList<Integer>(this.mod.getFontHandler().getFonts().keySet());
                ids.forEach(id -> map.put(this.mod.getFontHandler().getFont((Integer)id).name, this.mod.getNametagHandler().getFontRendererMap().get(id)));
                guiComponents.add(this.listBuilder.getListElement("Font", map, this.mod.getFontHandler().getFont((Integer)Integer.valueOf((int)nametag.getFont())).name, ids.indexOf(nametag.getFont()), name -> nametag.setFont(this.mod.getFontHandler().getId((String)name))));
                ArrayList<TextureCategory> textureCatList = new ArrayList<TextureCategory>();
                TextureCategory socialMediaCat = new TextureCategory("CosmeticsMod", EnumLogo.SOCIALMEDIA.format("cm"));
                socialMediaCat.fillEntries(textureList -> {
                    textureList.add(new TextureEntry("Youtube", EnumLogo.SOCIALMEDIA.format("yt")));
                    textureList.add(new TextureEntry("Twitch", EnumLogo.SOCIALMEDIA.format("tw")));
                    textureList.add(new TextureEntry("Discord", EnumLogo.SOCIALMEDIA.format("dc")));
                    textureList.add(new TextureEntry("Instagram", EnumLogo.SOCIALMEDIA.format("ig")));
                    textureList.add(new TextureEntry("Snapchat", EnumLogo.SOCIALMEDIA.format("sc")));
                    textureList.add(new TextureEntry("TikTok", EnumLogo.SOCIALMEDIA.format("tk")));
                    textureList.add(new TextureEntry("Twitter", EnumLogo.SOCIALMEDIA.format("tr")));
                    textureList.add(new TextureEntry("Skype", EnumLogo.SOCIALMEDIA.format("sk")));
                    textureList.add(new TextureEntry("Steam", EnumLogo.SOCIALMEDIA.format("st")));
                    textureList.add(new TextureEntry("Fiverr", EnumLogo.SOCIALMEDIA.format("fr")));
                    textureList.add(new TextureEntry("Reddit", EnumLogo.SOCIALMEDIA.format("rd")));
                    textureList.add(new TextureEntry("SoundCloud", EnumLogo.SOCIALMEDIA.format("sd")));
                    textureList.add(new TextureEntry("Teamspeak", EnumLogo.SOCIALMEDIA.format("ts")));
                    textureList.add(new TextureEntry("Spotify", EnumLogo.SOCIALMEDIA.format("sp")));
                }, 1);
                textureCatList.add(socialMediaCat);
                guiComponents.add(this.listBuilder.getTextureElement("Logo", textureCatList, 0, 3, texture -> nametag.setLogoURL(texture == null ? null : texture.getImageURL())));
                if (this.mod.getUserHandler().hasOnlineNametag()) {
                    guiComponents.add(this.listBuilder.getButtonElement("Change online Nametag", () -> Authenticator.getAuthenticator().openPanel()));
                }
            }, true));
        }
        if (ModelHandler.isCloakEnabled()) {
            list.add(new BoxCategory("Cloak", "cloak").fillEntries(guiComponents -> {
                ListComponent cloakSwitch = this.listBuilder.getSwitchElement("Cloak", this.getUser().getCloak().isEnabled(), false, enabled -> {
                    this.getUser().getCloak().toggle((Boolean)enabled);
                    this.mod.getUserHandler().checkSettingsChanged();
                });
                guiComponents.add(cloakSwitch);
                ArrayList<TextureCategory> textureCatList = new ArrayList<TextureCategory>();
                ListComponent cloakLibrary = this.listBuilder.getTextureElement("Cloak Library", textureCatList, 0, 3, texture -> {
                    String url = this.getUrl((TextureEntry)texture);
                    MoreCosmetics.debug("[TEXTURE] Set texture: " + url);
                    if (this.validTexture(url)) {
                        this.getUser().getCloak().update(url);
                        cloakSwitch.update(this.getUser().getCloak().isActive());
                        this.mod.getUserHandler().checkSettingsChanged();
                    }
                });
                cloakLibrary.onDiscover(() -> TextureCategoryBuilder.fetchOnline("https://cl.cosmeticsmod.com/textures/cloaks.json", textureCatList::addAll));
                guiComponents.add(cloakLibrary);
                guiComponents.add(this.getFileSelectUpload(online, "Cloak", "cloaks", file -> {
                    MoreCosmetics.debug("[TEXTURE] Set texture: " + file.getAbsolutePath());
                    this.getUser().getCloak().update(file.getAbsolutePath());
                    cloakSwitch.update(this.getUser().getCloak().isActive());
                }, "png", "gif"));
                if (CompatibilityManager.FEATURE_SELECT_CLOAK_RENDER) {
                    guiComponents.add(this.listBuilder.getSwitchElement("Use Minecraft Renderer", config.cloakCompatibility, false, enabled -> {
                        config.cloakCompatibility = enabled;
                    }).setDescription(LanguageHandler.get("cloakcompatibility")));
                }
            }, true));
        }
        list.add(BoxManager.SEPARATION_LINE);
        if (online) {
            list.add(new BoxCategory("Store", "cart").setCallback(() -> {
                String storeUrl = this.mod.getInfo().store;
                if (storeUrl != null) {
                    this.mod.getVersionAdapter().showConfirmDialog("CosmeticsMod Store", this.getRedirectionMsg(storeUrl), () -> this.mod.getVersionAdapter().openBrowser(storeUrl));
                }
            }));
        }
        list.add(new BoxCategory("Profile", "profile").fillEntries(guiComponents -> {
            boolean connected = this.mod.getConnection().isConnected();
            guiComponents.add(this.listBuilder.getTextElement("Username", this.mod.getVersionAdapter().getPlayerName()));
            guiComponents.add(this.listBuilder.getTextElement("Status", connected ? "\u00a7aConnected" : "\u00a7cNot connected"));
            if (connected) {
                guiComponents.add(this.listBuilder.getTextElement("First Start", MoreCosmetics.DATE_FORMAT.format(this.mod.getUserHandler().getFirstJoin())));
                guiComponents.add(this.listBuilder.getTextElement("Login Streak", this.mod.getUserHandler().getLoginStreak() + ""));
                guiComponents.add(this.listBuilder.getTextElement("Online Cosmetics", this.mod.getUserHandler().getOnlineCount() + " / " + this.mod.getModelLoader().getOnlineCount()));
            } else {
                guiComponents.add(this.listBuilder.getButtonElement("Connect", () -> this.mod.getConnection().reconnectAttempt(success -> {
                    if (success.booleanValue()) {
                        ModelGui.refreshGui();
                        NotificationHandler.sendSuccess("Connection", LanguageHandler.get("connectionsuccess"));
                    } else {
                        NotificationHandler.sendError(LanguageHandler.get("connectionfailed"));
                    }
                })));
            }
            if (this.mod.getUserHandler().hasOnlineNametag()) {
                guiComponents.add(this.listBuilder.getButtonElement("Change online Nametag", () -> Authenticator.getAuthenticator().openPanel()));
            }
        }, true));
        list.add(new BoxCategory("Presets", "presets").fillEntries(guiComponents -> {
            guiComponents.add(this.listBuilder.getButtonElement("Add new Preset", () -> {
                if (System.currentTimeMillis() - this.lastProfileAdded < 2000L) {
                    return;
                }
                this.lastProfileAdded = System.currentTimeMillis();
                int presets = this.presetManager.getPresets().size();
                if (presets < 100) {
                    String name = "Preset #" + (presets + 1);
                    this.presetManager.saveToProfile(name, this.mod.getUserHandler().getCurrentUser(), this.isOnline());
                    ModelGui.refreshGui();
                } else {
                    NotificationHandler.sendError("You can't have more than 100 presets!");
                }
            }));
            guiComponents.add(this.listBuilder.getListElement("Sort by", Stream.of(PresetManager.SortMode.values()).map(Enum::name).collect(Collectors.toList()), this.presetManager.getMode().ordinal(), mode -> {
                this.presetManager.setMode(PresetManager.SortMode.valueOf(mode));
                this.presetManager.sortPresets();
                ModelGui.refreshGui();
            }));
            guiComponents.add(this.listBuilder.getSeparationElement((online ? "Online" : "Offline") + " User Presets", UIConstants.UI_SEPARATION_COLOR));
            this.presetManager.getPresets().stream().filter(pr -> pr.isOnline() == online).forEach(preset -> guiComponents.add(this.listBuilder.getButtonElement(preset.getName(), "Load", () -> {
                this.presetManager.applyPreset(this.mod.getUserHandler().getCurrentUser(), (UserPreset)preset);
                NotificationHandler.sendSuccess("Preset", "Preset loaded!");
                ModelGui.refreshGui();
            }).fillChild(subList -> {
                Consumer<String> cb = name -> {
                    if (name.length() > 0 && !name.trim().isEmpty()) {
                        this.presetManager.updateName((UserPreset)preset, (String)name);
                        ModelGui.refreshGui();
                    }
                };
                subList.add(this.listBuilder.getTextBoxElement("Name", preset.getName(), cb, null, null, cb, 20));
                subList.add(this.listBuilder.getButtonElement("Overwrite", () -> {
                    this.presetManager.updatePreset((UserPreset)preset, this.mod.getUserHandler().getCurrentUser());
                    NotificationHandler.sendSuccess("Preset", "Preset updated!");
                    ModelGui.refreshGui();
                }));
                subList.add(this.listBuilder.getButtonElement("Delete", () -> {
                    this.presetManager.deletePreset((UserPreset)preset);
                    NotificationHandler.sendSuccess("Preset", "Preset deleted!");
                    ModelGui.refreshGui();
                }));
                subList.add(this.listBuilder.getSwitchElement("Load Cosmetics", preset.cosmetics, false, enabled -> this.presetManager.updateApplies((UserPreset)preset, (boolean)enabled, preset.cloak, preset.nametag)));
                subList.add(this.listBuilder.getSwitchElement("Load Cloak", preset.cloak, false, enabled -> this.presetManager.updateApplies((UserPreset)preset, config.cosmetics, (boolean)enabled, preset.nametag)));
                subList.add(this.listBuilder.getSwitchElement("Load Nametag", preset.nametag, false, enabled -> this.presetManager.updateApplies((UserPreset)preset, preset.cosmetics, preset.cloak, (boolean)enabled)));
            })));
        }, true));
        list.add(new BoxCategory("Settings", "settings").fillEntries(guiComponents -> {
            guiComponents.add(this.listBuilder.getSeparationElement("General", UIConstants.UI_SEPARATION_COLOR));
            if (CompatibilityManager.shouldShowName()) {
                guiComponents.add(this.listBuilder.getSwitchElement("Show Name", config.showName, false, enabled -> {
                    config.showName = enabled;
                }));
            }
            guiComponents.add(this.listBuilder.getSwitchElement("Show Preview", config.showPreview, false, enabled -> {
                config.showPreview = enabled;
            }));
            guiComponents.add(this.listBuilder.getSwitchElement("Show Cosmetics", config.cosmetics, false, enabled -> {
                config.cosmetics = enabled;
            }));
            guiComponents.add(this.listBuilder.getSwitchElement("Show Nametags", config.nametags, false, enabled -> {
                config.nametags = enabled;
            }));
            guiComponents.add(this.listBuilder.getSwitchElement("Show Cloaks", config.cloaks, false, enabled -> {
                config.cloaks = enabled;
            }));
            guiComponents.add(this.listBuilder.getSliderElement("Rainbow Speed", 1, 10, config.rainbowSpeed, i -> {
                config.rainbowSpeed = i;
            }, 60, true));
            guiComponents.add(this.listBuilder.getSeparationElement("Cosmetic Behavior", UIConstants.UI_SEPARATION_COLOR));
            guiComponents.add(this.listBuilder.getSwitchElement("Hide When Wearing Armor", config.armorMode, false, enabled -> {
                config.armorMode = enabled;
            }).setDescription(LanguageHandler.get("armormode")));
            if (CompatibilityManager.FEATURE_REPLACE_SHIELD) {
                guiComponents.add(this.listBuilder.getSwitchElement("Replace Minecraft Shield", config.replaceShield, false, enabled -> {
                    config.replaceShield = enabled;
                }));
            }
            if (CompatibilityManager.FEATURE_DAMAGE_TINT) {
                guiComponents.add(this.listBuilder.getSwitchElement("Display Damage Tint", config.damageTint, false, enabled -> {
                    config.damageTint = enabled;
                }));
            }
            guiComponents.add(this.listBuilder.getSeparationElement("GUI", UIConstants.UI_SEPARATION_COLOR));
            guiComponents.add(this.listBuilder.getSwitchElement("Custom Font", config.customFont, false, enabled -> {
                config.customFont = enabled;
                this.mod.getFontHandler().setCustomFont(config.customFont);
            }));
            guiComponents.add(this.listBuilder.getSwitchElement("Animated Preview", config.animatedPreview, false, enabled -> {
                config.animatedPreview = enabled;
            }));
            guiComponents.add(this.listBuilder.getColorPickerElement("Accent Color", config.accentColor, UIConstants.UI_ACCENT_COLOR, true, i -> {
                UIConstants.UI_ACCENT_COLOR = config.accentColor = i.intValue();
            }));
            guiComponents.add(this.listBuilder.getKeyBoxElement("Open GUI Key", config.key, key -> {
                config.key = key;
            }));
            guiComponents.add(this.listBuilder.getSliderElement("GUI Scale", 1, 10, config.guiScale, i -> {
                config.guiScale = i;
                this.mod.getVersionAdapter().setGuiScale(0.5f + (float)config.guiScale / 20.0f);
            }, 60, false));
            if (onModdingPlatform) {
                guiComponents.add(this.listBuilder.getListElement("GUI Open Mode", Stream.of(OpenMode.values()).map(Enum::name).collect(Collectors.toList()), config.openMode, mode -> {
                    config.openMode = OpenMode.valueOf(mode).ordinal();
                }));
            } else if (config.openMode != OpenMode.ALL.ordinal()) {
                config.openMode = OpenMode.ALL.ordinal();
            }
            guiComponents.add(this.listBuilder.getSeparationElement("Userdata", UIConstants.UI_SEPARATION_COLOR));
            guiComponents.add(this.listBuilder.getButtonElement("Refresh Userdata", () -> this.mod.getUserHandler().reload(() -> {
                this.guiInstance.refreshGui();
                NotificationHandler.sendInfo("Settings", "Userdata refreshed");
            })));
            guiComponents.add(this.listBuilder.getButtonElement("Sync Userdata", () -> this.mod.getUserHandler().sync(() -> {
                this.guiInstance.refreshGui();
                NotificationHandler.sendInfo("Settings", "Userdata synced!");
            })));
            guiComponents.add(this.listBuilder.getButtonElement("Reset Userdata", () -> this.mod.getVersionAdapter().showConfirmDialog("Reset", LanguageHandler.get("datareset"), () -> {
                this.mod.getConnection().sendAsync(new PacketInfo(EnumInfo.RESET_DATA));
                this.mod.getUserHandler().resetData();
                this.guiInstance.refreshGui();
                NotificationHandler.sendInfo("Settings", "Userdata reset!");
            })).setDescription(LanguageHandler.get("resetinfo")));
            guiComponents.add(this.listBuilder.getSeparationElement("Editor", UIConstants.UI_SEPARATION_COLOR));
            guiComponents.add(this.listBuilder.getSwitchElement("Editor Mode", config.editorMode, false, enabled -> {
                config.editorMode = enabled;
                LocalServer.toggle(enabled);
                this.guiInstance.refreshGui();
                NotificationHandler.sendInfo("Settings", "Editor Mode: " + (enabled != false ? "\u00a7aON" : "\u00a7cOFF"));
            }));
            guiComponents.add(this.listBuilder.getButtonElement("Open Folder", () -> this.mod.getVersionAdapter().openFile(this.modelLoader.getLoadDir())));
            guiComponents.add(this.listBuilder.getButtonElement("Reload Cosmetics", () -> {
                this.modelLoader.loadCustomModels();
                this.guiInstance.refreshGui();
                NotificationHandler.sendInfo("Settings", "Cosmetics reloaded!");
            }));
            guiComponents.add(this.listBuilder.getSeparationElement("Debug", UIConstants.UI_SEPARATION_COLOR));
            guiComponents.add(this.listBuilder.getButtonElement("Debug Info", () -> {
                String debugInfo = DebugInfo.getClientInfo();
                MoreCosmetics.debug(debugInfo);
                this.mod.getVersionAdapter().copyToClipboard(debugInfo);
                NotificationHandler.sendInfo("Settings", "Copied to clipboard!");
            }).setDescription(LanguageHandler.get("debuginfo")));
            guiComponents.add(this.listBuilder.getButtonElement("Debug Console", DebugConsole::open));
            guiComponents.add(this.listBuilder.getSeparationElement("Miscellaneous", UIConstants.UI_SEPARATION_COLOR));
            guiComponents.add(this.listBuilder.getButtonElement("Credentials", () -> this.mod.getVersionAdapter().openBrowser("https://cosmeticsmod.com/credits")));
            guiComponents.add(this.listBuilder.getButtonElement("Privacy Policy", () -> this.mod.getVersionAdapter().openBrowser("https://cosmeticsmod.com/privacy")));
        }, true));
        UIConstants.UI_ACCENT_COLOR = config.accentColor;
    }

    @Override
    public void onGuiClosed() {
        this.mod.getUserHandler().saveUserConfig();
        ModConfig.saveConfig();
    }

    private ListComponent getFileSelectUpload(boolean online, String texture, String folder, Consumer<File> fileSelector, String ... ext) {
        ListComponent comp = online ? this.listBuilder.getButtonElement(texture + " Upload", () -> {
            if (this.lastTextureUpload != this.getUser().getCosmetics().size()) {
                this.lastTextureUpload = this.getUser().getCosmetics().size();
                this.mod.getConnection().sendAsync(new PacketInfo(EnumInfo.TEXTURE_LOGIN));
            }
            this.mod.getVersionAdapter().showConfirmDialog(texture + " Upload", this.getRedirectionMsg(this.mod.getUserHandler().getUploadUrl()), () -> this.mod.getVersionAdapter().openBrowser(this.mod.getUserHandler().getUploadUrl()));
        }) : this.listBuilder.getButtonElement("File Selector", () -> this.openCopyFileChooser(folder, "Texture file", fileSelector, ext));
        return comp;
    }

    /*
     * Unable to fully structure code
     */
    private BoxComponent getComponent(CosmeticModel model) {
        element = this.boxBuilder.getCosmeticElement(model, this.getUser(), (Consumer<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getComponent$68(com.cosmeticsmod.morecosmetics.models.model.CosmeticModel java.lang.Boolean ), (Ljava/lang/Boolean;)V)((ModelGui)this, (CosmeticModel)model));
        if (ModConfig.getConfig().editorMode && model.isCustom()) {
            element.getChildComponents().add(this.listBuilder.getButtonElement("Editor", (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$getComponent$69(com.cosmeticsmod.morecosmetics.models.model.CosmeticModel ), ()V)((ModelGui)this, (CosmeticModel)model)));
        }
        if (!model.hasConfig()) {
            return element;
        }
        element.getChildComponents().add(this.listBuilder.getSeparationElement(model.getName()));
        data = this.getUser().getCosmetics().getOrDefault(model.getId(), this.mod.getUserHandler().loadData(model, true));
        block9: for (ModelConfig config : model.getConfig()) {
            type = SettingType.byId(config.type);
            if (type == null) continue;
            v0 = defaultVal = data != null ? ConfigAccessor.get(config, data) : config.value;
            if (data == null && config.mult != 1.0f && defaultVal instanceof Number) {
                defaultVal = Float.valueOf(((Number)defaultVal).floatValue() / config.mult);
            }
            comp = null;
            switch (1.$SwitchMap$com$cosmeticsmod$morecosmetics$models$config$SettingType[type.ordinal()]) {
                case 1: {
                    if (config.min != 0 || config.max != 0) {
                        vF = (float)config.min / config.mult;
                        vT = (float)config.max / config.mult;
                        bool = defaultVal != null && ((Number)defaultVal).floatValue() == vT;
                        comp = this.listBuilder.getSwitchElement(config.name, bool, true, (Consumer<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getComponent$70(com.cosmeticsmod.morecosmetics.models.config.ModelConfig com.cosmeticsmod.morecosmetics.models.model.CosmeticModel float float java.lang.Boolean ), (Ljava/lang/Boolean;)V)((ModelGui)this, (ModelConfig)config, (CosmeticModel)model, (float)vT, (float)vF));
                    } else {
                        bool = defaultVal != null && (Boolean)defaultVal != false;
                        comp = this.listBuilder.getSwitchElement(config.name, bool, true, (Consumer<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getComponent$71(com.cosmeticsmod.morecosmetics.models.config.ModelConfig com.cosmeticsmod.morecosmetics.models.model.CosmeticModel java.lang.Boolean ), (Ljava/lang/Boolean;)V)((ModelGui)this, (ModelConfig)config, (CosmeticModel)model));
                    }
                    ** GOTO lbl61
                }
                case 2: {
                    if (config.src != null && config.src.startsWith("http")) {
                        textureCatList = new ArrayList<TextureCategory>();
                        comp = this.listBuilder.getTextureElement(config.name, textureCatList, 0, config.max == 0 ? 3 : config.max, (Consumer<TextureEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getComponent$72(com.cosmeticsmod.morecosmetics.models.config.ModelConfig com.cosmeticsmod.morecosmetics.models.model.CosmeticModel com.cosmeticsmod.morecosmetics.gui.core.box.utils.BoxComponent com.cosmeticsmod.morecosmetics.gui.core.texture.TextureEntry ), (Lcom/cosmeticsmod/morecosmetics/gui/core/texture/TextureEntry;)V)((ModelGui)this, (ModelConfig)config, (CosmeticModel)model, (BoxComponent)element));
                        comp.onDiscover((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$getComponent$73(com.cosmeticsmod.morecosmetics.models.config.ModelConfig java.util.ArrayList ), ()V)((ModelConfig)config, textureCatList));
                        element.getChildComponents().add(comp);
                        element.getChildComponents().add(this.getFileSelectUpload(this.mod.getUserHandler().isOnlineMode(), "Texture", model.getName().toLowerCase(), (Consumer<File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getComponent$74(com.cosmeticsmod.morecosmetics.models.config.ModelConfig com.cosmeticsmod.morecosmetics.models.model.CosmeticModel java.io.File ), (Ljava/io/File;)V)((ModelGui)this, (ModelConfig)config, (CosmeticModel)model), new String[]{"png", "gif"}));
                        continue block9;
                    }
                }
                case 3: {
                    str = defaultVal == null ? "" : (String)defaultVal;
                    cb = (Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getComponent$75(com.cosmeticsmod.morecosmetics.models.config.ModelConfig com.cosmeticsmod.morecosmetics.models.model.CosmeticModel java.lang.String ), (Ljava/lang/String;)V)((ModelGui)this, (ModelConfig)config, (CosmeticModel)model);
                    comp = this.listBuilder.getTextBoxElement(config.name, str, cb, cb, null);
                    ** GOTO lbl61
                }
                case 4: {
                    currentVal = defaultVal == null ? 0.0f : ((Number)defaultVal).floatValue();
                    comp = this.listBuilder.getSliderElement(config.name, config.min, config.max, (int)(currentVal * config.mult), (Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getComponent$76(com.cosmeticsmod.morecosmetics.models.config.ModelConfig com.cosmeticsmod.morecosmetics.models.model.CosmeticModel java.lang.Integer ), (Ljava/lang/Integer;)V)((ModelGui)this, (ModelConfig)config, (CosmeticModel)model));
                    ** GOTO lbl61
                }
                case 5: {
                    currentItem = defaultVal == null ? 0 : ((Number)defaultVal).intValue();
                    comp = this.listBuilder.getNumberBoxElement(config.name, 1, 426, currentItem, (Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getComponent$77(com.cosmeticsmod.morecosmetics.models.config.ModelConfig com.cosmeticsmod.morecosmetics.models.model.CosmeticModel java.lang.Integer ), (Ljava/lang/Integer;)V)((ModelGui)this, (ModelConfig)config, (CosmeticModel)model));
                    ** GOTO lbl61
                }
                case 6: {
                    currentNum = defaultVal == null ? 0 : ((Number)defaultVal).intValue();
                    comp = this.listBuilder.getNumberBoxElement(config.name, config.min, config.max, currentNum, (Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getComponent$78(com.cosmeticsmod.morecosmetics.models.config.ModelConfig com.cosmeticsmod.morecosmetics.models.model.CosmeticModel java.lang.Integer ), (Ljava/lang/Integer;)V)((ModelGui)this, (ModelConfig)config, (CosmeticModel)model));
                    ** GOTO lbl61
                }
                case 7: {
                    currentColor = defaultVal == null ? 0 : ((Number)defaultVal).intValue();
                    currentColor = currentColor == 1 ? currentColor : -16777216 | currentColor;
                    defaultColor = currentColor == 1 ? ((Number)config.value).intValue() : currentColor;
                    comp = this.listBuilder.getColorPickerElement(config.name, currentColor, defaultColor, config.min == 0, (Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getComponent$79(com.cosmeticsmod.morecosmetics.models.config.ModelConfig com.cosmeticsmod.morecosmetics.models.model.CosmeticModel java.lang.Integer ), (Ljava/lang/Integer;)V)((ModelGui)this, (ModelConfig)config, (CosmeticModel)model));
                }
lbl61:
                // 8 sources

                default: {
                    element.getChildComponents().add(comp);
                }
            }
        }
        return element;
    }

    private boolean validTexture(String url) {
        if (!this.mod.getUserHandler().isOnlineMode()) {
            return true;
        }
        return url == null || TextureCategoryBuilder.isNoMaskNeeded(url);
    }

    private void applyColors(CosmeticModel model, ArrayList<ListComponent> components, TextureEntry texture) {
        if (texture == null) {
            return;
        }
        int[] colors = texture.getColors();
        if (colors == null) {
            return;
        }
        int index = 0;
        for (ModelConfig colorConf : model.getConfig()) {
            int color;
            if (colorConf.type != SettingType.COLOR.getId()) continue;
            if (index >= colors.length) break;
            if ((color = colors[index++]) == -1) continue;
            this.update(colorConf, model.getId(), color);
        }
        index = 0;
        for (ListComponent component : components) {
            int color;
            if (component.getType() != SettingType.COLOR.getId()) continue;
            if (index >= colors.length) break;
            if ((color = colors[index++]) == -1) continue;
            component.update(color);
        }
    }

    private void openCopyFileChooser(String folder, String title, Consumer<File> callback, String ... extensions) {
        File textureDir = new File(MoreCosmetics.ROOT_DIR, "textures/" + folder);
        textureDir.mkdirs();
        this.mod.getVersionAdapter().openFileChooser(title, textureDir, file -> {
            if (!file.getParentFile().equals(textureDir)) {
                try {
                    File target = new File(textureDir, file.getName());
                    Files.copy(file.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    callback.accept(target);
                }
                catch (IOException e) {
                    MoreCosmetics.catchThrowable(e);
                    callback.accept((File)file);
                }
            }
        }, title, extensions);
    }

    private String getRedirectionMsg(String url) {
        int trim = url.indexOf("/", 10);
        if (trim != -1 && url.length() > trim) {
            url = url.substring(0, trim + 1);
        }
        return String.format(LanguageHandler.get("redirection"), url);
    }

    private String getUrl(TextureEntry texture) {
        if (texture == null) {
            return null;
        }
        return texture.getImageURL();
    }

    public void update(ModelConfig config, int id, Object obj) {
        ModelData data = this.getUser().getCosmetics().get(id);
        if (data != null) {
            ConfigAccessor.set(config, data, obj);
            this.mod.getUserHandler().saveData(id, data);
        }
    }

    public String getHeadline() {
        String headLine = "\u00a7fPowered by CosmeticsMod";
        return headLine;
    }

    public boolean isOnline() {
        return this.mod.getUserHandler().isOnlineMode();
    }

    private boolean isValid(int itemID) {
        return !ArrayUtils.contains((int[])NONVALID, (int)itemID);
    }

    private CosmeticUser getUser() {
        return this.mod.getUserHandler().getCurrentUser();
    }

    public static ModelGui getInstance() {
        return instance;
    }

    public static void refreshGui() {
        if (instance != null) {
            ModelGui.instance.guiInstance.refreshGui();
        }
    }

    private /* synthetic */ void lambda$getComponent$79(ModelConfig config, CosmeticModel model, Integer rgb) {
        this.update(config, model.getId(), rgb);
    }

    private /* synthetic */ void lambda$getComponent$78(ModelConfig config, CosmeticModel model, Integer id) {
        this.update(config, model.getId(), (int)id);
    }

    private /* synthetic */ void lambda$getComponent$77(ModelConfig config, CosmeticModel model, Integer id) {
        if (this.isValid(id)) {
            this.update(config, model.getId(), (int)id);
        }
    }

    private /* synthetic */ void lambda$getComponent$76(ModelConfig config, CosmeticModel model, Integer i) {
        this.update(config, model.getId(), Float.valueOf((float)i.intValue() / config.mult));
    }

    private /* synthetic */ void lambda$getComponent$75(ModelConfig config, CosmeticModel model, String url) {
        this.update(config, model.getId(), url);
    }

    private /* synthetic */ void lambda$getComponent$74(ModelConfig config, CosmeticModel model, File file) {
        MoreCosmetics.debug("[TEXTURE] Set texture: " + file.getAbsolutePath());
        this.update(config, model.getId(), file.getAbsolutePath());
    }

    private static /* synthetic */ void lambda$getComponent$73(ModelConfig config, ArrayList textureCatList) {
        TextureCategoryBuilder.fetchOnline(config.src, textureCatList::addAll);
    }

    private /* synthetic */ void lambda$getComponent$72(ModelConfig config, CosmeticModel model, BoxComponent element, TextureEntry texture) {
        String url = this.getUrl(texture);
        MoreCosmetics.debug("[TEXTURE] Set texture: " + url);
        if (this.validTexture(url)) {
            this.update(config, model.getId(), url);
            this.applyColors(model, element.getChildComponents(), texture);
        }
    }

    private /* synthetic */ void lambda$getComponent$71(ModelConfig config, CosmeticModel model, Boolean enabled) {
        this.update(config, model.getId(), enabled);
    }

    private /* synthetic */ void lambda$getComponent$70(ModelConfig config, CosmeticModel model, float vT, float vF, Boolean enabled) {
        this.update(config, model.getId(), Float.valueOf(enabled != false ? vT : vF));
    }

    private /* synthetic */ void lambda$getComponent$69(CosmeticModel model) {
        this.mod.getVersionAdapter().showEditorScreen(model);
    }

    private /* synthetic */ void lambda$getComponent$68(CosmeticModel model, Boolean enabled) {
        this.mod.getUserHandler().toggleCosmetic(enabled, model);
    }

    static {
        NONVALID = new int[]{8, 9, 10, 11, 26, 34, 36, 43, 51, 55, 59, 60, 62, 63, 64, 68, 71, 74, 75, 83, 90, 92, 93, 94, 104, 105, 115, 117, 118, 119, 124, 125, 127, 132, 140, 141, 142, 144, 149, 150};
    }
}

