/*
 * Decompiled with CFR 0.152.
 */
package com.cosmeticsmod.morecosmetics.loader;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.launchwrapper.LogWrapper;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;

public class MoreCosmeticsTweaker
implements ITweaker {
    private String version;
    private String versionName;
    private List<String> args;
    private File gameDir;
    private File assetsDir;
    private boolean alreadyTransformed;

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        this.args = args;
        this.gameDir = gameDir;
        this.assetsDir = assetsDir;
        this.version = this.getVersion(args);
        if (this.version == null) {
            MoreCosmeticsTweaker.log(Level.ERROR, "Unsupported version!");
            return;
        }
        this.versionName = this.getVersionName(args);
        this.alreadyTransformed = this.checkForName("EventCaller");
        if (!this.alreadyTransformed) {
            MoreCosmeticsTweaker.log(Level.INFO, "Initializing MoreCosmetics Mixins for version " + this.version);
            MixinBootstrap.init();
            MixinEnvironment environment = MixinEnvironment.getDefaultEnvironment();
            environment.setSide(MixinEnvironment.Side.CLIENT);
            environment.setObfuscationContext("notch");
            Mixins.addConfiguration((String)"mixins.morecosmetics.json");
        }
    }

    public void injectIntoClassLoader(LaunchClassLoader loader) {
        try {
            Class compatibilityManager = loader.loadClass("com.cosmeticsmod.morecosmetics.utils.CompatibilityManager");
            compatibilityManager.getDeclaredField("VERSION").set(null, this.version);
            compatibilityManager.getDeclaredField("INSTALLATION").set(null, this.versionName);
            compatibilityManager.getDeclaredField("PLATFORM").set(null, "Vanilla");
            if (this.alreadyTransformed) {
                Field field = loader.loadClass("net.minecraftforge.common.MinecraftForge").getDeclaredField("EVENT_BUS");
                Object tickWrapper = loader.loadClass("v" + this.version.replace(".", "_") + ".morecosmetics.compatibility.forge.TickWrapper").newInstance();
                field.getType().getDeclaredMethod("register", Object.class).invoke(field.get(null), tickWrapper);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] getLaunchArguments() {
        List argList = (List)Launch.blackboard.get("ArgumentList");
        if (!argList.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(this.args);
        arguments.add("--version");
        arguments.add(this.args.get(3));
        if (this.gameDir != null) {
            arguments.add("--gameDir");
            arguments.add(this.gameDir.getPath());
        }
        if (this.assetsDir != null) {
            arguments.add("--assetsDir");
            arguments.add(this.assetsDir.getPath());
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    public String getLaunchTarget() {
        return "net.minecraft.client.main.Main";
    }

    private String getVersion(List<String> args) {
        String[] versions;
        for (String version : versions = new String[]{"1.8", "1.16"}) {
            if (!args.contains(version)) continue;
            return version;
        }
        return null;
    }

    private String getVersionName(List<String> args) {
        int i = args.indexOf("--versionName");
        if (i > 0 && args.size() > i + 1) {
            return args.get(i + 1);
        }
        return null;
    }

    private boolean checkForName(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void log(Level level, String msg) {
        try {
            LogWrapper.log((Level)level, (String)("[MoreCosmetics] " + msg), (Object[])new Object[0]);
        }
        catch (Error e) {
            System.out.println("[MoreCosmetics] " + msg);
        }
    }
}

