/*
 * Decompiled with CFR 0.152.
 */
package com.cosmeticsmod.morecosmetics.networking;

import com.cosmeticsmod.morecosmetics.MoreCosmetics;
import com.cosmeticsmod.morecosmetics.gui.ModelGui;
import com.cosmeticsmod.morecosmetics.gui.core.UIConstants;
import com.cosmeticsmod.morecosmetics.gui.core.notification.Notification;
import com.cosmeticsmod.morecosmetics.gui.core.notification.NotificationHandler;
import com.cosmeticsmod.morecosmetics.networking.ClientPacketHandler;
import com.cosmeticsmod.morecosmetics.networking.packets.PacketCosmeticUpdate;
import com.cosmeticsmod.morecosmetics.networking.packets.PacketInfo;
import com.cosmeticsmod.morecosmetics.user.UserHandler;
import com.cosmeticsmod.morecosmetics.utils.LanguageHandler;

public class InfoPacketHandler
implements ClientPacketHandler {
    @Override
    public void handle(PacketInfo info) {
        MoreCosmetics mod = MoreCosmetics.getInstance();
        UserHandler userHandler = mod.getUserHandler();
        switch (info.getInfo()) {
            case NAMETAG_UPDATE: {
                mod.getConnection().send(new PacketCosmeticUpdate(new byte[]{-1}, userHandler.getNearbyUsers()));
                userHandler.loadUserData(userHandler.getCurrentUser(), () -> NotificationHandler.sendSuccess("Nametag Update", LanguageHandler.get("updatenametag")), false, true);
                break;
            }
            case COSMETIC_UPDATE_ACCEPTED: {
                userHandler.updateUserWhitelist();
                userHandler.loadUserData(userHandler.getCurrentUser(), () -> NotificationHandler.sendSuccess("Cosmetic Update", LanguageHandler.get("updatesuccess")), true, true);
                break;
            }
            case COSMETIC_UPDATE_REJECTED: {
                NotificationHandler.sendNotification(new Notification(LanguageHandler.get("error"), "morecosmetics/gui/icons/reject.png", UIConstants.DISABLED_COLOR, LanguageHandler.get("updaterejected")));
                userHandler.loadUserData(userHandler.getCurrentUser(), ModelGui::refreshGui, true, true);
                break;
            }
        }
    }
}

