/*
 * Decompiled with CFR 0.152.
 */
package com.cosmeticsmod.morecosmetics.networking.handler;

import com.cosmeticsmod.morecosmetics.MoreCosmetics;
import com.cosmeticsmod.morecosmetics.networking.NettyClient;
import com.cosmeticsmod.morecosmetics.networking.handler.PacketBuf;
import com.cosmeticsmod.morecosmetics.networking.handler.PacketInitialisation;
import com.cosmeticsmod.morecosmetics.networking.packets.Packet;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.util.List;
import javax.crypto.Cipher;

public class PacketDecoder
extends ByteToMessageDecoder {
    private NettyClient client;
    private Cipher decryptionCipher;

    public PacketDecoder(NettyClient c) {
        this.client = c;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        PacketBuf fetched = null;
        if (this.decryptionCipher != null) {
            byte[] encrypted = new byte[in.readableBytes()];
            in.readBytes(encrypted);
            byte[] decrypted = this.decryptionCipher.doFinal(encrypted);
            fetched = new PacketBuf(decrypted);
        } else {
            fetched = new PacketBuf(in);
        }
        if (fetched.readableBytes() == 0) {
            NettyClient.log("Can't decode empty packet");
            return;
        }
        int packet_id = fetched.readVarInt();
        try {
            Packet packet = PacketInitialisation.getInstance().getPacket(packet_id);
            packet.read(fetched);
            out.add(packet);
        }
        catch (IOException e) {
            NettyClient.log(packet_id + " has no default construtor");
        }
    }

    public void activateDecryption(Cipher decryptionCipher) {
        this.decryptionCipher = decryptionCipher;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        NettyClient.log("Failed to decode packet properly");
        MoreCosmetics.catchThrowable(cause);
        this.client.disconnect();
    }
}

