/*
 * Decompiled with CFR 0.152.
 */
package com.cosmeticsmod.morecosmetics.networking.handler;

import com.cosmeticsmod.morecosmetics.MoreCosmetics;
import com.cosmeticsmod.morecosmetics.gui.ModelGui;
import com.cosmeticsmod.morecosmetics.gui.core.notification.NotificationHandler;
import com.cosmeticsmod.morecosmetics.networking.NettyClient;
import com.cosmeticsmod.morecosmetics.networking.handler.PacketDecoder;
import com.cosmeticsmod.morecosmetics.networking.handler.PacketEncoder;
import com.cosmeticsmod.morecosmetics.networking.handler.PacketInitialisation;
import com.cosmeticsmod.morecosmetics.networking.packets.Packet;
import com.cosmeticsmod.morecosmetics.networking.packets.PacketAESKey;
import com.cosmeticsmod.morecosmetics.networking.packets.PacketComplete;
import com.cosmeticsmod.morecosmetics.networking.packets.PacketInfo;
import com.cosmeticsmod.morecosmetics.networking.packets.PacketKick;
import com.cosmeticsmod.morecosmetics.networking.packets.PacketServerHash;
import com.cosmeticsmod.morecosmetics.networking.utils.CryptionUtils;
import com.cosmeticsmod.morecosmetics.networking.utils.EnumDisconnection;
import com.cosmeticsmod.morecosmetics.networking.utils.EnumInfo;
import com.cosmeticsmod.morecosmetics.utils.LanguageHandler;
import com.cosmeticsmod.morecosmetics.utils.SharedVars;
import com.cosmeticsmod.morecosmetics.utils.VersionAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.security.KeyPair;
import javax.crypto.Cipher;

public class PacketHandler
extends SimpleChannelInboundHandler<Packet> {
    private NettyClient client;
    private KeyPair keyPair;
    private String serverHash;

    public PacketHandler(NettyClient client) {
        this.client = client;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Packet packet) throws Exception {
        MoreCosmetics.debug("[CONNECTION] IN: " + packet.getClass().getSimpleName() + (packet.getContent() != null ? " | " + packet.getContent() : ""));
        if (PacketInitialisation.getInstance().doesNeedVerify(packet) && this.client.isVerified()) {
            packet.handle(this.client);
        } else if (!PacketInitialisation.getInstance().doesNeedVerify(packet)) {
            int packet_id = PacketInitialisation.getInstance().getPacketId(packet);
            if (packet_id == 2) {
                PacketAESKey packetAES = (PacketAESKey)packet;
                byte[] key = CryptionUtils.decryptRSA(packetAES.getKey(), this.keyPair.getPrivate());
                byte[] iv = CryptionUtils.decryptRSA(packetAES.getIv(), this.keyPair.getPrivate());
                if (iv.length != 12 || key.length != 16) {
                    NettyClient.log("Received invalid aes key");
                    this.client.disconnect();
                }
                Cipher encryptCipher = CryptionUtils.generateCipher(key, 1, iv);
                Cipher decryptCipher = CryptionUtils.generateCipher(key, 2, iv);
                this.client.send(new PacketInfo(EnumInfo.ACCEPTED_AESKEY));
                PacketDecoder decoder = (PacketDecoder)ctx.pipeline().get(PacketDecoder.class);
                PacketEncoder encoder = (PacketEncoder)ctx.pipeline().get(PacketEncoder.class);
                decoder.activateDecryption(decryptCipher);
                encoder.activateEncryption(encryptCipher);
            } else if (packet_id == 3) {
                PacketInfo packetInfo = (PacketInfo)packet;
                this.client.getPacketHandler().handle(packetInfo);
            } else if (packet_id == 4) {
                PacketServerHash packetHash = (PacketServerHash)packet;
                this.serverHash = packetHash.getServerHash();
                VersionAdapter va = MoreCosmetics.getInstance().getVersionAdapter();
                if (va.authenticate(this.serverHash)) {
                    this.client.send(new PacketInfo(EnumInfo.VERIFY_HASHJOIN_REQUEST));
                } else {
                    if (va.isInGame()) {
                        NotificationHandler.sendError(LanguageHandler.get("noconnection"));
                    }
                    MoreCosmetics.log("Playing in offline mode!");
                    SharedVars.OFFLINE_MODE = true;
                    this.client.setKicked();
                }
            } else if (packet_id == 5) {
                PacketKick packetKick = (PacketKick)packet;
                if (packetKick.getDisconnect() != EnumDisconnection.SHUTDOWN) {
                    this.client.setKicked();
                }
                this.client.disconnect();
                NettyClient.log("Client kicked for: " + packetKick.getDisconnect().getMessage());
                ModelGui.refreshGui();
            } else if (packet_id == 6) {
                PacketComplete packetComplete = (PacketComplete)packet;
                NettyClient.log("Login complete!");
                this.client.completedLogin();
                MoreCosmetics.getInstance().getUserHandler().setLoginData(packetComplete);
                ModelGui.refreshGui();
            }
        } else {
            NettyClient.log("Server tried to send non verified packets");
            this.client.disconnect();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        MoreCosmetics.debugThrowable(cause);
        this.client.disconnect();
    }

    public void setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
    }
}

