/*
 * Decompiled with CFR 0.152.
 */
package com.cosmeticsmod.morecosmetics.networking.packets;

import com.cosmeticsmod.morecosmetics.networking.NettyClient;
import com.cosmeticsmod.morecosmetics.networking.handler.PacketBuf;
import com.cosmeticsmod.morecosmetics.networking.packets.Packet;
import java.io.IOException;

public class PacketDataContainer
implements Packet {
    private String key;
    private byte[] data;

    public PacketDataContainer() {
    }

    public PacketDataContainer(String key, byte[] data) {
        this.key = key;
        this.data = data;
    }

    @Override
    public void write(PacketBuf buf) throws IOException {
        buf.writeString(this.key);
        buf.writeVarInt(this.data.length);
        buf.writeBytes(this.data);
    }

    @Override
    public void read(PacketBuf buf) throws IOException {
        this.key = buf.readString();
        this.data = new byte[buf.readVarInt()];
        buf.readBytes(this.data);
    }

    @Override
    public void handle(NettyClient client) {
        if (client.getPacketHandler() != null) {
            client.getPacketHandler().handle(this);
        }
    }

    public String getKey() {
        return this.key;
    }

    public byte[] getData() {
        return this.data;
    }
}

