/*
 * Decompiled with CFR 0.152.
 */
package com.cosmeticsmod.morecosmetics.networking.packets;

import com.cosmeticsmod.morecosmetics.MoreCosmetics;
import com.cosmeticsmod.morecosmetics.gui.ModelGui;
import com.cosmeticsmod.morecosmetics.gui.core.notification.NotificationHandler;
import com.cosmeticsmod.morecosmetics.networking.NettyClient;
import com.cosmeticsmod.morecosmetics.networking.handler.PacketBuf;
import com.cosmeticsmod.morecosmetics.networking.packets.Packet;
import com.cosmeticsmod.morecosmetics.networking.packets.PacketCosmeticUpdate;
import com.cosmeticsmod.morecosmetics.user.UserHandler;
import com.cosmeticsmod.morecosmetics.utils.LanguageHandler;
import java.io.IOException;

public class PacketTextureUpdate
implements Packet {
    private String type;
    private String url;

    @Override
    public void read(PacketBuf buf) throws IOException {
        this.type = buf.readString();
        this.url = buf.readString();
    }

    @Override
    public void handle(NettyClient client) {
        UserHandler handler = MoreCosmetics.getInstance().getUserHandler();
        client.send(new PacketCosmeticUpdate(new byte[]{-1}, handler.getNearbyUsers()));
        handler.loadUserData(handler.getCurrentUser(), () -> {
            ModelGui.refreshGui();
            NotificationHandler.sendSuccess("Texture Update", LanguageHandler.get("updatesuccess"));
        }, false, true);
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }
}

