/*
 * Decompiled with CFR 0.152.
 */
package v1_21_4.morecosmetics;

import com.cosmeticsmod.morecosmetics.MoreCosmetics;
import com.cosmeticsmod.morecosmetics.gui.core.UIConstants;
import com.cosmeticsmod.morecosmetics.models.config.ModelData;
import com.cosmeticsmod.morecosmetics.models.model.CosmeticModel;
import com.cosmeticsmod.morecosmetics.nametags.font.CustomFontRenderer;
import com.cosmeticsmod.morecosmetics.utils.MathUtils;
import com.cosmeticsmod.morecosmetics.utils.SharedVars;
import com.cosmeticsmod.morecosmetics.utils.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_742;
import net.minecraft.class_898;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.lwjgl.opengl.GL11;
import v1_21_4.morecosmetics.models.renderer.ModelCosmeticRenderer;
import v1_21_4.morecosmetics.models.renderer.QuaternionHelper;
import v1_21_4.morecosmetics.models.renderer.StackHolder;

@Environment(value=EnvType.CLIENT)
public class DrawUtils {
    private static CustomFontRenderer customFontRenderer;
    private static boolean preview;

    public static void drawTexture(float x, float y, float imageWidth, float imageHeight, float maxWidth, float maxHeight, float alpha, int color, class_2960 id) {
        class_4587 stack = StackHolder.STACK;
        stack.method_22903();
        float sizeWidth = maxWidth / imageWidth;
        float sizeHeight = maxHeight / imageHeight;
        stack.method_22905(sizeWidth, sizeHeight, 0.0f);
        if (alpha < 1.0f || color != -1) {
            RenderSystem.enableBlend();
            if (color != -1) {
                RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            }
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)id);
        DrawUtils.drawTexturedModalRect(stack.method_23760().method_23761(), x / sizeWidth, y / sizeHeight, x / sizeWidth + imageWidth, y / sizeHeight + imageHeight);
        if (alpha < 1.0f || color != -1) {
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        stack.method_22909();
    }

    public static void drawHorizontalGradient(int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        Matrix4f matrix = StackHolder.STACK.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        bufferbuilder.method_22918(matrix, (float)right, (float)top, 0.0f).method_22915(f1, f2, f3, f);
        bufferbuilder.method_22918(matrix, (float)left, (float)top, 0.0f).method_22915(f5, f6, f7, f4);
        bufferbuilder.method_22918(matrix, (float)left, (float)bottom, 0.0f).method_22915(f5, f6, f7, f4);
        bufferbuilder.method_22918(matrix, (float)right, (float)bottom, 0.0f).method_22915(f1, f2, f3, f);
        class_286.method_43433((class_9801)bufferbuilder.method_60800());
        RenderSystem.disableBlend();
    }

    public static void drawToolTip(String tooltip, int mouseX, int mouseY) {
        int width = DrawUtils.getStringWidth(tooltip);
        class_4587 stack = StackHolder.STACK;
        stack.method_22903();
        stack.method_46416(0.0f, 0.0f, 200.0f);
        DrawUtils.drawRoundedRect(mouseX + 2, mouseY - 3, mouseX + width + 8, mouseY + 11, UIConstants.UI_SEPARATION_COLOR);
        DrawUtils.drawRoundedRect(mouseX + 3, mouseY - 2, mouseX + width + 7, mouseY + 10, UIConstants.UI_COMPONENT_COLOR);
        DrawUtils.drawString(tooltip, mouseX + 5, mouseY);
        stack.method_22909();
    }

    public static void drawDarkOverlay(int width, int height) {
        DrawUtils.drawRect(0, 0, width, height, -1072689136);
    }

    public static void drawRect(int left, int top, int right, int bottom, int color) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        Matrix4f matrix = StackHolder.STACK.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix, (float)left, (float)bottom, 0.0f).method_22915(r, g, b, a);
        bufferBuilder.method_22918(matrix, (float)right, (float)bottom, 0.0f).method_22915(r, g, b, a);
        bufferBuilder.method_22918(matrix, (float)right, (float)top, 0.0f).method_22915(r, g, b, a);
        bufferBuilder.method_22918(matrix, (float)left, (float)top, 0.0f).method_22915(r, g, b, a);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.disableBlend();
    }

    public static void drawRoundedRect(int left, int top, int right, int bottom, int color) {
        DrawUtils.drawRoundedRect(left, top, right, bottom, color, 2);
    }

    public static void drawRoundedWindowRect(int left, int top, int right, int bottom, int color) {
        DrawUtils.drawRoundedRect(left, top, right, bottom, color, 5);
    }

    public static void drawRoundedRect(int left, int top, int right, int bottom, int color, int rad) {
        DrawUtils.drawRoundedRect(left, top, right, bottom, color, rad, 36);
    }

    public static void drawRoundedRect(int left, int top, int right, int bottom, int color, int rad, int points) {
        DrawUtils.drawRoundedRectOuter(left + rad, top + rad, right - rad, bottom - rad, color, rad, points);
    }

    public static void drawRoundedRectOuter(int left, int top, int right, int bottom, int color, int rad, int points) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        Matrix4f matrix = StackHolder.STACK.method_23760().method_23761();
        DrawUtils.drawCircleQuarter(matrix, left, top, rad, 36, 1, r, g, b, a);
        DrawUtils.drawCircleQuarter(matrix, left, bottom, rad, 36, 2, r, g, b, a);
        DrawUtils.drawCircleQuarter(matrix, right, bottom, rad, 36, 3, r, g, b, a);
        DrawUtils.drawCircleQuarter(matrix, right, top, rad, 36, 4, r, g, b, a);
        DrawUtils.drawRectPart(matrix, left, top + rad, right, bottom - rad, r, g, b, a);
        DrawUtils.drawRectPart(matrix, right, top, right - rad, bottom, r, g, b, a);
        DrawUtils.drawRectPart(matrix, left + rad, top, left, bottom, r, g, b, a);
        RenderSystem.disableBlend();
    }

    private static void drawRectPart(Matrix4f matrix, int left, int top, int right, int bottom, float r, float g, float b, float a) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix, (float)left, (float)bottom, 0.0f).method_22915(r, g, b, a);
        bufferBuilder.method_22918(matrix, (float)right, (float)bottom, 0.0f).method_22915(r, g, b, a);
        bufferBuilder.method_22918(matrix, (float)right, (float)top, 0.0f).method_22915(r, g, b, a);
        bufferBuilder.method_22918(matrix, (float)left, (float)top, 0.0f).method_22915(r, g, b, a);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    private static void drawCircleQuarter(Matrix4f matrix, int x, int y, int rad, int points, int dir, float r, float g, float b, float a) {
        int quarter = (int)((double)points / 4.0);
        int start = dir * quarter - quarter;
        int end = dir * quarter;
        DrawUtils.drawCirclePart(matrix, x, y, rad, points, start, end, r, g, b, a);
    }

    private static void drawCirclePart(Matrix4f matrix, int x, int y, int rad, int points, int start, int end, float r, float g, float b, float a) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        bufferBuilder.method_22918(matrix, (float)x, (float)y, 0.0f).method_22915(r, g, b, a);
        for (int ii = start; ii <= end; ++ii) {
            float theta = 6.283185f * (float)ii / (float)points;
            float cx = (float)rad * MathUtils.cos(theta);
            float cy = (float)rad * MathUtils.sin(theta);
            bufferBuilder.method_22918(matrix, (float)x + cy, (float)y + cx, 0.0f).method_22915(r, g, b, a);
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    public static void drawEntryExtension(int x, int y, boolean tileVisible, boolean mouseOnSymbol) {
        DrawUtils.drawCenteredString(tileVisible ? "\u25bc" : "\u25b6", (float)(x + 6), (float)(y + 6), mouseOnSymbol || tileVisible ? UIConstants.ELEMENT_SELECTION_COLOR : UIConstants.UI_SEPARATION_COLOR);
    }

    public static void drawEntryBackground(int x, int y, int tileWidth, int slotHeight, boolean tileExtended) {
        DrawUtils.drawRect(x, y + 1, tileWidth, y + slotHeight - 1, Utils.toRGB(20, 20, 20, 50));
        DrawUtils.drawRect(x, y, tileWidth, y + slotHeight, Utils.toRGB(20, 20, 20, 150));
        DrawUtils.drawRect(x, y + 1, x + 1, y + slotHeight - 1, tileExtended ? UIConstants.ELEMENT_SELECTION_COLOR : UIConstants.UI_SEPARATION_COLOR);
    }

    public static int drawString(String text, float x, float y, int color) {
        if (customFontRenderer != null) {
            return customFontRenderer.drawString(text, x, y, 0xFF000000 | color, false);
        }
        class_4597.class_4598 consumerProvider = class_310.method_1551().method_22940().method_23000();
        return DrawUtils.getDefaultFontRenderer().method_27521(text, x, y, color, true, StackHolder.STACK.method_23760().method_23761(), (class_4597)consumerProvider, class_327.class_6415.field_33993, 0, 0xF000F0);
    }

    public static void abstractParentFill(class_4587 matrices, int x1, int y1, int x2, int y2, int color) {
        int i;
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        boolean z = false;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float f = (float)class_9848.method_61320((int)color) / 255.0f;
        float g = (float)class_9848.method_61327((int)color) / 255.0f;
        float h = (float)class_9848.method_61329((int)color) / 255.0f;
        float j = (float)class_9848.method_61331((int)color) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)z).method_22915(g, h, j, f);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, (float)z).method_22915(g, h, j, f);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, (float)z).method_22915(g, h, j, f);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, (float)z).method_22915(g, h, j, f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.disableBlend();
    }

    public static String trimStringToWidth(String text, int width, boolean reverse) {
        if (customFontRenderer != null) {
            return customFontRenderer.trimStringToWidth(text, width, reverse);
        }
        return DrawUtils.getDefaultFontRenderer().method_27524(text, width, reverse);
    }

    public static int getStringWidth(String text) {
        if (customFontRenderer != null) {
            return customFontRenderer.getStringWidth(text);
        }
        return DrawUtils.getDefaultFontRenderer().method_1727(text);
    }

    public static CustomFontRenderer getCustomFontRenderer() {
        return customFontRenderer;
    }

    public static void setCustomFontRenderer(CustomFontRenderer customFontRenderer) {
        DrawUtils.customFontRenderer = customFontRenderer;
    }

    public static int drawString(String text, float x, float y) {
        return DrawUtils.drawString(text, x, y, UIConstants.UI_TEXT_COLOR);
    }

    public static void drawString(String text, float x, float y, float size) {
        DrawUtils.drawString(text, x, y, size, UIConstants.UI_TEXT_COLOR);
    }

    public static void drawString(String text, float x, float y, float size, int color) {
        class_4587 stack = StackHolder.STACK;
        stack.method_22903();
        stack.method_22905(size, size, size);
        DrawUtils.drawString(text, x / size, y / size, color);
        stack.method_22909();
    }

    public static void drawCenteredString(String text, float x, float y, float size, int color) {
        class_4587 stack = StackHolder.STACK;
        stack.method_22903();
        stack.method_22905(size, size, size);
        DrawUtils.drawCenteredString(text, x / size, y / size, color);
        stack.method_22909();
    }

    public static void drawCenteredString(String text, float x, float y, float size) {
        DrawUtils.drawCenteredString(text, x, y, size, UIConstants.UI_TEXT_COLOR);
    }

    public static int drawCenteredString(String text, float x, float y, int color) {
        return DrawUtils.drawString(text, x - (float)(DrawUtils.getStringWidth(text) / 2), y, color);
    }

    public static int drawCenteredString(String text, float x, float y) {
        return DrawUtils.drawCenteredString(text, x, y, UIConstants.UI_TEXT_COLOR);
    }

    public static void drawRawTexture(float x, float y, float imageWidth, float imageHeight, float maxWidth, float maxHeight) {
        class_4587 stack = StackHolder.STACK;
        stack.method_22903();
        float sizeWidth = maxWidth / imageWidth;
        float sizeHeight = maxHeight / imageHeight;
        stack.method_22905(sizeWidth, sizeHeight, 0.0f);
        DrawUtils.drawTexturedModalRect(stack.method_23760().method_23761(), x / sizeWidth, y / sizeHeight, x / sizeWidth + imageWidth, y / sizeHeight + imageHeight);
        stack.method_22909();
    }

    public static void drawTexturedModalRect(Matrix4f matrix, float left, float top, float right, float bottom) {
        float textureX = 0.0f;
        float textureY = 0.0f;
        float width = right - left;
        float height = bottom - top;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader((class_10156)class_10142.field_53879);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, left, top + height, 0.0f).method_22913(textureX * f, (textureY + height) * f1);
        bufferBuilder.method_22918(matrix, left + width, top + height, 0.0f).method_22913((textureX + width) * f, (textureY + height) * f1);
        bufferBuilder.method_22918(matrix, left + width, top, 0.0f).method_22913((textureX + width) * f, textureY * f1);
        bufferBuilder.method_22918(matrix, left, top, 0.0f).method_22913(textureX * f, textureY * f1);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.disableBlend();
    }

    public static void drawTextureWithLight(float x, float y, float imageWidth, float imageHeight, float maxWidth, float maxHeight, int color, int light, class_2960 id, class_4597 provider) {
        float sizeWidth = maxWidth / imageWidth;
        float sizeHeight = maxHeight / imageHeight;
        class_4587 stack = StackHolder.STACK;
        stack.method_22903();
        stack.method_22905(sizeWidth, sizeHeight, 0.0f);
        int overlay = class_4608.field_21444;
        float left = x / sizeWidth;
        float top = y / sizeHeight;
        float right = x / sizeWidth + imageWidth;
        float bottom = y / sizeHeight + imageHeight;
        float textureX = 0.0f;
        float textureY = 0.0f;
        float width = right - left;
        float height = bottom - top;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        class_4588 bufferBuilder = provider.getBuffer(class_1921.method_23576((class_2960)id));
        Matrix4f matrix = StackHolder.STACK.method_23760().method_23761();
        bufferBuilder.method_22918(matrix, left, top + height, 0.0f).method_22915(red, green, blue, alpha).method_22913(textureX * f, (textureY + height) * f1).method_22922(overlay).method_60803(light).method_22914(0.0f, 0.0f, 1.0f);
        bufferBuilder.method_22918(matrix, left + width, top + height, 0.0f).method_22915(red, green, blue, alpha).method_22913((textureX + width) * f, (textureY + height) * f1).method_22922(overlay).method_60803(light).method_22914(0.0f, 0.0f, 1.0f);
        bufferBuilder.method_22918(matrix, left + width, top, 0.0f).method_22915(red, green, blue, alpha).method_22913((textureX + width) * f, textureY * f1).method_22922(overlay).method_60803(light).method_22914(0.0f, 0.0f, 1.0f);
        bufferBuilder.method_22918(matrix, left, top, 0.0f).method_22915(red, green, blue, alpha).method_22913(textureX * f, textureY * f1).method_22922(overlay).method_60803(light).method_22914(0.0f, 0.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.method_22909();
    }

    public static void drawDebugAxis(float size) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2848);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glLineWidth((float)size);
        GL11.glBegin((int)2);
        GL11.glColor3f((float)0.0f, (float)255.0f, (float)0.0f);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)1.0, (double)0.0);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)255.0f);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)-1.0, (double)0.0, (double)0.0);
        GL11.glColor3f((float)255.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)-1.0);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)2848);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawEntityOnScreen(int x, int y, int size, float mouseX, float mouseY, int rotationX, int rotationY, int rotationZ, class_1309 entity) {
        preview = true;
        StackHolder stack = StackHolder.getInstance();
        stack.push();
        stack.translate(x, y, 100.0f);
        stack.scale((float)(-size) - 30.0f, (float)size + 30.0f, size);
        stack.rotateZ(180.0f);
        float h = entity.field_6283;
        float i = entity.method_36454();
        float j = entity.method_36455();
        float k = entity.field_6259;
        float l = entity.field_6241;
        stack.rotateY(135.0f);
        stack.rotateY(-135 + rotationX);
        stack.rotateX(rotationY);
        stack.rotateZ(rotationZ);
        stack.rotateX(-((float)Math.atan(mouseY / 40.0f)) * 20.0f);
        stack.translate(0.0f, 0.0f, 0.0f);
        entity.field_6283 = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        entity.method_36456((float)Math.atan(mouseX / 40.0f) * 40.0f);
        entity.method_36457(-((float)Math.atan(mouseY / 40.0f)) * 20.0f);
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_308.method_24210();
        class_898 renderManager = class_310.method_1551().method_1561();
        Quaternionf quaternion = QuaternionHelper.getQuaternion(0.0f, 180.0f, 0.0f, true);
        renderManager.method_24196(quaternion);
        renderManager.method_3948(false);
        class_4597.class_4598 consumerProvider = class_310.method_1551().method_22940().method_23000();
        renderManager.method_62424((class_1297)entity, 0.0, rotationY == 0 ? 0.0 : -1.0, 0.0, 1.0f, (class_4587)stack.get(), (class_4597)consumerProvider, 0xF00000);
        consumerProvider.method_22993();
        renderManager.method_3948(true);
        entity.field_6283 = h;
        entity.method_36456(i);
        entity.method_36457(j);
        entity.field_6259 = k;
        entity.field_6241 = l;
        class_308.method_24211();
        stack.pop();
        preview = false;
    }

    public static void renderCosmeticPreview(CosmeticModel model, int x, int y, float size, float rotX, float rotY, float rotZ, boolean background) {
        StackHolder stack = StackHolder.getInstance();
        stack.push();
        stack.translate(x, y, 100.0f);
        stack.scale(-size - 30.0f, size + 30.0f, size);
        stack.rotateZ(180.0f);
        stack.rotateY(135.0f);
        stack.rotate(rotY, -135.0f + rotX, rotZ);
        stack.translate(0.0f, 0.0f, 0.0f);
        float scale = background ? 1.0f : 0.5f;
        stack.scale(-scale, -scale, scale);
        scale = model.getPreviewScale();
        stack.translate(-0.05f, model.getPreviewY(), 0.0f);
        stack.scale(scale, scale, scale);
        float[] rot = model.getPreviewRot();
        if (rot != null) {
            stack.rotateX(rot[0]);
            stack.rotateY(rot[1]);
            stack.rotateZ(rot[2]);
        }
        class_308.method_24210();
        class_310 mc = class_310.method_1551();
        MoreCosmetics mod = MoreCosmetics.getInstance();
        ModelData data = mod.getUserHandler().getCurrentUser().getCosmetics().get(model.getId());
        data = data == null ? mod.getUserHandler().loadData(model, true) : data;
        ModelCosmeticRenderer renderer = (ModelCosmeticRenderer)mod.getModelHandler();
        class_4597.class_4598 consumerProvider = mc.method_22940().method_23000();
        renderer.renderCosmetic((class_4587)stack.get(), (class_4597)consumerProvider, 0xF000F0, (class_742)mc.field_1724, null, model, data, 0.0f, 0.0f, SharedVars.RENDER_TICKS, 0.0f, 0.0f, 0.0f, null, true, false);
        consumerProvider.method_22993();
        class_308.method_24211();
        stack.pop();
    }

    public static int getFontHeight() {
        Objects.requireNonNull(DrawUtils.getDefaultFontRenderer());
        return 9;
    }

    public static class_327 getDefaultFontRenderer() {
        return class_310.method_1551().field_1772;
    }

    public static boolean inPreview() {
        return preview;
    }
}

