/*
 * Decompiled with CFR 0.152.
 */
package v1_21_4.morecosmetics.gui;

import com.cosmeticsmod.morecosmetics.gui.core.UIConstants;
import com.cosmeticsmod.morecosmetics.gui.core.notification.AnimationState;
import com.cosmeticsmod.morecosmetics.gui.core.notification.Notification;
import com.cosmeticsmod.morecosmetics.gui.core.notification.NotificationHandler;
import com.cosmeticsmod.morecosmetics.utils.MathUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import v1_21_4.morecosmetics.DrawUtils;
import v1_21_4.morecosmetics.models.renderer.StackHolder;
import v1_21_4.morecosmetics.models.textures.CustomTextureManager;

@Environment(value=EnvType.CLIENT)
public class NotificationManager
extends NotificationHandler {
    private static CustomTextureManager textureManager = CustomTextureManager.getGlobalInstance();

    @Override
    public void draw(Object stack, int width) {
        if (notifications.isEmpty()) {
            return;
        }
        if (width == -1) {
            width = class_310.method_1551().method_22683().method_4486();
        }
        this.drawNotificationTopRight(stack, width);
    }

    private void drawNotificationTopRight(Object oldStack, int width) {
        int currentHeight = 24;
        class_4587 stack = StackHolder.STACK;
        for (int i = 1; i >= 0; --i) {
            int animationMove;
            if (notifications.size() <= i) continue;
            Notification notification = (Notification)notifications.get(i);
            if (notification.getInitTime() == 0L) {
                notification.setInitTime();
                notification.setAnimationState(AnimationState.IN);
            }
            int n = animationMove = notification.getAnimationState() == AnimationState.NONE ? 0 : (int)Math.round(MathUtils.easeInBack(notification.getAnimationIndex()) * 100.0) - 200;
            if (notification.getAnimationState() != AnimationState.NONE) {
                notification.addAnimationsIndex();
                if (notification.getAnimationState() == AnimationState.IN && notification.getAnimationIndex() >= 2.0) {
                    notification.setAnimationState(AnimationState.NONE);
                }
                if (notification.getAnimationState() == AnimationState.OUT && notification.getAnimationIndex() >= 4.0) {
                    notification.setAnimationState(AnimationState.NONE);
                }
            }
            stack.method_22903();
            stack.method_46416(0.0f, 0.0f, 200.0f);
            DrawUtils.drawRect(width - this.getWholeWidth() - animationMove, currentHeight, width - animationMove, currentHeight + this.getWholeHeight(notification.getLines().length), UIConstants.UI_COMPONENT_COLOR);
            DrawUtils.drawRect(width - this.getWholeWidth() - 1 - animationMove, currentHeight, width - this.getWholeWidth() - animationMove, currentHeight + this.getWholeHeight(notification.getLines().length), notification.getRemainingColor());
            float timeRemainPercentage = (float)(System.currentTimeMillis() - notification.getInitTime()) / 4000.0f;
            timeRemainPercentage = Math.min(timeRemainPercentage, 1.0f);
            int drawDuration = (int)(timeRemainPercentage * (float)this.getWholeHeight(notification.getLines().length));
            DrawUtils.drawRect(width - this.getWholeWidth() - 1 - animationMove, currentHeight + this.getWholeHeight(notification.getLines().length), width - this.getWholeWidth() - animationMove, currentHeight + drawDuration, notification.getProgressColor());
            DrawUtils.drawString(notification.getTitle(), width - this.getWholeWidth() + 7 + 16 + 7 - animationMove, currentHeight + 7);
            for (int j = 0; j < notification.getLines().length; ++j) {
                String line = notification.getLines()[j];
                DrawUtils.drawString(line, width - this.getWholeWidth() + 7 + 16 + 7 - animationMove, currentHeight + 7 + 5 + DrawUtils.getFontHeight() * (j + 1));
            }
            if (notification.getLogo() != null) {
                class_2960 id = textureManager.getResource("notification-" + notification.getTitle(), notification.getLogo());
                DrawUtils.drawTexture(width - this.getWholeWidth() + 7 - animationMove, currentHeight + 7, 256.0f, 256.0f, 16.0f, 16.0f, 1.0f, UIConstants.TEXURE_COLOR, id);
            }
            stack.method_22909();
            if (System.currentTimeMillis() - notification.getInitTime() > 4000L && notification.getAnimationState() == AnimationState.NONE && notification.getAnimationIndex() < 4.0) {
                notification.setAnimationState(AnimationState.OUT);
            }
            if (System.currentTimeMillis() - notification.getInitTime() > 4000L && notification.getAnimationState() == AnimationState.NONE) {
                notifications.remove(notification);
            }
            currentHeight += 4 + this.getWholeHeight(notification.getLines().length);
        }
    }

    @Override
    public int getStringWidth(String text) {
        return DrawUtils.getStringWidth(text);
    }

    @Override
    public int getWholeHeight(int lineLength) {
        return 19 + DrawUtils.getFontHeight() * (lineLength + 1);
    }
}

