/*
 * Decompiled with CFR 0.152.
 */
package v1_21_4.morecosmetics.gui.components;

import com.cosmeticsmod.morecosmetics.gui.core.UIConstants;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import v1_21_4.morecosmetics.DrawUtils;

@Environment(value=EnvType.CLIENT)
public class GuiCheckBox {
    private static final class_2960 CROSS = class_2960.method_60654((String)"morecosmetics/gui/icons/close.png");
    private Color boxColor;
    private boolean selected;
    private int xPosition;
    private int yPosition;
    private int width;
    private int height;
    private boolean enabled = true;

    public GuiCheckBox(int x, int y, int boxWidth, int boxHeight, Color boxColor) {
        this.xPosition = x;
        this.yPosition = y;
        this.width = boxWidth;
        this.height = boxHeight;
        this.boxColor = boxColor;
    }

    public void drawCheckBox(int mouseX, int mouseY) {
        DrawUtils.drawRoundedRect(this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + this.height, this.enabled ? UIConstants.UI_SEPARATION_COLOR : this.getTransparentBoxColor(this.boxColor));
        DrawUtils.drawRoundedRect(this.xPosition + 1, this.yPosition + 1, this.xPosition + this.width - 1, this.yPosition + this.height - 1, this.enabled ? UIConstants.UI_COMPONENT_COLOR : this.getTransparentBoxColor(new Color(UIConstants.UI_COMPONENT_COLOR)));
        if (this.selected) {
            DrawUtils.drawTexture(this.xPosition + 2, this.yPosition + this.height / 2 - 5, 256.0f, 256.0f, 10.0f, 10.0f, 0.99f, -1, CROSS);
        }
    }

    public boolean mousePressed(int mouseX, int mouseY) {
        boolean pressed;
        boolean bl = pressed = this.enabled && this.isHovered(mouseX, mouseY);
        if (pressed) {
            this.selected = !this.selected;
        }
        return pressed;
    }

    private boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    private int getTransparentBoxColor(Color c) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), 100).getRGB();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

