/*
 * Decompiled with CFR 0.152.
 */
package v1_21_4.morecosmetics.gui.elements.box;

import com.cosmeticsmod.morecosmetics.MoreCosmetics;
import com.cosmeticsmod.morecosmetics.gui.ModelGui;
import com.cosmeticsmod.morecosmetics.gui.core.UIConstants;
import com.cosmeticsmod.morecosmetics.gui.core.box.utils.BoxComponent;
import com.cosmeticsmod.morecosmetics.models.model.CosmeticModel;
import com.cosmeticsmod.morecosmetics.user.CosmeticUser;
import com.cosmeticsmod.morecosmetics.utils.LanguageHandler;
import com.cosmeticsmod.morecosmetics.utils.ModConfig;
import com.cosmeticsmod.morecosmetics.utils.SharedVars;
import com.cosmeticsmod.morecosmetics.utils.Utils;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import v1_21_4.morecosmetics.DrawUtils;

@Environment(value=EnvType.CLIENT)
public class CosmeticElement
extends BoxComponent {
    private static CosmeticElement selected;
    private static class_2960 settingsIcon;
    private static class_2960 hourglassIcon;
    private CosmeticModel model;
    private CosmeticUser user;
    private Consumer<Boolean> toggleCallback;
    private boolean cosmeticEnabled;
    private boolean mouseOverSettings;
    private boolean extended;
    private int animationIndex;
    private int startRot;
    private float startBounce;

    public CosmeticElement(CosmeticModel model, CosmeticUser user, Consumer<Boolean> toggleCallback) {
        super(model.getName(), true);
        this.model = model;
        this.user = user;
        this.toggleCallback = toggleCallback;
        this.cosmeticEnabled = user.hasCosmetic(model.getId());
    }

    @Override
    public void drawComponent(Object stack, int x, int y, int compWidth, int compHeight, int mouseX, int mouseY) {
        boolean switching = this.mouseOver;
        super.drawComponent(stack, x, y, compWidth, compHeight, mouseX, mouseY);
        if (selected != this && switching != this.mouseOver) {
            this.startRot = SharedVars.TICKS;
        }
        this.mouseOverSettings = this.hasChildComponents() ? mouseY > y + compHeight - 14 && mouseY < y + compHeight - 10 : false;
        DrawUtils.drawRoundedRect(x, y, x + compWidth, y + compHeight, this.cosmeticEnabled ? UIConstants.UI_ACCENT_COLOR : UIConstants.UI_SEPARATION_COLOR, 4);
        DrawUtils.drawRoundedRect(x + 1, y + 1, x + compWidth - 1, y + compHeight - 1, UIConstants.UI_COMPONENT_COLOR, 3);
        if (this.mouseOver || selected == this) {
            long time;
            int elapsed = SharedVars.TICKS - this.startRot;
            DrawUtils.drawRoundedRect(x + 1, y + 1, x + compWidth - 1, y + compHeight - 1, Utils.toRGB(50, 50, 50, 50), 3);
            if (ModConfig.getConfig().animatedPreview && elapsed > 15) {
                if (elapsed == 16) {
                    this.startBounce = this.getBounce();
                }
                DrawUtils.renderCosmeticPreview(this.model, x + 38, y + 20, this.enabled ? 1.0f : 32.0f, (190 + elapsed - 15) % 360, this.getBounce() - this.startBounce - 4.0f, 0.0f, this.enabled);
            } else {
                DrawUtils.renderCosmeticPreview(this.model, x + 38, y + 20, this.enabled ? 1.0f : 32.0f, 190.0f, -4.0f, 0.0f, this.enabled);
            }
            if (this.model.hasConfig()) {
                DrawUtils.drawTexture(x + 2, y + 2, 256.0f, 256.0f, 8.0f, 8.0f, 1.0f, UIConstants.UI_DISABLED_COLOR, settingsIcon);
            }
            if (ModelGui.getInstance().isOnline() && (time = MoreCosmetics.getInstance().getUserHandler().getOnlineCosmetics().getOrDefault(this.model.getId(), -1L).longValue()) != -1L) {
                DrawUtils.drawTexture(x + compWidth - 10, y + 2, 256.0f, 256.0f, 8.0f, 8.0f, 1.0f, UIConstants.EXIT_NEUTRAL_COLOR, hourglassIcon);
                if (mouseX >= x + compWidth - 10 && mouseX <= x + compWidth && mouseY >= y + 2 && mouseY <= y + 10) {
                    String until = LanguageHandler.get("until") + " " + MoreCosmetics.DATE_FORMAT.format(time * 1000L);
                    DrawUtils.drawToolTip(until, mouseX, mouseY);
                }
            }
        } else {
            DrawUtils.renderCosmeticPreview(this.model, x + 38, y + 20, this.enabled ? 1.0f : 32.0f, 190.0f, -4.0f, 0.0f, this.enabled);
        }
        DrawUtils.drawCenteredString(this.model.getName(), (float)(x + compWidth / 2), (float)(y + compHeight - 8), 0.7f);
        if (!this.enabled) {
            DrawUtils.drawRoundedRect(x, y, x + compWidth, y + compHeight, Utils.toRGB(0, 0, 0, 100), 4);
        }
        ++this.animationIndex;
    }

    private float getBounce() {
        return (float)(50.0 * Math.cos(SharedVars.RENDER_TICKS / 10.0f) / 20.0);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (!this.mouseOver) {
            return;
        }
        if (mouseButton == 0) {
            boolean onSettings;
            boolean bl = onSettings = mouseX > this.x && mouseX < this.x + 10 && mouseY > this.y && mouseY < this.y + 10;
            if (onSettings && this.hasChildComponents()) {
                this.showExtension();
            } else {
                this.parentBoxManager.setExtensionVisible(false);
                this.cosmeticEnabled = !this.cosmeticEnabled;
                this.toggleCallback.accept(this.cosmeticEnabled);
                this.extended = false;
                selected = null;
            }
        } else if (mouseButton == 1 && this.hasChildComponents()) {
            this.showExtension();
        }
    }

    private void showExtension() {
        if (this.extended) {
            this.parentBoxManager.setExtensionVisible(false);
            this.extended = false;
        } else {
            this.extended = true;
            this.parentBoxManager.setExtensionVisible(true, this);
            this.cosmeticEnabled = true;
            this.toggleCallback.accept(true);
            selected = this;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled && selected == this) {
            selected = null;
        }
    }

    public CosmeticModel getModel() {
        return this.model;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    static {
        settingsIcon = class_2960.method_60654((String)"morecosmetics/gui/icons/settings.png");
        hourglassIcon = class_2960.method_60654((String)"morecosmetics/gui/icons/hourglass.png");
    }
}

