/*
 * Decompiled with CFR 0.152.
 */
package v1_21_4.morecosmetics.gui.elements.list;

import com.cosmeticsmod.morecosmetics.gui.core.UIConstants;
import com.cosmeticsmod.morecosmetics.models.config.SettingType;
import com.cosmeticsmod.morecosmetics.utils.RainbowHandler;
import com.cosmeticsmod.morecosmetics.utils.Utils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import v1_21_4.morecosmetics.DrawUtils;
import v1_21_4.morecosmetics.gui.components.ClickableIcon;
import v1_21_4.morecosmetics.gui.components.CustomButton;
import v1_21_4.morecosmetics.gui.components.CustomTextBox;
import v1_21_4.morecosmetics.gui.components.GuiCheckBox;
import v1_21_4.morecosmetics.gui.elements.list.BaseElement;
import v1_21_4.morecosmetics.gui.screen.ScreenWrapper;
import v1_21_4.morecosmetics.gui.screen.UIScreen;

@Environment(value=EnvType.CLIENT)
public class ColorPickerElement
extends BaseElement {
    public static final class_2960 COLOR_PALETTE = class_2960.method_60654((String)"morecosmetics/gui/components/wheel.png");
    public static final int WIDTH = 18;
    public static final int HEIGHT = 18;
    private static BufferedImage colorPaletteImage;
    private int latestX;
    private int latestY;
    private int tileWidth;
    private int selectedColor;
    private int defaultColor;
    private boolean openedSelector;
    private boolean advanced;
    private boolean rainbowEnabled;
    private Consumer<Integer> callback;

    public ColorPickerElement(String title, int selectedColor, int defaultColor, boolean rainbowEnabled, Consumer<Integer> callback) {
        super(title);
        this.selectedColor = selectedColor;
        this.defaultColor = defaultColor;
        this.rainbowEnabled = rainbowEnabled;
        this.callback = callback;
        if (colorPaletteImage == null) {
            try {
                colorPaletteImage = ImageIO.read(((class_3298)class_310.method_1551().method_1478().method_14486(COLOR_PALETTE).get()).method_14482());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void update(Object value) {
        this.selectedColor = (Integer)value;
    }

    @Override
    public int getType() {
        return SettingType.COLOR.getId();
    }

    @Override
    public void drawComponent(Object stack, int x, int y, int compWidth, int compHeight, int mouseX, int mouseY) {
        super.drawComponent(stack, x, y, compWidth, compHeight, mouseX, mouseY);
        this.latestX = x;
        this.latestY = y;
        this.tileWidth = x + compWidth;
        DrawUtils.drawRoundedRect(this.tileWidth - 18 - 1, y + 1, this.tileWidth - 1, y + 18 + 1, UIConstants.UI_SEPARATION_COLOR, 3);
        DrawUtils.drawRoundedRect(this.tileWidth - 18, y + 2, this.tileWidth - 2, y + 18, this.selectedColor == 0 ? this.defaultColor : (this.selectedColor == 1 ? RainbowHandler.RAINBOW_VALUE : this.selectedColor));
        if (this.openedSelector && !this.advanced) {
            this.advanced = true;
            ScreenWrapper.displayOverlay(new ColorWheelGui(this));
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.isMouseOverColorField(mouseX, mouseY)) {
            this.openedSelector = !this.openedSelector;
            return;
        }
        this.openedSelector = false;
        super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private boolean isMouseOverColorField(int mouseX, int mouseY) {
        return mouseX > this.tileWidth - 18 - 1 && mouseX < this.tileWidth && mouseY > this.latestY && mouseY < this.latestY + 18;
    }

    private void setSelectedColor(int selectedColor) {
        this.selectedColor = selectedColor;
    }

    @Override
    public int getControlWidth() {
        return 18;
    }

    @Environment(value=EnvType.CLIENT)
    public class ColorWheelGui
    extends UIScreen {
        private ColorPickerElement colorPicker;
        private CustomTextBox fieldHexColor;
        private GuiCheckBox rainbowCheckbox;
        private CustomButton applyButton;
        private ClickableIcon exitIcon;
        private boolean validHex = true;
        private long lastClicked;
        private int mouseX;
        private int mouseY;
        private int selectedX;
        private int selectedY;
        private int brightnessDefault;
        private boolean leftPressed;

        public ColorWheelGui(ColorPickerElement colorPicker) {
            this.colorPicker = colorPicker;
            this.brightnessDefault = ColorPickerElement.this.selectedColor;
            this.exitIcon = new ClickableIcon(8, 8, "morecosmetics/gui/icons/close.png", false);
            this.exitIcon.setHoverColor(UIConstants.DISABLED_COLOR);
        }

        @Override
        public void initGui() {
            this.fieldHexColor = new CustomTextBox(this.width / 2 - 65, this.height / 4 + 115, 110, 16);
            this.fieldHexColor.setMaxLength(7);
            this.applyButton = new CustomButton(this.width / 2 + 26, this.height / 4 + 149, 40, 15, "Apply");
            this.rainbowCheckbox = new GuiCheckBox(this.width / 2 - 66, this.height / 4 + 149, 14, 14, new Color(UIConstants.UI_SEPARATION_COLOR));
            this.rainbowCheckbox.setEnabled(ColorPickerElement.this.rainbowEnabled);
            this.rainbowCheckbox.setSelected(ColorPickerElement.this.rainbowEnabled && ColorPickerElement.this.selectedColor == 1);
            this.updateHexText();
        }

        @Override
        public void drawScreen(int mouseX, int mouseY, float partialTicks) {
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            DrawUtils.drawRoundedWindowRect(this.width / 2 - 80 - 1, this.height / 4 + 23 - 64 - 1, this.width / 2 + 80 + 1, this.height / 4 + 170 + 1, UIConstants.UI_SEPARATION_COLOR);
            DrawUtils.drawRoundedWindowRect(this.width / 2 - 80, this.height / 4 + 23 - 64, this.width / 2 + 80, this.height / 4 + 170, UIConstants.UI_BACKGROUND_COLOR);
            DrawUtils.drawCenteredString(ColorPickerElement.this.title, (float)(this.width / 2), (float)(this.height / 4 - 35), -1);
            DrawUtils.drawTexture(this.width / 2 - 64, this.height / 4 + 43 - 64, 256.0f, 256.0f, 128.0f, 128.0f, 1.0f, UIConstants.TEXURE_COLOR, COLOR_PALETTE);
            if (System.currentTimeMillis() - this.lastClicked < 4000L) {
                float factor = 20.0f - (float)(System.currentTimeMillis() - this.lastClicked) / 200.0f;
                int crossHair = Utils.toRGB(0, 0, 0, (int)(10.0f * factor));
                DrawUtils.drawRect(this.selectedX - 2, this.selectedY + 1, this.selectedX + 3, this.selectedY, crossHair);
                DrawUtils.drawRect(this.selectedX, this.selectedY - 2, this.selectedX + 1, this.selectedY, crossHair);
                DrawUtils.drawRect(this.selectedX, this.selectedY + 1, this.selectedX + 1, this.selectedY + 3, crossHair);
            }
            DrawUtils.drawRoundedRect(this.width / 2 + 49 - 1, this.height / 4 + 115 - 1, this.width / 2 + 50 + 15 + 1, this.height / 4 + 115 + 16 + 1, UIConstants.UI_SEPARATION_COLOR, 3);
            DrawUtils.drawRoundedRect(this.width / 2 + 49, this.height / 4 + 115, this.width / 2 + 50 + 15, this.height / 4 + 115 + 16, ColorPickerElement.this.selectedColor == 1 ? RainbowHandler.RAINBOW_VALUE : ColorPickerElement.this.selectedColor);
            DrawUtils.drawRoundedRect(this.width / 2 - 65 - 1, this.height / 4 + 135 - 1, this.width / 2 + 65 + 1, this.height / 4 + 135 + 10 + 1, UIConstants.UI_SEPARATION_COLOR, 1);
            DrawUtils.drawHorizontalGradient(this.width / 2 - 65, this.height / 4 + 135, this.width / 2, this.height / 4 + 135 + 10, this.brightnessDefault, -16777216);
            DrawUtils.drawHorizontalGradient(this.width / 2, this.height / 4 + 135, this.width / 2 + 65, this.height / 4 + 135 + 10, Color.WHITE.getRGB(), this.brightnessDefault);
            if (ColorPickerElement.this.rainbowEnabled) {
                DrawUtils.drawString("Rainbow", this.width / 2 - 50, this.height / 4 + 152);
                this.rainbowCheckbox.drawCheckBox(mouseX, mouseY);
            }
            this.fieldHexColor.drawTextBox(mouseX, mouseY);
            this.applyButton.drawButton(mouseX, mouseY);
            this.exitIcon.drawIcon(this.width / 2 + 70, this.height / 4 - 39, mouseX, mouseY);
        }

        @Override
        protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            super.mouseClicked(mouseX, mouseY, mouseButton);
            boolean bl = this.leftPressed = mouseButton == 0;
            if (this.exitIcon.isHovered() || this.applyButton.mousePressed(mouseX, mouseY)) {
                ScreenWrapper.closeOverlay();
            } else if (this.rainbowCheckbox.mousePressed(mouseX, mouseY)) {
                int reset = ColorPickerElement.this.selectedColor == 1 ? ColorPickerElement.this.defaultColor : ColorPickerElement.this.selectedColor;
                ColorPickerElement.this.setSelectedColor(this.rainbowCheckbox.isSelected() ? 1 : reset);
                if (!this.rainbowCheckbox.isSelected()) {
                    this.updateHexText();
                }
                this.callback();
            }
            this.fieldHexColor.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        protected void mouseReleased(int mouseX, int mouseY, int state) {
            super.mouseReleased(mouseX, mouseY, state);
            this.leftPressed = false;
        }

        private boolean isLeftMouseButtonDown() {
            return this.leftPressed;
        }

        @Override
        public void handleMouseInput() {
            super.handleMouseInput();
            if (this.isLeftMouseButtonDown() && this.mouseX >= this.width / 2 - 64 && this.mouseX <= this.width / 2 + 64 && this.mouseY >= this.height / 4 + 43 - 64 && this.mouseY <= this.height / 4 + 43 + 64) {
                int x = (int)((float)(this.mouseX - (this.width / 2 - 64)) * 9.375f);
                int y = (int)((float)(this.mouseY - (this.height / 4 + 43 - 64)) * 9.375f);
                int color = colorPaletteImage.getRGB(x = Math.max(Math.min(x, colorPaletteImage.getWidth() - 1), 0), y = Math.max(Math.min(y, colorPaletteImage.getHeight() - 1), 0));
                if (color < 0) {
                    this.selectedX = this.mouseX;
                    this.selectedY = this.mouseY;
                    ColorPickerElement.this.setSelectedColor(color);
                    this.brightnessDefault = ColorPickerElement.this.selectedColor;
                    this.lastClicked = System.currentTimeMillis();
                    this.callback();
                    this.updateHexText();
                    if (this.rainbowCheckbox.isSelected()) {
                        this.rainbowCheckbox.setSelected(false);
                    }
                }
            }
            if (this.isLeftMouseButtonDown() && this.mouseX >= this.width / 2 - 64 && this.mouseX <= this.width / 2 + 64 && this.mouseY >= this.height / 4 + 134 + 2 && this.mouseY <= this.height / 4 + 134 + 10) {
                ColorPickerElement.this.selectedColor = this.getColorUnderMouse();
                this.callback();
                this.updateHexText();
                if (this.rainbowCheckbox.isSelected()) {
                    this.rainbowCheckbox.setSelected(false);
                }
            }
        }

        @Override
        protected void keyTyped(char typedChar, int keyCode) {
            if (keyCode == 1) {
                ScreenWrapper.closeOverlay();
            }
            if (this.fieldHexColor.textBoxKeyTyped(typedChar, keyCode)) {
                String hex = this.fieldHexColor.getText();
                if (!hex.startsWith("#")) {
                    hex = "#".concat(hex);
                    this.fieldHexColor.setText(hex);
                }
                if (hex.length() == 7) {
                    try {
                        this.colorPicker.setSelectedColor(Color.decode(hex).getRGB());
                        this.colorPicker.callback.accept(this.colorPicker.selectedColor);
                        this.validHex = true;
                        this.brightnessDefault = ColorPickerElement.this.selectedColor;
                        if (this.rainbowCheckbox.isSelected()) {
                            this.rainbowCheckbox.setSelected(false);
                        }
                    }
                    catch (Exception error) {
                        this.validHex = false;
                    }
                } else {
                    this.validHex = false;
                }
            }
        }

        @Override
        public void onGuiClosed() {
            this.colorPicker.advanced = false;
            this.colorPicker.openedSelector = false;
        }

        private void updateHexText() {
            Color cache = new Color(ColorPickerElement.this.selectedColor == 1 ? ColorPickerElement.this.defaultColor : ColorPickerElement.this.selectedColor);
            String hex = String.format("#%02x%02x%02x", cache.getRed(), cache.getGreen(), cache.getBlue());
            this.fieldHexColor.setText(hex);
        }

        private int getColorUnderMouse() {
            IntBuffer intbuffer = BufferUtils.createIntBuffer((int)1);
            int[] ints = new int[1];
            class_310 mc = class_310.method_1551();
            GL11.glReadPixels((int)((int)mc.field_1729.method_1603()), (int)((int)((double)mc.method_22683().method_4507() - mc.field_1729.method_1604())), (int)1, (int)1, (int)32993, (int)33639, (IntBuffer)intbuffer);
            intbuffer.get(ints);
            return new Color(ints[0]).getRGB();
        }

        private void callback() {
            ColorPickerElement.this.callback.accept(ColorPickerElement.this.selectedColor);
        }
    }
}

