/*
 * Decompiled with CFR 0.152.
 */
package v1_21_4.morecosmetics.gui.elements.list;

import com.cosmeticsmod.morecosmetics.gui.core.UIConstants;
import com.cosmeticsmod.morecosmetics.nametags.font.FontImage;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import v1_21_4.morecosmetics.DrawUtils;
import v1_21_4.morecosmetics.gui.components.ClickableIcon;
import v1_21_4.morecosmetics.gui.components.CustomButton;
import v1_21_4.morecosmetics.gui.elements.list.BaseElement;
import v1_21_4.morecosmetics.gui.screen.ScreenWrapper;
import v1_21_4.morecosmetics.gui.screen.UIScreen;

@Environment(value=EnvType.CLIENT)
public class ListElement
extends BaseElement {
    private int current;
    private Map<String, FontImage> entries = new LinkedHashMap<String, FontImage>();
    private Consumer<String> callback;
    private CustomButton openListBtn;
    private long lastClicked;
    private int btnWidth = 40;

    public ListElement(String title, List<String> entries, int current, Consumer<String> callback) {
        super(title);
        for (String entry : entries) {
            this.entries.put(entry, null);
        }
        this.current = current;
        this.callback = callback;
        this.setBtnWidth(entries.get(current));
        this.openListBtn = new CustomButton(0, 0, this.btnWidth, 18, entries.get(current));
    }

    public ListElement(String title, Map<String, FontImage> entries, String curentText, int current, Consumer<String> callback) {
        super(title);
        this.entries = entries;
        this.current = current;
        this.callback = callback;
        this.setBtnWidth(curentText);
        this.openListBtn = new CustomButton(0, 0, this.btnWidth, 18, curentText);
    }

    private void setBtnWidth(String entry) {
        this.btnWidth = Math.max(DrawUtils.getStringWidth(entry) + 4, 40);
    }

    @Override
    public void drawComponent(Object stack, int x, int y, int compWidth, int compHeight, int mouseX, int mouseY) {
        super.drawComponent(stack, x, y, compWidth, compHeight, mouseX, mouseY);
        this.openListBtn.xPosition = x + compWidth - this.btnWidth;
        this.openListBtn.yPosition = y + 1;
        this.openListBtn.drawButton(mouseX, mouseY);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.openListBtn.mousePressed(mouseX, mouseY)) {
            ScreenWrapper.displayOverlay(new ListGui());
        }
    }

    @Override
    public int getControlWidth() {
        return this.btnWidth;
    }

    @Environment(value=EnvType.CLIENT)
    private class ListGui
    extends UIScreen {
        private ClickableIcon exitIcon;
        private String hoveredEntry;
        private int yBounce = 0;
        private int xBounce;
        private int hoveredIndex;
        private boolean customFont;
        private boolean clicked;
        private int entryHeight = 14;

        public ListGui() {
            for (Map.Entry<String, FontImage> entry : ListElement.this.entries.entrySet()) {
                if (entry.getValue() != null && !this.customFont) {
                    this.customFont = true;
                    this.entryHeight = 12;
                }
                int entryWidth = entry.getValue() == null ? DrawUtils.getStringWidth(entry.getKey()) : entry.getValue().getStringWidth(entry.getKey());
                this.xBounce = Math.max(entryWidth, this.xBounce);
                this.yBounce += this.entryHeight / 2;
            }
            this.xBounce = this.xBounce / 2 + 10;
            this.exitIcon = new ClickableIcon(8, 8, "morecosmetics/gui/icons/close.png", false);
            this.exitIcon.setHoverColor(UIConstants.DISABLED_COLOR);
        }

        @Override
        public void drawScreen(int mouseX, int mouseY, float partialTicks) {
            DrawUtils.drawRoundedWindowRect(this.width / 2 - this.xBounce - 6, this.height / 2 - this.yBounce - 7, this.width / 2 + this.xBounce + 6, this.height / 2 + this.yBounce + 1, UIConstants.UI_SEPARATION_COLOR);
            DrawUtils.drawRoundedWindowRect(this.width / 2 - this.xBounce - 5, this.height / 2 - this.yBounce - 6, this.width / 2 + this.xBounce + 5, this.height / 2 + this.yBounce, UIConstants.UI_BACKGROUND_COLOR);
            int currentHeight = this.height / 2 - this.yBounce;
            this.hoveredIndex = this.getHoverEntry(mouseX, mouseY);
            int index = 0;
            for (Map.Entry<String, FontImage> entry : ListElement.this.entries.entrySet()) {
                boolean customFont;
                boolean bl = customFont = entry.getValue() != null;
                if (ListElement.this.current == index) {
                    this.hoveredEntry = entry.getKey();
                    if (this.clicked) {
                        ListElement.this.setBtnWidth(entry.getKey());
                        ListElement.this.openListBtn.setText(entry.getKey());
                        ListElement.this.openListBtn.setWidth(ListElement.this.btnWidth);
                        ListElement.this.callback.accept(this.hoveredEntry);
                        this.clicked = false;
                    }
                    DrawUtils.drawRect(this.width / 2 - this.xBounce - 5, currentHeight - 3, this.width / 2 + this.xBounce + 5, currentHeight + this.entryHeight - 3, UIConstants.UI_SEPARATION_COLOR);
                }
                if (!customFont) {
                    DrawUtils.drawCenteredString(entry.getKey(), (float)this.width / 2.0f, (float)currentHeight, this.hoveredIndex == index ? UIConstants.UI_ACCENT_COLOR : -1);
                } else {
                    entry.getValue().drawString(entry.getKey(), (float)this.width / 2.0f - (float)entry.getValue().getStringWidth(entry.getKey()) / 2.0f, currentHeight, this.hoveredIndex == index ? UIConstants.UI_ACCENT_COLOR : -1, false);
                }
                ++index;
                currentHeight += this.entryHeight;
            }
            this.exitIcon.drawIcon(this.width / 2 + this.xBounce - 5, this.height / 2 - this.yBounce - 3, mouseX, mouseY);
        }

        private int getHoverEntry(int mouseX, int mouseY) {
            if (mouseX >= this.width / 2 - this.xBounce && mouseX <= this.width / 2 + this.xBounce && mouseY >= this.height / 2 - this.yBounce && mouseY <= this.height / 2 + this.yBounce) {
                int hoverElement = mouseY - (this.height / 2 - this.yBounce);
                return hoverElement / this.entryHeight;
            }
            return -1;
        }

        @Override
        protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.hoveredIndex = this.getHoverEntry(mouseX, mouseY);
            if (!this.exitIcon.isHovered()) {
                if (this.hoveredIndex == -1) {
                    ScreenWrapper.closeOverlay();
                    return;
                }
                if (System.currentTimeMillis() - ListElement.this.lastClicked < 500L && ListElement.this.current == this.hoveredIndex) {
                    ScreenWrapper.closeOverlay();
                    return;
                }
                ListElement.this.current = this.hoveredIndex;
                this.clicked = true;
                ListElement.this.lastClicked = System.currentTimeMillis();
            } else {
                ScreenWrapper.closeOverlay();
            }
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        protected void keyTyped(char typedChar, int keyCode) {
            if (keyCode == 1) {
                ScreenWrapper.closeOverlay();
            } else {
                super.keyTyped(typedChar, keyCode);
            }
        }
    }
}

