/*
 * Decompiled with CFR 0.152.
 */
package v1_21_4.morecosmetics.gui.elements.list;

import com.cosmeticsmod.morecosmetics.gui.core.UIConstants;
import com.cosmeticsmod.morecosmetics.utils.MathUtils;
import com.cosmeticsmod.morecosmetics.utils.Utils;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import v1_21_4.morecosmetics.DrawUtils;
import v1_21_4.morecosmetics.gui.elements.list.BaseElement;

@Environment(value=EnvType.CLIENT)
public class SliderElement
extends BaseElement {
    protected boolean textOverwritten;
    protected int xPosition;
    protected int yPosition;
    protected int width;
    protected int height;
    protected int min;
    protected int max;
    protected int current;
    protected Consumer<Integer> callback;
    protected float sliderValue;
    public boolean dragging;
    public boolean directCallback;

    public SliderElement(String title, int min, int max, int current, Consumer<Integer> callback, int width, boolean directCallback) {
        super(title);
        this.min = min;
        this.max = max;
        this.callback = callback;
        this.width = width;
        this.current = MathUtils.clampInt(current, min, max);
        this.sliderValue = this.normalizeValue(this.current);
        this.directCallback = directCallback;
    }

    @Override
    public void drawComponent(Object stack, int x, int y, int compWidth, int compHeight, int mouseX, int mouseY) {
        super.drawComponent(stack, x, y, compWidth, compHeight, mouseX, mouseY);
        this.xPosition = x + compWidth - this.width;
        this.yPosition = y;
        this.height = compHeight;
        DrawUtils.drawRoundedRect(this.xPosition, this.yPosition + 1, this.xPosition + this.width, this.yPosition + this.height - 1, UIConstants.UI_SEPARATION_COLOR);
        DrawUtils.drawRoundedRect(this.xPosition + 1, this.yPosition + 2, this.xPosition + this.width - 1, this.yPosition + this.height - 2, UIConstants.UI_COMPONENT_COLOR);
        DrawUtils.drawRect(this.xPosition + 4, this.yPosition + this.height / 2 - 1, this.xPosition + this.width - 20, this.yPosition + this.height / 2 + 1, UIConstants.UI_SEPARATION_COLOR);
        if (this.isHovered(mouseX, mouseY, 0)) {
            DrawUtils.drawRoundedRect(this.xPosition + 1, this.yPosition + 2, this.xPosition + this.width - 1, this.yPosition + this.height - 2, UIConstants.UI_COMPONENT_HOVER);
        }
        if (!this.textOverwritten) {
            DrawUtils.drawCenteredString("" + this.current, this.xPosition + this.width - 10, this.yPosition + this.height / 2 - DrawUtils.getFontHeight() / 2);
        }
        if (this.dragging) {
            this.update(mouseX);
        }
        int xV = this.xPosition + (int)(MathUtils.clampFloat(this.sliderValue, 0.05f, 0.95f) * (float)(this.width - 20));
        int yV = this.yPosition + this.height / 2;
        DrawUtils.drawRoundedRect(xV, yV - 5, xV + 3, yV + 5, Utils.toRGB(230, 230, 230, 255), 1);
    }

    private boolean isHovered(int mouseX, int mouseY, int tolerance) {
        return mouseX >= this.xPosition - tolerance && mouseY >= this.yPosition - tolerance && mouseX < this.xPosition + this.width + tolerance && mouseY < this.yPosition + this.height + tolerance;
    }

    public float normalizeValue(float value) {
        return MathUtils.clampFloat((this.snapToStepClamp(value) - (float)this.min) / (float)(this.max - this.min), 0.0f, 1.0f);
    }

    public float denormalizeValue(float value) {
        return this.snapToStepClamp((float)this.min + (float)(this.max - this.min) * MathUtils.clampFloat(value, 0.0f, 1.0f));
    }

    public float snapToStepClamp(float value) {
        return MathUtils.clampFloat(value, this.min, this.max);
    }

    public void update(int mouseX) {
        this.sliderValue = (float)(mouseX - (this.xPosition + 2)) / (float)(this.width - 22);
        this.sliderValue = MathUtils.clampFloat(this.sliderValue, 0.0f, 1.0f);
        int val = Math.round(this.denormalizeValue(this.sliderValue));
        if (this.current != val) {
            this.current = val;
            if (this.directCallback) {
                this.callback.accept(this.current);
            }
        }
    }

    @Override
    public void update(Object value) {
        int current = (Integer)value;
        this.current = MathUtils.clampInt(current, this.min, this.max);
        this.sliderValue = this.normalizeValue(this.current);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.isHovered(mouseX, mouseY, 0) && !this.textOverwritten) {
            this.update(mouseX);
            this.dragging = true;
        }
        super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public void mouseRelease(int mouseX, int mouseY, int state) {
        if (this.dragging) {
            this.dragging = false;
            if (!this.directCallback) {
                this.callback.accept(this.current);
            }
        }
        super.mouseRelease(mouseX, mouseY, state);
    }

    @Override
    public void keyTyped(char charCode, int keyCode) {
        super.keyTyped(charCode, keyCode);
    }

    @Override
    public int getControlWidth() {
        return this.width;
    }
}

