/*
 * Decompiled with CFR 0.152.
 */
package v1_21_4.morecosmetics.gui.elements.list;

import com.cosmeticsmod.morecosmetics.MoreCosmetics;
import com.cosmeticsmod.morecosmetics.gui.core.UIConstants;
import com.cosmeticsmod.morecosmetics.gui.core.texture.GuiLogo;
import com.cosmeticsmod.morecosmetics.gui.core.texture.TextureCategory;
import com.cosmeticsmod.morecosmetics.gui.core.texture.TextureEntry;
import com.cosmeticsmod.morecosmetics.utils.LanguageHandler;
import com.cosmeticsmod.morecosmetics.utils.Utils;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.apache.commons.io.FilenameUtils;
import v1_21_4.morecosmetics.DrawUtils;
import v1_21_4.morecosmetics.gui.components.ClickableIcon;
import v1_21_4.morecosmetics.gui.components.CustomButton;
import v1_21_4.morecosmetics.gui.components.CustomTextBox;
import v1_21_4.morecosmetics.gui.elements.list.BaseElement;
import v1_21_4.morecosmetics.gui.screen.ScreenWrapper;
import v1_21_4.morecosmetics.gui.screen.UIScreen;
import v1_21_4.morecosmetics.models.textures.CustomImage;
import v1_21_4.morecosmetics.models.textures.CustomTextureManager;

@Environment(value=EnvType.CLIENT)
public class TextureElement
extends BaseElement {
    public static final int ROW_HEIGHT = 32 + DrawUtils.getFontHeight() + 5;
    public static final int CATEGORY_WIDTH = 30;
    public static final int SCROLLBAR_WIDTH = 2;
    public static final String[] SUPPORTED_TYPES = new String[]{".png", ".jpeg", ".jpg", ".gif"};
    private CustomTextureManager ctm = CustomTextureManager.getGlobalInstance();
    private ArrayList<TextureCategory> filteredCategories;
    private ArrayList<TextureCategory> nativeCategories;
    private Consumer<TextureEntry> callback;
    private CustomButton browseButton;
    private boolean openedSelector;
    private boolean isShown;
    private boolean displayTopBar = true;
    private int selectedCat;
    private int rowsInLine;
    private long lastClicked;
    private TextureEntry lastEntry;
    private final String byStr;

    public TextureElement(String title, ArrayList<TextureCategory> nativeCategories, int selectedCat, int rowsInLine, Consumer<TextureEntry> callback) {
        super(title);
        this.selectedCat = selectedCat;
        this.rowsInLine = rowsInLine;
        this.callback = callback;
        this.nativeCategories = nativeCategories;
        this.filteredCategories = nativeCategories;
        this.byStr = "by ";
        for (TextureCategory category : this.filteredCategories) {
            if (!category.isLocalExploration()) continue;
            File dir = new File(category.getLocalTargetPath());
            if (!dir.exists()) {
                System.err.println("Couldn't find " + dir.getAbsolutePath());
                continue;
            }
            if (!dir.isDirectory()) {
                System.err.println(dir.getAbsolutePath() + " isn't a directory!");
                continue;
            }
            ArrayList<TextureEntry> files = new ArrayList<TextureEntry>();
            for (File f : dir.listFiles()) {
                if (!f.getName().toLowerCase().endsWith(".png")) continue;
                files.add(new TextureEntry(FilenameUtils.getBaseName((String)f.getName()), f.getAbsolutePath()));
            }
            if (files.isEmpty()) continue;
            category.fillEntries(textureEntries -> textureEntries.addAll(files), 1);
        }
        this.browseButton = new CustomButton(0, 0, 40, 18, "Browse");
    }

    @Override
    public void drawComponent(Object stack, int x, int y, int compWidth, int compHeight, int mouseX, int mouseY) {
        super.drawComponent(stack, x, y, compWidth, compHeight, mouseX, mouseY);
        this.browseButton.xPosition = x + compWidth - 40;
        this.browseButton.yPosition = y + 1;
        this.browseButton.drawButton(mouseX, mouseY);
        if (this.openedSelector && !this.isShown) {
            this.isShown = true;
            this.filteredCategories = this.nativeCategories;
            ScreenWrapper.displayOverlay(new TextureSelectionGui());
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.browseButton.mousePressed(mouseX, mouseY)) {
            this.openedSelector = !this.openedSelector;
        }
        super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public void mouseRelease(int mouseX, int mouseY, int state) {
        super.mouseRelease(mouseX, mouseY, state);
    }

    @Override
    public void keyTyped(char charCode, int keyCode) {
        super.keyTyped(charCode, keyCode);
    }

    @Environment(value=EnvType.CLIENT)
    public class TextureSelectionGui
    extends UIScreen {
        private long lastTyped = -1L;
        private boolean scrollbarRequired;
        private boolean dragScroll;
        private int totalWidth;
        private int frameHeight;
        private int frameWidth;
        private int xRows;
        private int yRows;
        private int scrollAmount;
        private int maxScroll;
        private int startRow;
        private int barStart;
        private int barEnd;
        private int barMouseSpace;
        private CustomTextBox searchBarTxb;
        private ClickableIcon deleteIcon;
        private ClickableIcon exitIcon = new ClickableIcon(11, 11, "morecosmetics/gui/icons/close.png", false);

        public TextureSelectionGui() {
            this.exitIcon.setHoverColor(UIConstants.DISABLED_COLOR);
            this.deleteIcon = new ClickableIcon(9, 9, "morecosmetics/gui/icons/delete.png", false);
            this.deleteIcon.setHoverColor(UIConstants.DISABLED_COLOR);
            this.deleteIcon.setHoverText(LanguageHandler.get("remove"));
            this.searchBarTxb = new CustomTextBox(0, 0, 215, 11);
            this.searchBarTxb.setPlaceHolder("Search/URL");
        }

        @Override
        public void initGui() {
            this.totalWidth = 30 + TextureElement.this.rowsInLine * 72 + 2;
            this.frameWidth = this.boxEndX() - this.boxSplitX();
            this.frameHeight = this.boxEndY() - this.boxStartY();
            this.xRows = this.frameWidth / 72;
            this.yRows = this.frameHeight / ROW_HEIGHT;
            this.xRows = this.xRows < 1 ? 1 : this.xRows;
            this.yRows = this.yRows < 1 ? 1 : this.yRows;
            this.initScrollbar(true);
            super.initGui();
        }

        @Override
        public void drawScreen(int mouseX, int mouseY, float partialTicks) {
            int hoverCat;
            DrawUtils.drawRoundedWindowRect(this.boxStartX() - 1, this.boxStartY() - 21, this.boxEndX() + 1, this.boxEndY() + 1, UIConstants.UI_SEPARATION_COLOR);
            DrawUtils.drawRoundedWindowRect(this.boxStartX(), this.boxStartY() - 20, this.boxEndX(), this.boxEndY(), UIConstants.UI_BACKGROUND_COLOR);
            DrawUtils.drawRect(this.boxSplitX(), this.boxStartY(), this.boxSplitX() - 1, this.boxEndY(), UIConstants.UI_SEPARATION_COLOR);
            DrawUtils.drawRect(this.boxStartX(), this.boxStartY() - 1, this.boxEndX(), this.boxStartY(), UIConstants.UI_SEPARATION_COLOR);
            if (TextureElement.this.displayTopBar) {
                // empty if block
            }
            if (this.lastTyped != -1L && System.currentTimeMillis() - this.lastTyped > 500L) {
                this.lastTyped = -1L;
                String text = this.searchBarTxb.getText().trim();
                if (Utils.isUrlString(text)) {
                    if (Utils.endsWith(text, SUPPORTED_TYPES)) {
                        TextureElement.this.callback.accept(new TextureEntry("URL", text));
                    }
                } else {
                    MoreCosmetics.EXECUTOR.execute(() -> this.filterBy(text, TextureCategory.EnumSearchType.NAME));
                }
            }
            if (this.dragScroll) {
                float clickedScrollPercentage = (float)(mouseY - this.boxStartY() - this.barMouseSpace) / (float)this.frameHeight;
                this.scrollAmount = -((int)(clickedScrollPercentage * (float)this.maxScroll));
                this.validateScrollAmount();
            }
            int y = this.boxStartY();
            int index = 0;
            for (TextureCategory cat : TextureElement.this.filteredCategories) {
                CustomImage icon;
                if (index == TextureElement.this.selectedCat) {
                    DrawUtils.drawRect(this.boxStartX(), y, this.boxSplitX() - 1, y + 20 + 2, UIConstants.UI_SEPARATION_COLOR);
                }
                if ((icon = TextureElement.this.ctm.getImage(cat.getIconURL(), cat.getIconURL(), null)) != null) {
                    DrawUtils.drawTexture(this.boxStartX() + ((this.boxSplitX() - this.boxStartX()) / 2 - 10), y + 1, 256.0f, 256.0f, 20.0f, 20.0f, 1.0f, UIConstants.TEXURE_COLOR, icon.getLocation());
                }
                if (index == TextureElement.this.selectedCat) {
                    if (this.scrollbarRequired) {
                        float startPercentage = (float)(-this.scrollAmount) / (float)this.maxScroll;
                        this.barStart = (int)((float)this.frameHeight * startPercentage) + this.boxStartY();
                        float endPercentage = (float)(-this.scrollAmount + this.frameHeight) / (float)this.maxScroll;
                        this.barEnd = (int)((float)this.frameHeight * endPercentage) + this.boxStartY();
                        DrawUtils.drawRect(this.boxEndX() - 2, this.boxStartY(), this.boxEndX(), this.boxEndY() - 3, UIConstants.SHADOW);
                        DrawUtils.drawRect(this.boxEndX() - 2, this.barStart, this.boxEndX(), this.barEnd - 3, Color.WHITE.getRGB());
                    }
                    int currX = 0;
                    int currY = this.boxStartY() + 2;
                    int entryIndex = 0;
                    boolean first = true;
                    this.startRow = -(this.scrollAmount / ROW_HEIGHT);
                    for (TextureEntry entry : cat.getAllEntries()) {
                        if (entryIndex / this.xRows > this.startRow + this.yRows - 1) break;
                        if (entryIndex / this.xRows >= this.startRow) {
                            CustomImage entryImage;
                            if (first) {
                                currX = this.boxSplitX();
                                first = false;
                            }
                            if (TextureElement.this.filteredCategories.size() > TextureElement.this.selectedCat && entryIndex == TextureElement.this.filteredCategories.get(TextureElement.this.selectedCat).getSelectedIndex()) {
                                DrawUtils.drawRect(currX, currY, currX + 32 + 40, currY + 32 + 2 + DrawUtils.getFontHeight(), UIConstants.ELEMENT_SELECTION_BOX_COLOR);
                            }
                            if ((entryImage = TextureElement.this.ctm.getImage(entry.getPreviewURL(), entry.getPreviewURL(), null)) != null) {
                                DrawUtils.drawTexture((float)currX + (40.0f + (32.0f - entryImage.getFactor() * 32.0f)) / 2.0f, currY, 256.0f, 256.0f, entryImage.getFactor() * 32.0f, 32.0f, 1.0f, UIConstants.TEXURE_COLOR, entryImage.getLocation());
                            }
                            DrawUtils.drawCenteredString(entry.getName(), (float)(currX + 16 + 20), (float)(currY + 32 + 2), 0.5f);
                            if (entry.getCreator() != null) {
                                DrawUtils.drawCenteredString(TextureElement.this.byStr + entry.getCreator(), (float)(currX + 16 + 20), (float)(currY + 32 + 7), 0.35f);
                            }
                            if ((currX += 72) + 32 + 40 >= this.boxEndX()) {
                                currY += ROW_HEIGHT;
                                first = true;
                            }
                        }
                        ++entryIndex;
                    }
                }
                y += 22;
                ++index;
            }
            if (mouseX >= this.boxSplitX() && mouseX <= this.boxEndX() - 2 + 1 && mouseY >= this.boxStartY() + 2 && mouseY <= this.boxEndY()) {
                int yC = (mouseY - (this.boxStartY() + 2)) / ROW_HEIGHT;
                int xC = (mouseX - this.boxSplitX()) / 72;
                int icon = this.xRows * yC + xC + this.startRow * this.xRows;
            }
            this.exitIcon.drawIcon(this.boxEndX() - 14, this.boxStartY() + (TextureElement.this.displayTopBar ? -16 : 2), mouseX, mouseY);
            if (TextureElement.this.displayTopBar) {
                this.deleteIcon.drawIcon(this.boxEndX() - 25, this.boxStartY() - 15, mouseX, mouseY);
                this.searchBarTxb.xPosition = this.boxStartX() + 4;
                this.searchBarTxb.yPosition = this.boxStartY() - 16;
                this.searchBarTxb.drawTextBox(mouseX, mouseY, 2);
            }
            if (TextureElement.this.selectedCat < TextureElement.this.filteredCategories.size()) {
                TextureCategory cat = TextureElement.this.filteredCategories.get(TextureElement.this.selectedCat);
                if (cat.getSubline() != null) {
                    DrawUtils.drawString(cat.getSubline(), this.boxStartX() + 5, this.boxEndY() + 3, 0.75f, Utils.toRGB(255, 255, 255, 255));
                }
                int iconSize = 10;
                if (cat.getIcons() != null) {
                    for (int i = 0; i < cat.getIcons().length; ++i) {
                        GuiLogo logo = cat.getIcons()[i];
                        int startX = this.boxEndX() - (2 * (i + 1) + iconSize * (i + 1));
                        class_2960 loc = TextureElement.this.ctm.getTexture(logo.getName(), logo.getLogo());
                        if (loc == null) continue;
                        int startY = this.boxEndY() + 1;
                        logo.setHovered(mouseX >= startX && mouseY >= startY && mouseX < startX + iconSize && mouseY < startY + iconSize);
                        DrawUtils.drawTexture(startX, startY, 256.0f, 256.0f, iconSize, iconSize, 1.0f, UIConstants.TEXURE_COLOR, loc);
                        if (!logo.isHovered()) continue;
                        DrawUtils.drawToolTip(logo.getName(), mouseX, mouseY);
                    }
                }
            }
            if ((hoverCat = (mouseY - this.boxStartY()) / 22) >= 0 && hoverCat < TextureElement.this.filteredCategories.size() && mouseX >= this.boxStartX() && mouseX <= this.boxSplitX() && mouseY >= this.boxStartY() && hoverCat < TextureElement.this.filteredCategories.size()) {
                DrawUtils.drawToolTip(TextureElement.this.filteredCategories.get(hoverCat).getName(), mouseX, mouseY);
            }
        }

        @Override
        protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            if (mouseX >= this.boxStartX() && mouseX <= this.boxSplitX() && mouseY >= this.boxStartY() && mouseY <= this.boxEndY()) {
                int newSelectedCat = (mouseY - this.boxStartY()) / 20;
                if (TextureElement.this.filteredCategories.size() - 1 >= newSelectedCat) {
                    TextureElement.this.selectedCat = newSelectedCat;
                }
                this.initScrollbar(true);
            }
            if (TextureElement.this.displayTopBar) {
                this.searchBarTxb.mouseClicked(mouseX, mouseY, mouseButton);
                if (this.deleteIcon.isHovered()) {
                    TextureElement.this.callback.accept(null);
                    return;
                }
            }
            if (this.exitIcon.isHovered()) {
                ScreenWrapper.closeOverlay();
                return;
            }
            if (TextureElement.this.selectedCat >= TextureElement.this.filteredCategories.size()) {
                return;
            }
            int endX = this.boxEndX();
            if (this.scrollbarRequired) {
                int offset = 3;
                if (mouseX >= endX - offset && mouseX <= this.boxEndX() && mouseY >= this.boxStartY() + 2 && mouseY <= this.boxEndY() && !this.dragScroll) {
                    if (this.barStart > mouseY || this.barEnd < mouseY) {
                        float clickedScrollPercentage = (float)(mouseY - this.boxStartY()) / (float)this.frameHeight;
                        this.scrollAmount = -((int)(clickedScrollPercentage * (float)this.maxScroll));
                        this.validateScrollAmount();
                        this.barMouseSpace = (this.barEnd - this.barStart) / 2;
                    } else {
                        this.barMouseSpace = mouseY - this.barStart;
                    }
                    this.dragScroll = true;
                }
                endX -= offset;
            }
            TextureCategory cat = TextureElement.this.filteredCategories.get(TextureElement.this.selectedCat);
            if (mouseX >= this.boxSplitX() && mouseX <= endX && mouseY >= this.boxStartY() + 2 && mouseY <= this.boxEndY()) {
                int y = (mouseY - (this.boxStartY() + 2)) / ROW_HEIGHT;
                int x = (mouseX - this.boxSplitX()) / 72;
                cat.setSelectedIndex(this.xRows * y + x + this.startRow * this.xRows);
                TextureEntry callbackEntry = cat.getSelectedEntry();
                if (callbackEntry != null) {
                    if (TextureElement.this.lastEntry == callbackEntry && System.currentTimeMillis() - TextureElement.this.lastClicked < 500L) {
                        ScreenWrapper.closeOverlay();
                        return;
                    }
                    TextureElement.this.lastClicked = System.currentTimeMillis();
                    TextureElement.this.lastEntry = callbackEntry;
                    TextureElement.this.callback.accept(callbackEntry);
                }
            } else if (cat.getIcons() != null) {
                for (GuiLogo icon : cat.getIcons()) {
                    if (!icon.isHovered()) continue;
                    icon.onClick();
                }
            }
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        protected void mouseReleased(int mouseX, int mouseY, int state) {
            super.mouseReleased(mouseX, mouseY, state);
            if (this.dragScroll) {
                this.dragScroll = false;
            }
        }

        @Override
        public void onScroll(double amount) {
            int mouseWheel;
            if (this.scrollbarRequired && (mouseWheel = (int)Math.signum(amount)) != 0) {
                this.updateScrollAmount(mouseWheel);
            }
        }

        @Override
        protected void keyTyped(char typedChar, int keyCode) {
            String preText = this.searchBarTxb.getText().trim();
            this.searchBarTxb.textBoxKeyTyped(typedChar, keyCode);
            String text = this.searchBarTxb.getText().trim();
            boolean link = Utils.isUrlString(text);
            if (!preText.equals(text)) {
                this.lastTyped = System.currentTimeMillis();
            }
            if (link && keyCode == 28 && Utils.endsWith(text, SUPPORTED_TYPES)) {
                TextureElement.this.callback.accept(new TextureEntry("URL", text));
            }
            super.keyTyped(typedChar, keyCode);
        }

        private void filterBy(String searchWord, TextureCategory.EnumSearchType searchType) {
            if (searchWord == null || searchWord.isEmpty()) {
                TextureElement.this.filteredCategories = TextureElement.this.nativeCategories;
                this.initScrollbar(true);
                return;
            }
            ArrayList<TextureCategory> cacheCats = new ArrayList<TextureCategory>();
            for (TextureCategory category : TextureElement.this.nativeCategories) {
                TextureCategory cache = new TextureCategory(category.getName(), category.getIconURL()).setOnlineUpdater(category.getUpdateInterface(), category.getReferenceURL());
                cache.setSubline(category.getSubline());
                cache.setIcons(category.getIcons());
                if (category.hasOnlineSearch()) {
                    cache.getAllEntries().addAll(category.searchForWord(searchWord, cache, searchType));
                } else {
                    for (TextureEntry entry : category.getAllEntries()) {
                        if (searchType == TextureCategory.EnumSearchType.NAME && entry.getName().toLowerCase().contains(searchWord.toLowerCase())) {
                            cache.getAllEntries().add(entry);
                            continue;
                        }
                        if (searchType != TextureCategory.EnumSearchType.CREATOR || entry.getCreator() == null || !entry.getCreator().toLowerCase().contains(searchWord.toLowerCase())) continue;
                        cache.getAllEntries().add(entry);
                    }
                }
                if (cache.getAllEntries().isEmpty()) continue;
                cacheCats.add(cache);
            }
            TextureElement.this.filteredCategories = cacheCats;
            if (TextureElement.this.selectedCat >= TextureElement.this.filteredCategories.size()) {
                TextureElement.this.selectedCat = 0;
            }
            this.initScrollbar(true);
        }

        private int boxStartX() {
            return this.width / 2 - this.totalWidth / 2;
        }

        private int boxStartY() {
            return this.height / 2 - 90;
        }

        private int boxSplitX() {
            return this.boxStartX() + 30;
        }

        private int boxEndX() {
            return this.width / 2 + this.totalWidth / 2;
        }

        private int boxEndY() {
            return this.height / 2 + 110;
        }

        private void initScrollbar(boolean resetCurrentScroll) {
            if (resetCurrentScroll) {
                this.scrollAmount = 0;
            }
            if (TextureElement.this.filteredCategories.isEmpty()) {
                this.scrollbarRequired = false;
                return;
            }
            int size = TextureElement.this.filteredCategories.get(TextureElement.this.selectedCat).getAllEntries().size();
            this.scrollbarRequired = size > this.xRows * this.yRows;
            this.maxScroll = size / this.xRows * ROW_HEIGHT;
            if (size % this.xRows != 0) {
                this.maxScroll += 2 * ROW_HEIGHT;
            }
        }

        public void updateScrollAmount(int amount) {
            this.scrollAmount += 20 * amount;
            this.validateScrollAmount();
        }

        private void validateScrollAmount() {
            if (-this.scrollAmount > this.maxScroll - this.frameHeight) {
                this.scrollAmount = -(this.maxScroll - this.frameHeight);
                if (TextureElement.this.filteredCategories.size() > TextureElement.this.selectedCat) {
                    TextureElement.this.filteredCategories.get(TextureElement.this.selectedCat).increasePage();
                    this.initScrollbar(false);
                }
            } else if (-this.scrollAmount < 0) {
                this.scrollAmount = 0;
            }
        }

        @Override
        public void onGuiClosed() {
            TextureElement.this.openedSelector = false;
            TextureElement.this.isShown = false;
        }
    }
}

