/*
 * Decompiled with CFR 0.152.
 */
package v1_21_4.morecosmetics.gui.screen;

import com.cosmeticsmod.morecosmetics.MoreCosmetics;
import com.cosmeticsmod.morecosmetics.gui.core.UIConstants;
import com.cosmeticsmod.morecosmetics.gui.core.box.BoxManager;
import com.cosmeticsmod.morecosmetics.gui.core.box.CustomBoxGui;
import com.cosmeticsmod.morecosmetics.gui.core.box.utils.BoxCategory;
import com.cosmeticsmod.morecosmetics.gui.core.list.ListManager;
import com.cosmeticsmod.morecosmetics.utils.ModConfig;
import com.cosmeticsmod.morecosmetics.utils.Utils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import v1_21_4.morecosmetics.DrawUtils;
import v1_21_4.morecosmetics.gui.PopupManager;
import v1_21_4.morecosmetics.gui.screen.UIScreen;
import v1_21_4.morecosmetics.models.renderer.StackHolder;
import v1_21_4.morecosmetics.models.textures.CustomTextureManager;

@Environment(value=EnvType.CLIENT)
public abstract class BaseUI
extends UIScreen
implements BoxManager.BoxGuiInstance {
    private CustomBoxGui boxGui;
    protected BoxManager boxManager = new BoxManager(this.width, this.height, this);
    protected CustomTextureManager ctm = CustomTextureManager.getGlobalInstance();
    private boolean previewDragging;
    private boolean refresh;
    private boolean leftPressing;
    private int mouseX;
    private int mouseY;
    private int lastMouseX;
    private int lastMouseY;
    private int previewDragX = -10;
    private int previewDragY = 1;

    protected BaseUI() {
    }

    public void initBoxGui(CustomBoxGui boxGui) {
        this.boxGui = boxGui;
    }

    public abstract void initUI();

    public abstract void draw(int var1, int var2, float var3);

    public abstract void onClick(int var1, int var2, int var3);

    @Override
    public void initGui() {
        if (class_310.method_1551().field_1724 != null) {
            if (this.boxManager.getCategories().isEmpty()) {
                this.boxGui.fillGui(this.boxManager.getCategories());
            }
            this.boxManager.updateResolution(this.width, this.height);
            this.initUI();
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.lastMouseX = this.mouseX;
        this.lastMouseY = this.mouseY;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        boolean enabled = class_310.method_1551().field_1724 != null;
        DrawUtils.drawRect(0, 0, this.width, this.height, Utils.toRGB(25, 26, 31, 240));
        DrawUtils.drawRect(0, 0, 100, this.height, UIConstants.UI_COMPONENT_COLOR);
        DrawUtils.drawRoundedRect(90, 0, this.boxManager.baseBoxEndX(), this.height, UIConstants.UI_SEPARATION_COLOR, 8);
        DrawUtils.drawRoundedRect(91, 1, this.boxManager.baseBoxEndX() - 1, this.height - 1, UIConstants.UI_BACKGROUND_COLOR, 8);
        DrawUtils.drawRect(9, 21, this.boxManager.baseBoxSplitX() - 13, 22, UIConstants.UI_SEPARATION_COLOR);
        DrawUtils.drawRect(90, 21, this.boxManager.baseBoxEndX(), 22, UIConstants.UI_SEPARATION_COLOR);
        DrawUtils.drawString("MoreCosmetics", 9.0f, 9.0f, UIConstants.UI_ACCENT_COLOR);
        DrawUtils.drawCenteredString("\u00a7f" + this.boxManager.getCurrentTitle(), (float)((this.boxManager.baseBoxSplitX() + this.boxManager.baseBoxEndX()) / 2), 9.0f, UIConstants.UI_ACCENT_COLOR);
        if (enabled) {
            if (this.refresh) {
                this.refresh = false;
                this.boxManager.setExtensionVisible(false);
                this.boxGui.fillGui(this.boxManager.getCategories());
                this.boxManager.updateResolution(this.width, this.height);
                this.boxManager.refreshList();
            }
            if (ModConfig.getConfig().showPreview) {
                this.drawPreview(this.width, this.height);
            }
            this.draw(mouseX, mouseY, partialTicks);
        } else {
            DrawUtils.drawCenteredString("Preview only ingame available!", this.width / 2, this.height / 2 - 7);
            DrawUtils.drawCenteredString("Press ESC to exit.", this.width / 2, this.height / 2 + 7);
        }
        this.boxManager.draw(null, mouseX, mouseY, enabled);
        MoreCosmetics.getInstance().getNotificationHandler().draw(null, this.width);
        PopupManager.draw(this.width, this.height, mouseX, mouseY);
    }

    private void drawPreview(int width, int height) {
        if (this.leftPressing && this.mouseX > width / 4 * 3) {
            this.previewDragging = true;
        } else if (this.previewDragging && !this.leftPressing) {
            this.previewDragging = false;
        }
        if (this.previewDragging) {
            this.previewDragX += this.mouseX - this.lastMouseX;
            this.previewDragY += this.mouseY - this.lastMouseY;
            this.previewDragX %= 360;
            this.previewDragY %= 360;
            this.previewDragY = this.previewDragY == 0 ? 1 : this.previewDragY;
        }
        DrawUtils.drawEntityOnScreen(width / 4 * 3 + 20, height / 2 + 40, height / 6, 0.0f, 0.0f, this.previewDragX, this.previewDragY, 0, (class_1309)class_310.method_1551().field_1724);
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean bl = this.leftPressing = mouseButton == 0 && mouseX > this.width / 4 * 3;
        if (this.boxManager.mouseClicked(mouseX, mouseY, mouseButton)) {
            return;
        }
        this.onClick(mouseX, mouseY, mouseButton);
        PopupManager.click(mouseX, mouseY);
        super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    protected void mouseReleased(int mouseX, int mouseY, int state) {
        this.leftPressing = false;
        this.boxManager.mouseReleased(this.mouseX, this.mouseY, state);
        super.mouseReleased(mouseX, mouseY, state);
    }

    @Override
    public void onScroll(double amount) {
        this.boxManager.handleMouseInput(this.mouseX, this.mouseY);
        super.onScroll(amount);
    }

    @Override
    protected void keyTyped(char typedChar, int keyCode) {
        this.boxManager.keyTyped(typedChar, keyCode);
        super.keyTyped(typedChar, keyCode);
    }

    @Override
    public void onGuiClosed() {
        this.leftPressing = false;
        this.boxGui.onGuiClosed();
    }

    @Override
    public void drawCategory(int y, boolean selected, boolean first, BoxCategory category) {
        boolean hover;
        if (category == BoxManager.SEPARATION_LINE) {
            DrawUtils.drawRect(9, (y += 10) - 1, this.boxManager.baseBoxSplitX() - 13, y, UIConstants.UI_SEPARATION_COLOR);
            return;
        }
        int left = this.boxManager.baseBoxStartX();
        int top = y - 4;
        int right = this.boxManager.baseBoxSplitX() - 3;
        int bottom = y + 13 + 4;
        boolean bl = hover = this.mouseX >= left && this.mouseX <= right && this.mouseY >= top && this.mouseY <= bottom;
        if (hover || selected) {
            DrawUtils.drawRect(left, top, right, bottom, selected ? UIConstants.UI_SEPARATION_COLOR : UIConstants.UI_COMPONENT_HOVER);
        }
        class_2960 icon = null;
        icon = category.getIconPath().startsWith("http") ? this.ctm.getTexture(category.getName(), category.getIconPath()) : this.ctm.getResource(category.getName(), "morecosmetics/gui/icons/" + category.getIconPath() + ".png");
        if (icon != null) {
            DrawUtils.drawString(category.getName(), (float)(this.boxManager.baseBoxStartX() + 13 + 13), (float)(y + 3), selected ? UIConstants.UI_TEXT_COLOR : UIConstants.UI_DISABLED_COLOR);
            DrawUtils.drawTexture(this.boxManager.baseBoxStartX() + 8, y, 256.0f, 256.0f, 13.0f, 13.0f, 1.0f, selected ? UIConstants.TEXURE_COLOR : UIConstants.UI_DISABLED_COLOR, icon);
        }
    }

    @Override
    public void drawScrollbar() {
        DrawUtils.drawRoundedRect(this.boxManager.baseBoxEndX(), this.boxManager.baseBoxStartY(), this.boxManager.baseBoxEndX() + 3, this.boxManager.baseBoxEndY() - 7, UIConstants.UI_BACKGROUND_COLOR, 1);
        DrawUtils.drawRoundedRect(this.boxManager.baseBoxEndX(), this.boxManager.getBarStart(), this.boxManager.baseBoxEndX() + 3, this.boxManager.getBarEnd() - 7, UIConstants.UI_COMPONENT_COLOR, 1);
    }

    @Override
    public void drawListManagerScrollbar(ListManager listManager) {
        DrawUtils.drawRoundedRect(listManager.getScrollDrawX() + 6, listManager.getStartY(), listManager.getScrollDrawX() + 6 + 3, listManager.getEndY() - 7, UIConstants.UI_BACKGROUND_COLOR, 1);
        DrawUtils.drawRoundedRect(listManager.getScrollDrawX() + 6, listManager.getBarStart(), listManager.getScrollDrawX() + 6 + 3, listManager.getBarEnd() - 7, UIConstants.UI_COMPONENT_COLOR, 1);
    }

    @Override
    public void refreshGui() {
        this.refresh = true;
    }

    @Override
    public void drawRoundedRect(int left, int top, int right, int bottom, int color, int rad) {
        DrawUtils.drawRoundedRect(left, top, right, bottom, color, rad);
    }

    @Override
    public void translateUI(boolean toFront, float z) {
        if (class_310.method_1551().field_1755 == this.getWrapper()) {
            class_4587 stack = StackHolder.STACK;
            if (toFront) {
                stack.method_22903();
                stack.method_46416(0.0f, 0.0f, z);
            } else {
                stack.method_22909();
            }
        }
    }
}

