/*
 * Decompiled with CFR 0.152.
 */
package v1_21_4.morecosmetics.gui.screen;

import com.cosmeticsmod.morecosmetics.gui.core.UIConstants;
import com.cosmeticsmod.morecosmetics.utils.LanguageHandler;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import v1_21_4.morecosmetics.DrawUtils;
import v1_21_4.morecosmetics.gui.components.ClickableIcon;
import v1_21_4.morecosmetics.gui.components.CustomButton;
import v1_21_4.morecosmetics.gui.screen.ScreenWrapper;
import v1_21_4.morecosmetics.gui.screen.UIScreen;

@Environment(value=EnvType.CLIENT)
public class ConfirmUI
extends UIScreen {
    public static int LINE_LENGTH = 180;
    public static int LINE_HEIGHT = 12;
    private final ClickableIcon exitIcon;
    private CustomButton yesButton;
    private CustomButton noButton;
    private final String title;
    private final String text;
    private final Consumer<Boolean> callback;
    private final ArrayList<String> textLines;

    public ConfirmUI(String title, String text, Consumer<Boolean> callback) {
        this.title = title;
        this.text = text;
        this.callback = callback;
        this.textLines = new ArrayList();
        this.exitIcon = new ClickableIcon(8, 8, "morecosmetics/gui/icons/close.png", false);
        this.exitIcon.setHoverColor(UIConstants.DISABLED_COLOR);
        LINE_LENGTH = 180;
        this.textLines.clear();
        StringBuilder builder = new StringBuilder();
        for (String word : text.split(" ")) {
            String current = builder.toString();
            if (DrawUtils.getStringWidth(current + " " + word) >= LINE_LENGTH) {
                this.textLines.add(current);
                builder = new StringBuilder(word);
                continue;
            }
            if (builder.length() != 0) {
                builder.append(" ");
            }
            builder.append(word);
        }
        if (builder.length() != 0) {
            this.textLines.add(builder.toString());
        }
    }

    @Override
    public void initGui() {
        this.yesButton = new CustomButton(this.width / 2 - 42, this.height / 2 + 5, 40, 18, "\u00a7a" + LanguageHandler.get("yes"));
        this.noButton = new CustomButton(this.width / 2 + 2, this.height / 2 + 5, 40, 18, "\u00a7c" + LanguageHandler.get("no"));
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        int h = LINE_HEIGHT * this.textLines.size();
        int ll = LINE_LENGTH / 2;
        DrawUtils.drawRoundedWindowRect(this.width / 2 - ll - 2 - 1, this.height / 2 - 30 - h - 1, this.width / 2 + ll + 2 + 1, this.height / 2 + 30 + 1, UIConstants.UI_SEPARATION_COLOR);
        DrawUtils.drawRoundedWindowRect(this.width / 2 - ll - 2, this.height / 2 - 30 - h, this.width / 2 + ll + 2, this.height / 2 + 30, UIConstants.UI_BACKGROUND_COLOR);
        DrawUtils.drawCenteredString(this.title, (float)(this.width / 2), (float)(this.height / 2 - 25 - h), -1);
        this.exitIcon.drawIcon(this.width / 2 + ll - 10, this.height / 2 - 25 - h, mouseX, mouseY);
        for (String line : this.textLines) {
            DrawUtils.drawCenteredString(line, (float)(this.width / 2), (float)(this.height / 2 - h), -1);
            h -= LINE_HEIGHT;
        }
        this.yesButton.drawButton(mouseX, mouseY);
        this.noButton.drawButton(mouseX, mouseY);
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.yesButton.mousePressed(mouseX, mouseY)) {
            ScreenWrapper.closeOverlay();
            this.callback.accept(true);
        } else if (this.noButton.mousePressed(mouseX, mouseY) || this.exitIcon.isHovered()) {
            ScreenWrapper.closeOverlay();
            this.callback.accept(false);
        }
    }
}

