/*
 * Decompiled with CFR 0.152.
 */
package v1_21_4.morecosmetics.gui.screen;

import com.cosmeticsmod.morecosmetics.utils.ModConfig;
import com.cosmeticsmod.morecosmetics.utils.SharedVars;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import v1_21_4.morecosmetics.DrawUtils;
import v1_21_4.morecosmetics.gui.screen.UIScreen;
import v1_21_4.morecosmetics.models.renderer.StackHolder;

@Environment(value=EnvType.CLIENT)
public class ScreenWrapper
extends class_437 {
    public static final int DEFAULT_FRONT_BUFFER = 200;
    private static ScreenWrapper lastScreen;
    private final UIScreen screen;
    private UIScreen overlay;
    private int frontBuffer;
    private int mouseX;
    private int mouseY;
    private float guiScale;
    private int lastKeyCode;

    public ScreenWrapper(UIScreen screen) {
        this(screen, 0);
    }

    public ScreenWrapper(UIScreen screen, int frontBuffer) {
        super((class_2561)class_2561.method_43470((String)screen.getClass().getSimpleName()));
        this.screen = screen;
        this.frontBuffer = frontBuffer;
        this.guiScale = 0.5f + (float)ModConfig.getConfig().guiScale / 20.0f;
    }

    protected void method_25426() {
        int w = (int)Math.ceil((float)this.field_22789 / this.getXFactor());
        int h = (int)Math.ceil((float)this.field_22790 / this.getYFactor());
        this.screen.init(w, h, this);
        if (this.overlay != null) {
            this.overlay.init(w, h, this);
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        class_4587 matrices = context.method_51448();
        StackHolder.update(matrices);
        if (matrices != null) {
            float xFactor = this.getXFactor();
            float yFactor = this.getYFactor();
            this.mouseX = (int)Math.ceil((float)mouseX / xFactor);
            this.mouseY = (int)Math.ceil((float)mouseY / yFactor);
            matrices.method_22903();
            matrices.method_22905(xFactor, yFactor, 1.0f);
            this.screen.drawScreen(this.mouseX, this.mouseY, delta);
            if (this.frontBuffer > 0) {
                matrices.method_46416(0.0f, 0.0f, (float)this.frontBuffer);
            }
            if (this.overlay != null) {
                DrawUtils.drawDarkOverlay(this.screen.width, this.screen.height);
                this.overlay.drawScreen(this.mouseX, this.mouseY, delta);
            }
            matrices.method_22909();
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25432() {
        this.screen.onGuiClosed();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.overlay != null) {
            this.overlay.mouseClicked(this.mouseX, this.mouseY, button);
        } else {
            this.screen.mouseClicked(this.mouseX, this.mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.overlay != null) {
            this.overlay.mouseReleased(this.mouseX, this.mouseY, button);
        } else {
            this.screen.mouseReleased(this.mouseX, this.mouseY, button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.overlay != null) {
            this.overlay.handleMouseInput();
        } else {
            this.screen.handleMouseInput();
        }
        super.method_16014(mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        SharedVars.SCROLL_AMOUNT = (int)verticalAmount;
        if (this.overlay != null) {
            this.overlay.onScroll(verticalAmount);
        } else {
            this.screen.onScroll(verticalAmount);
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.overlay != null) {
            this.lastKeyCode = keyCode;
            this.overlay.keyTyped('\u0001', this.lastKeyCode);
        } else {
            this.lastKeyCode = keyCode;
            this.screen.keyTyped('\u0001', this.lastKeyCode);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.overlay != null) {
            this.overlay.keyTyped(chr, this.lastKeyCode);
        } else {
            this.screen.keyTyped(chr, this.lastKeyCode);
        }
        return super.method_25400(chr, modifiers);
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        int w = (int)Math.ceil((float)width / this.getXFactor());
        int h = (int)Math.ceil((float)height / this.getYFactor());
        this.screen.init(w, h, this);
        if (this.overlay != null) {
            this.overlay.init(w, h, this);
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void setGuiScale(float guiScale) {
        this.guiScale = guiScale;
        int w = (int)Math.ceil((float)this.field_22789 / this.getXFactor());
        int h = (int)Math.ceil((float)this.field_22790 / this.getYFactor());
        this.screen.init(w, h, this);
        if (this.overlay != null) {
            this.overlay.init(w, h, this);
        }
    }

    public float getXFactor() {
        return (float)this.field_22789 / 640.0f * this.guiScale;
    }

    public float getYFactor() {
        return this.getXFactor();
    }

    public UIScreen getUI() {
        return this.screen;
    }

    public static void displayOverlay(UIScreen overlay) {
        ScreenWrapper.displayOverlay(overlay, 200);
    }

    public static void displayOverlay(UIScreen overlay, int frontBuffer) {
        if (class_310.method_1551().field_1755 instanceof ScreenWrapper) {
            ScreenWrapper wrapper = (ScreenWrapper)class_310.method_1551().field_1755;
            if (overlay == null && wrapper.overlay != null) {
                wrapper.overlay.onGuiClosed();
            }
            wrapper.overlay = overlay;
            wrapper.frontBuffer = frontBuffer;
            if (overlay != null) {
                int w = (int)Math.ceil((float)wrapper.field_22789 / wrapper.getXFactor());
                int h = (int)Math.ceil((float)wrapper.field_22790 / wrapper.getYFactor());
                overlay.init(w, h, wrapper);
            }
        } else if (lastScreen != null) {
            ScreenWrapper.displayScreen(lastScreen);
            ScreenWrapper.displayOverlay(overlay, frontBuffer);
        }
    }

    public static void closeOverlay() {
        ScreenWrapper.displayOverlay(null, 0);
    }

    public static void displayScreen(ScreenWrapper screen) {
        class_310.method_1551().method_1507((class_437)screen);
        screen.getUI().refreshGui();
        lastScreen = screen;
    }

    public static void displayLastScreen() {
        if (lastScreen != null) {
            class_310.method_1551().method_1507((class_437)lastScreen);
            lastScreen.getUI().refreshGui();
        }
    }
}

