/*
 * Decompiled with CFR 0.152.
 */
package v1_21_4.morecosmetics.models.renderer;

import com.cosmeticsmod.external.software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import com.cosmeticsmod.external.software.bernie.geckolib3.geo.render.built.GeoBone;
import com.cosmeticsmod.external.software.bernie.geckolib3.geo.render.built.GeoCube;
import com.cosmeticsmod.external.software.bernie.geckolib3.geo.render.built.GeoQuad;
import com.cosmeticsmod.external.software.bernie.geckolib3.geo.render.built.GeoVertex;
import com.cosmeticsmod.morecosmetics.models.animated.CosmeticAnimatable;
import com.cosmeticsmod.morecosmetics.models.config.ModelData;
import com.cosmeticsmod.morecosmetics.models.config.SettingOverlay;
import com.cosmeticsmod.morecosmetics.models.model.CosmeticModel;
import com.cosmeticsmod.morecosmetics.models.model.SubModel;
import com.cosmeticsmod.morecosmetics.models.renderer.RenderStack;
import com.cosmeticsmod.morecosmetics.utils.RainbowHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_591;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import v1_21_4.morecosmetics.models.renderer.MatrixStackWrapper;
import v1_21_4.morecosmetics.models.renderer.ModelCosmeticRenderer;
import v1_21_4.morecosmetics.models.renderer.StackHolder;

@Environment(value=EnvType.CLIENT)
public class GeoModelRenderer {
    private static final List<Object> EXTRA_DATA = new ArrayList<Object>();
    public static MatrixStackWrapper MATRIX_STACK = new MatrixStackWrapper();
    private float tickValue;
    private float motionAdd;
    private float motionSub;
    private float rotation;
    private ModelCosmeticRenderer renderer;
    private class_591 modelPlayer;
    private ModelData data;
    private CosmeticModel model;
    private SubModel[] subModels;

    public void updateAnimation(Integer id, CosmeticAnimatable animatable, float partialTicks) {
        AnimationEvent<CosmeticAnimatable> event = new AnimationEvent<CosmeticAnimatable>(animatable, 0.0f, 0.0f, partialTicks, false, EXTRA_DATA);
        animatable.getModel().setLivingAnimations(animatable, id, (AnimationEvent)event);
    }

    public void renderModel(CosmeticModel model, class_4597 provider, class_4588 builder, ModelCosmeticRenderer renderer, SubModel[] subModels, ModelData data, class_591 modelPlayer, int overlay, int light, float tickValue, float motionAdd, float motionSub, float rotation) {
        this.renderer = renderer;
        this.subModels = subModels;
        this.data = data;
        this.model = model;
        this.modelPlayer = modelPlayer;
        this.tickValue = tickValue;
        this.motionAdd = motionAdd;
        this.motionSub = motionSub;
        this.rotation = rotation;
        MATRIX_STACK.update(StackHolder.STACK);
        RenderSystem.disableCull();
        for (GeoBone group : model.getModel().topLevelBones) {
            this.renderRecursively(group, provider, builder, overlay, light, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        RenderSystem.enableCull();
    }

    private void renderRecursively(GeoBone bone, class_4597 provider, class_4588 builder, int overlay, int light, float red, float green, float blue, float alpha) {
        int i = bone.subModelIndex;
        if (i != -1) {
            int color;
            SettingOverlay subData;
            SubModel subModel = this.subModels[i];
            SettingOverlay settingOverlay = subData = this.data.model[i] != null ? this.data.model[i] : ModelCosmeticRenderer.PLACEHOLDER_DATA;
            if (!subModel.isVisible() || !subData.visible) {
                return;
            }
            RenderStack<class_4587> stack = ModelCosmeticRenderer.STACK;
            stack.push();
            float y = this.renderer.transformToEntity(subModel, this.modelPlayer, true, stack);
            this.renderer.transformModel(subModel, y, subData, stack);
            this.renderer.appendAnimations(subModel, this.tickValue, this.motionAdd, this.motionSub, this.rotation, subData, stack);
            if (subModel.hasTextures()) {
                this.renderer.renderTextureModels(subModel.getTextures(), this.data, null, this.tickValue, this.motionAdd, this.motionSub, this.rotation, provider, light, this.model.getName(), false);
                class_2960 loc = ModelCosmeticRenderer.RESLOCS.get(this.model.getTextureName());
                RenderSystem.setShaderTexture((int)0, (class_2960)loc);
                builder = provider.getBuffer(class_1921.method_23580((class_2960)loc));
            }
            int n = color = subData.color != 0 ? subData.color : subModel.getColor();
            if (color == 1) {
                color = RainbowHandler.RAINBOW_VALUE;
            }
            red = (float)(color >> 16 & 0xFF) / 255.0f;
            green = (float)(color >> 8 & 0xFF) / 255.0f;
            blue = (float)(color & 0xFF) / 255.0f;
            alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
            if (subData.illum) {
                light = 0xF000F0;
            }
        }
        MATRIX_STACK.push();
        MATRIX_STACK.translate(bone);
        MATRIX_STACK.moveToPivot(bone);
        MATRIX_STACK.rotate(bone);
        MATRIX_STACK.scale(bone);
        MATRIX_STACK.moveBackFromPivot(bone);
        if (!bone.isHidden) {
            for (GeoCube cube : bone.childCubes) {
                MATRIX_STACK.push();
                this.renderCube(builder, cube, overlay, light, red, green, blue, alpha);
                MATRIX_STACK.pop();
            }
            for (GeoBone childBone : bone.childBones) {
                this.renderRecursively(childBone, provider, builder, overlay, light, red, green, blue, alpha);
            }
        }
        MATRIX_STACK.pop();
        if (i != -1) {
            ModelCosmeticRenderer.STACK.pop();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderCube(class_4588 builder, GeoCube cube, int overlay, int light, float red, float green, float blue, float alpha) {
        MATRIX_STACK.moveToPivot(cube);
        MATRIX_STACK.rotate(cube);
        MATRIX_STACK.moveBackFromPivot(cube);
        for (GeoQuad quad : cube.quads) {
            Vector3f normal = new Vector3f((float)quad.normal.getX(), (float)quad.normal.getY(), (float)quad.normal.getZ());
            normal.mul((Matrix3fc)MATRIX_STACK.getStack().method_23760().method_23762());
            if ((cube.size.getY() == 0.0f || cube.size.getZ() == 0.0f) && normal.x() < 0.0f) {
                normal.mul(-1.0f, 1.0f, 1.0f);
            }
            if ((cube.size.getX() == 0.0f || cube.size.getZ() == 0.0f) && normal.y() < 0.0f) {
                normal.mul(1.0f, -1.0f, 1.0f);
            }
            if ((cube.size.getX() == 0.0f || cube.size.getY() == 0.0f) && normal.z() < 0.0f) {
                normal.mul(1.0f, 1.0f, -1.0f);
            }
            for (GeoVertex vertex : quad.vertices) {
                Vector4f vector4f = new Vector4f(vertex.position.getX(), vertex.position.getY(), vertex.position.getZ(), 1.0f);
                vector4f.mul((Matrix4fc)MATRIX_STACK.getStack().method_23760().method_23761());
                builder.method_22912(vector4f.x(), vector4f.y(), vector4f.z()).method_22915(red, green, blue, alpha).method_22913(vertex.textureU, vertex.textureV).method_22922(overlay).method_60803(light).method_22914(normal.x(), normal.y(), normal.z());
            }
        }
    }
}

