/*
 * Decompiled with CFR 0.152.
 */
package v1_21_4.morecosmetics.models.renderer;

import com.cosmeticsmod.external.software.bernie.geckolib3.geo.render.built.GeoBone;
import com.cosmeticsmod.external.software.bernie.geckolib3.geo.render.built.GeoCube;
import com.cosmeticsmod.external.software.bernie.geckolib3.geo.render.built.Vec3F;
import com.cosmeticsmod.morecosmetics.models.renderer.RenderStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;
import v1_21_4.morecosmetics.models.renderer.QuaternionHelper;

@Environment(value=EnvType.CLIENT)
public class MatrixStackWrapper
implements RenderStack<class_4587> {
    private class_4587 stack;

    public void update(class_4587 stack) {
        this.stack = stack;
    }

    @Override
    public void push() {
        this.stack.method_22903();
    }

    @Override
    public void pop() {
        this.stack.method_22909();
    }

    @Override
    public class_4587 get() {
        return this.stack;
    }

    @Override
    public void translate(float x, float y, float z) {
        this.stack.method_46416(x, y, z);
    }

    public void moveToPivot(GeoCube cube) {
        Vec3F pivot = cube.pivot;
        this.translate(pivot.getX() / 16.0f, pivot.getY() / 16.0f, pivot.getZ() / 16.0f);
    }

    public void moveBackFromPivot(GeoCube cube) {
        Vec3F pivot = cube.pivot;
        this.translate(-pivot.getX() / 16.0f, -pivot.getY() / 16.0f, -pivot.getZ() / 16.0f);
    }

    public void moveToPivot(GeoBone bone) {
        this.translate(bone.rotationPointX / 16.0f, bone.rotationPointY / 16.0f, bone.rotationPointZ / 16.0f);
    }

    public void moveBackFromPivot(GeoBone bone) {
        this.translate(-bone.rotationPointX / 16.0f, -bone.rotationPointY / 16.0f, -bone.rotationPointZ / 16.0f);
    }

    public void translate(GeoBone bone) {
        this.translate(-bone.getPositionX() / 16.0f, bone.getPositionY() / 16.0f, bone.getPositionZ() / 16.0f);
    }

    @Override
    public void scale(float x, float y, float z) {
        this.stack.method_22905(x, y, z);
    }

    public void scale(GeoBone bone) {
        this.scale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    @Override
    public void rotateX(float radian) {
        this.stack.method_22907(QuaternionHelper.getRadialQuaternion(QuaternionHelper.POSITIVE_X, radian));
    }

    @Override
    public void rotateY(float radian) {
        this.stack.method_22907(QuaternionHelper.getRadialQuaternion(QuaternionHelper.POSITIVE_Y, radian));
    }

    @Override
    public void rotateZ(float radian) {
        this.stack.method_22907(QuaternionHelper.getRadialQuaternion(QuaternionHelper.POSITIVE_Z, radian));
    }

    public void rotate(GeoBone bone) {
        if (bone.getRotationZ() != 0.0f) {
            this.rotateZ(bone.getRotationZ());
        }
        if (bone.getRotationY() != 0.0f) {
            this.rotateY(bone.getRotationY());
        }
        if (bone.getRotationX() != 0.0f) {
            this.rotateX(bone.getRotationX());
        }
    }

    @Override
    public void rotate(float x, float y, float z) {
        if (z != 0.0f) {
            this.rotateZ(z);
        }
        if (y != 0.0f) {
            this.rotateY(y);
        }
        if (x != 0.0f) {
            this.rotateX(x);
        }
    }

    public void rotate(GeoCube bone) {
        Vec3F rotation = bone.rotation;
        this.stack.method_22907(QuaternionHelper.getQuaternion(0.0f, 0.0f, rotation.getZ(), false));
        this.stack.method_22907(QuaternionHelper.getQuaternion(0.0f, rotation.getY(), 0.0f, false));
        this.stack.method_22907(QuaternionHelper.getQuaternion(rotation.getX(), 0.0f, 0.0f, false));
    }

    public class_4587 getStack() {
        return this.stack;
    }
}

