/*
 * Decompiled with CFR 0.152.
 */
package v1_21_4.morecosmetics.models.renderer;

import com.cosmeticsmod.morecosmetics.MoreCosmetics;
import com.cosmeticsmod.morecosmetics.MoreCosmeticsAPI;
import com.cosmeticsmod.morecosmetics.models.ModelHandler;
import com.cosmeticsmod.morecosmetics.models.ModelLoader;
import com.cosmeticsmod.morecosmetics.models.animated.AnimationEventType;
import com.cosmeticsmod.morecosmetics.models.animation.Animation;
import com.cosmeticsmod.morecosmetics.models.animation.AnimationAxis;
import com.cosmeticsmod.morecosmetics.models.animation.AnimationType;
import com.cosmeticsmod.morecosmetics.models.config.ModelData;
import com.cosmeticsmod.morecosmetics.models.config.SettingOverlay;
import com.cosmeticsmod.morecosmetics.models.model.AnimationModel;
import com.cosmeticsmod.morecosmetics.models.model.CosmeticModel;
import com.cosmeticsmod.morecosmetics.models.model.ItemModel;
import com.cosmeticsmod.morecosmetics.models.model.PositionModel;
import com.cosmeticsmod.morecosmetics.models.model.TextureModel;
import com.cosmeticsmod.morecosmetics.models.model.util.ModelCategory;
import com.cosmeticsmod.morecosmetics.models.model.util.ModelPosition;
import com.cosmeticsmod.morecosmetics.models.renderer.RenderCallback;
import com.cosmeticsmod.morecosmetics.models.renderer.RenderStack;
import com.cosmeticsmod.morecosmetics.user.CosmeticUser;
import com.cosmeticsmod.morecosmetics.utils.MathUtils;
import com.cosmeticsmod.morecosmetics.utils.ModConfig;
import com.cosmeticsmod.morecosmetics.utils.SharedVars;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10042;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_811;
import net.minecraft.class_8685;
import net.minecraft.class_922;
import v1_21_4.morecosmetics.DrawUtils;
import v1_21_4.morecosmetics.compatibility.mixin.accessor.FeatureAccessor;
import v1_21_4.morecosmetics.compatibility.mixin.accessor.RenderDispatcherAccessor;
import v1_21_4.morecosmetics.models.cloak.CloakRenderer;
import v1_21_4.morecosmetics.models.renderer.GeoModelRenderer;
import v1_21_4.morecosmetics.models.renderer.ModelCosmeticLayer;
import v1_21_4.morecosmetics.models.renderer.StackHolder;
import v1_21_4.morecosmetics.models.textures.CustomImage;
import v1_21_4.morecosmetics.models.textures.CustomTextureManager;

@Environment(value=EnvType.CLIENT)
public class ModelCosmeticRenderer
extends ModelHandler
implements class_3302 {
    public static final RenderStack<class_4587> STACK = StackHolder.getInstance();
    public static final float SCALE = 0.0625f;
    public static final HashMap<Integer, class_1799> ITEMS = new HashMap();
    public static final HashMap<String, class_2960> RESLOCS = new HashMap();
    public static final SettingOverlay PLACEHOLDER_DATA = new SettingOverlay();
    public static class_2960 NEXT_CAPE_LOC;
    private final CustomTextureManager cosTextures = new CustomTextureManager("mcos");
    private final GeoModelRenderer geoModelRenderer = new GeoModelRenderer();
    private final CloakRenderer cloakRenderer = new CloakRenderer();
    private boolean lastMojangState;

    public ModelCosmeticRenderer() {
        ((class_3304)class_310.method_1551().method_1478()).method_14477((class_3302)this);
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, Executor prepareExecutor, Executor applyExecutor) {
        return ((CompletableFuture)CompletableFuture.runAsync(() -> MoreCosmetics.log("Detected resource reload!"), applyExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenRun(this::registerLayer);
    }

    @Override
    public void registerLayer() {
        try {
            class_310 mc = class_310.method_1551();
            for (class_8685.class_7920 key : ((RenderDispatcherAccessor)mc.method_1561()).getModelRenderers().keySet()) {
                class_1007 playerRenderer = (class_1007)((RenderDispatcherAccessor)mc.method_1561()).getModelRenderers().get(key);
                List layerRenderers = ((FeatureAccessor)playerRenderer).getFeatures();
                layerRenderers.add(0, new ModelCosmeticLayer(playerRenderer, this, key == class_8685.class_7920.field_41122));
                this.renderLayers.put(key.method_52856(), layerRenderers);
            }
        }
        catch (Throwable e) {
            MoreCosmetics.catchThrowable(e);
        }
    }

    public float renderCosmetics(class_4587 stack, class_4597 provider, int light, class_742 entity, class_10055 state, float movementFactor, float walkingSpeed, float tickValue, class_591 modelPlayer, boolean slim, float partialTicks) {
        String cloak;
        Object image;
        SharedVars.RENDER_TICKS = tickValue;
        SharedVars.PARTIAL_TICKS = partialTicks;
        SharedVars.LIGHT = light;
        NEXT_CAPE_LOC = null;
        if (entity.method_5756((class_1657)class_310.method_1551().field_1724) || entity.method_5767()) {
            return 0.0f;
        }
        CosmeticUser user = this.userHandler.getUser(entity.method_5667());
        if (user == null) {
            return 0.0f;
        }
        if (MoreCosmeticsAPI.isCloakEnabled() && ModConfig.getConfig().cloaks && user.hasCloak() && !state.field_53418.method_31574(class_1802.field_8833) && state.field_53532 && (image = this.cosTextures.getImage(cloak = user.getCloak().getUrl(), cloak, null, ModelHandler.getCloakTransformer())) != null) {
            boolean mojangRender = ModConfig.getConfig().cloakCompatibility;
            if (this.lastMojangState != mojangRender) {
                this.lastMojangState = mojangRender;
                this.cosTextures.remove(cloak);
            }
            if (mojangRender) {
                if (!state.field_53418.method_31574(class_1802.field_8833)) {
                    NEXT_CAPE_LOC = ((CustomImage)((Object)image)).getLocation();
                }
            } else {
                this.cloakRenderer.render(stack, state, ((CustomImage)((Object)image)).getLocation(), modelPlayer, provider, light);
            }
        }
        user.resetNametagHeight();
        float height = 0.0f;
        if (ModConfig.getConfig().cosmetics && user.hasCosmetics()) {
            try {
                for (RenderCallback callback : this.callbacks) {
                    if (callback.onPreRender(user)) continue;
                    return 0.0f;
                }
                double motionX = entity.field_7524 + (entity.field_7500 - entity.field_7524) * (double)partialTicks - (entity.field_6014 + (entity.method_23317() - entity.field_6014) * (double)partialTicks);
                double motionY = entity.field_7502 + (entity.field_7521 - entity.field_7502) * (double)partialTicks - (entity.field_6036 + (entity.method_23318() - entity.field_6036) * (double)partialTicks);
                double motionZ = entity.field_7522 + (entity.field_7499 - entity.field_7522) * (double)partialTicks - (entity.field_5969 + (entity.method_23321() - entity.field_5969) * (double)partialTicks);
                float motionYaw = entity.field_6220 + (entity.field_6283 - entity.field_6220) * partialTicks;
                double yawSin = MathUtils.sin(motionYaw * (float)Math.PI / 180.0f);
                double yawCos = -MathUtils.cos(motionYaw * (float)Math.PI / 180.0f);
                float rotation = (float)motionY * 10.0f;
                rotation = MathUtils.clampFloat(rotation, -6.0f, 32.0f);
                float motion = (float)(motionX * yawSin + motionZ * yawCos) * 100.0f;
                float motionFront = MathUtils.clampFloat(motion, 0.0f, 180.0f);
                float motionBack = MathUtils.clampFloat(motion, -180.0f, 0.0f);
                stack.method_22903();
                for (Integer id : user.getCosmetics().keySet()) {
                    int armorSlot;
                    CosmeticModel model;
                    ModelData data = user.getCosmetics().get(id);
                    if (data == null || !data.isActive() || (model = this.loader.getCosmetics().get(id)) == null || ModConfig.getConfig().armorMode && (armorSlot = model.getPosition().getArmorSlot()) != -1 && !entity.method_31548().method_7372(armorSlot).method_7960() && (model.getCategory() != ModelCategory.SHIELD.getId() || !ModConfig.getConfig().replaceShield || !entity.method_6118(class_1304.field_6171).method_31574(class_1802.field_8255)) || model.getCategory() == ModelCategory.SHIELD.getId() && ModConfig.getConfig().replaceShield != entity.method_6118(class_1304.field_6171).method_31574(class_1802.field_8255)) continue;
                    float modelHeight = model.getHeight();
                    if (model.getPosition() == ModelPosition.HEAD || model.getPosition() == ModelPosition.ABOVE_HEAD) {
                        modelHeight += data.y;
                    }
                    if (height < modelHeight) {
                        height = modelHeight;
                    }
                    this.renderCosmetic(stack, provider, light, entity, state, model, data, movementFactor, walkingSpeed, tickValue, motionFront, motionBack, rotation, modelPlayer, slim, true);
                }
                stack.method_22909();
                user.setNametagHeight(height);
                for (RenderCallback callback : this.callbacks) {
                    callback.onPostRender(user);
                }
            }
            catch (Throwable e) {
                MoreCosmetics.catchThrowable(e);
            }
        }
        return height;
    }

    public void renderCosmeticFirstPerson(class_4587 stack, class_4597 vertexConsumerProvider, int light, class_742 entity, class_10055 state, CosmeticModel model, ModelData data, boolean firstPerson, boolean leftHanded) {
        STACK.rotateZ(180.0f);
        if (firstPerson) {
            STACK.scale(0.9f, 0.9f, 0.9f);
            STACK.translate(0.0f, 0.4f, -0.1f);
            if (MoreCosmetics.getInstance().getVersionAdapter().isMouseButtonDown(1)) {
                STACK.rotateZ(leftHanded ? -25.0f : 25.0f);
                STACK.translate(-0.15f, -0.15f, 0.0f);
            }
            this.renderCosmetic(stack, vertexConsumerProvider, light, entity, state, model, data, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, null, true, false);
            return;
        }
        if (leftHanded) {
            return;
        }
        STACK.rotateY(180.0f);
        float[] t = model.getSideTranform() != null ? model.getSideTranform() : ModelLoader.SIDE_TRANSFORM;
        STACK.translate(t[0], t[1], t[2]);
        this.renderCosmetic(stack, vertexConsumerProvider, light, entity, state, model, data, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, null, entity.method_52814().comp_1629() == class_8685.class_7920.field_41122, true);
    }

    public void renderCosmetic(class_4587 stack, class_4597 vertexConsumerProvider, int light, class_742 entity, class_10055 state, CosmeticModel model, ModelData data, float movementFactor, float walkingSpeed, float tickValue, float motionFront, float motionBack, float rotation, class_591 modelPlayer, boolean slim, boolean transformModel) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        STACK.push();
        float y = this.transformToEntity(model, modelPlayer, false, STACK);
        STACK.rotateZ(180.0f);
        if (transformModel) {
            this.transformModel(model, y, data, STACK);
        }
        if (data.resize) {
            STACK.scale(model.getResizeVal(), model.getResizeVal(), model.getResizeVal());
        }
        float[] adj = model.getAdjustment();
        if (!slim && adj != null && adj.length > 5) {
            float armorAdjust = 0.0f;
            if (model.getCategory() == ModelCategory.SHIELD.getId() && entity != null && !entity.method_6118(class_1304.field_6174).method_7960()) {
                armorAdjust = 0.05f;
            }
            STACK.scale(adj[0], adj[1], adj[2] + armorAdjust);
            STACK.translate(adj[3], adj[4], adj[5] - armorAdjust);
        }
        this.appendAnimations(model, tickValue, motionFront, motionBack, rotation, data, STACK);
        if (model.hasTextureModels()) {
            this.renderTextureModels(model.getTextureModels(), data, modelPlayer, tickValue, motionFront, motionBack, rotation, vertexConsumerProvider, light, model.getName(), true);
        }
        if (model.hasItemModels() && entity != null) {
            this.renderItemModels(model, data, modelPlayer, tickValue, motionFront, motionBack, rotation, light);
        }
        String texName = model.getTextureName();
        class_287 consumer = null;
        if (texName != null) {
            CustomImage customImage;
            class_2960 loc = RESLOCS.get(texName);
            if (loc == null) {
                loc = class_2960.method_60654((String)("morecosmetics/" + texName));
                RESLOCS.put(texName, loc);
            }
            if (data.url != null && !data.url.isEmpty() && (customImage = this.cosTextures.getImage(data.url + model.getTextureName(), data.url, null)) != null) {
                loc = customImage.getLocation();
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)loc);
            if (vertexConsumerProvider != null) {
                consumer = vertexConsumerProvider.getBuffer(class_1921.method_23580((class_2960)loc));
            } else {
                RenderSystem.setShader((class_10156)class_10142.field_53878);
            }
        } else {
            consumer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1580);
        }
        STACK.push();
        if (model.hasAnimatedModel() && entity != null) {
            if (model.getAnimatedModel().hasAnimations()) {
                AnimationEventType current = AnimationEventType.IDLE;
                if (entity.method_23317() - entity.field_6014 != 0.0 || entity.method_23321() - entity.field_5969 != 0.0) {
                    current = AnimationEventType.MOVING;
                }
                if (entity.method_5715()) {
                    current = AnimationEventType.SNEAKING;
                }
                model.getAnimatedModel().setAnimationEvent(current);
            }
            this.geoModelRenderer.updateAnimation(model.getId(), model.getAnimatedModel(), SharedVars.PARTIAL_TICKS);
        }
        int overlay = entity != null && transformModel && ModConfig.getConfig().damageTint && state != null ? class_922.method_23622((class_10042)state, (float)0.0f) : class_4608.field_21444;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.geoModelRenderer.renderModel(model, vertexConsumerProvider, (class_4588)consumer, this, model.getSubModels(), data, modelPlayer, overlay, light, tickValue, motionFront, motionBack, rotation);
        RenderSystem.disableBlend();
        STACK.pop();
        STACK.pop();
    }

    private void renderItemModels(CosmeticModel model, ModelData data, class_591 modelPlayer, float tickValue, float motionFront, float motionBack, float rotation, int light) {
        for (int i = 0; i < model.getItemModels().size(); ++i) {
            int id;
            class_1799 itemStack;
            SettingOverlay subData;
            ItemModel itemModel = model.getItemModels().get(i);
            boolean useData = data.item != null && data.item.length > i;
            SettingOverlay settingOverlay = subData = useData ? data.item[i] : PLACEHOLDER_DATA;
            if (!subData.visible || (itemStack = ITEMS.get(id = subData.id == 0 ? itemModel.getItemId() : subData.id)) == null) continue;
            STACK.push();
            float y = this.transformToEntity(itemModel, modelPlayer, true, STACK);
            this.transformModel(itemModel, y, subData, STACK);
            this.appendAnimations(itemModel, tickValue, motionFront, motionBack, rotation, subData, STACK);
            STACK.scale(0.5f, 0.5f, 0.5f);
            class_310 mc = class_310.method_1551();
            mc.method_1480().method_23178(itemStack, class_811.field_4319, light, 1, STACK.get(), (class_4597)mc.method_22940().method_23000(), (class_1937)class_310.method_1551().field_1687, 0);
            STACK.pop();
        }
    }

    protected void renderTextureModels(List<TextureModel> models, ModelData data, class_591 modelPlayer, float tickValue, float motionFront, float motionBack, float rotation, class_4597 provider, int light, String name, boolean excludeBounded) {
        for (TextureModel textureModel : models) {
            String key;
            CustomImage loc;
            String url;
            SettingOverlay subData;
            if (excludeBounded == textureModel.isBounded()) continue;
            boolean useData = data.texture != null && data.texture.length > textureModel.getId();
            SettingOverlay settingOverlay = subData = useData ? data.texture[textureModel.getId()] : PLACEHOLDER_DATA;
            if (!subData.visible || (url = subData.url == null ? textureModel.getUrl() : subData.url) == null || url.length() < 3 || (loc = this.cosTextures.getImage(key = url + name + textureModel.getId(), url, textureModel.getMask())) == null) continue;
            STACK.push();
            float y = this.transformToEntity(textureModel, modelPlayer, true, STACK);
            this.transformModel(textureModel, y, subData, STACK);
            this.appendAnimations(textureModel, tickValue, motionFront, motionBack, rotation, subData, STACK);
            STACK.scale(-0.5f, -0.5f, -0.5f);
            int color = subData.color == 0 ? textureModel.getColor() : subData.color;
            DrawUtils.drawTextureWithLight(-0.5f, -0.5f, 256.0f, 256.0f, loc.getFactor(), 1.0f, color, light, loc.getLocation(), provider);
            STACK.pop();
        }
    }

    protected void transformModel(PositionModel model, float y, SettingOverlay data, RenderStack stack) {
        stack.translate(model.getX() + data.x, model.getY() + y + data.y, model.getZ() + data.z);
        stack.rotateY(model.getYaw() + data.yaw);
        stack.rotateX(model.getPitch() + data.pitch);
        stack.rotateZ(model.getRoll() + data.roll);
        stack.scale(model.getScale() * data.scale, model.getScale() * data.scale, model.getScale() * data.scale);
    }

    protected void appendAnimations(AnimationModel model, float tickValue, float motionFront, float motionBack, float rotation, SettingOverlay data, RenderStack stack) {
        if (!model.hasAnimations() || !data.animation) {
            return;
        }
        for (AnimationType type : model.getAnimations().keySet()) {
            Animation animation = model.getAnimations().get((Object)type);
            AnimationAxis a = animation.getAxis();
            float m = animation.getMultiplier() * data.mulitply;
            switch (type) {
                case BOUNCE: {
                    float bounce = m * MathUtils.cos(tickValue / 10.0f) / 20.0f;
                    stack.translate((float)a.x * bounce, (float)a.y * bounce, (float)a.z * bounce);
                    break;
                }
                case ROTATE: {
                    float rotate = m * tickValue;
                    stack.rotate((float)a.x * rotate, (float)a.y * rotate, (float)a.z * rotate);
                    break;
                }
                case FORWARD: {
                    float forward = m * (motionFront / 3.0f);
                    stack.rotate((float)a.x * forward, (float)a.y * forward, (float)a.z * forward);
                    break;
                }
                case BACKWARD: {
                    float backward = m * (motionBack / 3.0f);
                    stack.rotate((float)a.x * backward, (float)a.y * backward, (float)a.z * backward);
                    break;
                }
                case RESIZE: {
                    float resize = 1.0f + m * MathUtils.cos(tickValue / 10.0f) / 20.0f;
                    stack.scale(resize, resize, resize);
                    break;
                }
                case MOTION: {
                    break;
                }
            }
        }
    }

    protected float transformToEntity(PositionModel model, class_591 modelPlayer, boolean flip, RenderStack stack) {
        float y = 0.0f;
        if (modelPlayer != null) {
            switch (model.getPosition()) {
                case FREE: {
                    break;
                }
                case BODY: {
                    this.transformToModel(modelPlayer.field_3391, flip, stack);
                    y = -0.3f;
                    break;
                }
                case HEAD: {
                    this.transformToModel(modelPlayer.field_3398, flip, stack);
                    y = 0.5f;
                    break;
                }
                case ABOVE_HEAD: {
                    y = 0.75f;
                    break;
                }
                case RIGHT_ARM: {
                    this.transformToModel(modelPlayer.field_3401, flip, stack);
                    y = -0.25f;
                    break;
                }
                case LEFT_ARM: {
                    this.transformToModel(modelPlayer.field_27433, flip, stack);
                    y = -0.25f;
                    break;
                }
                case RIGHT_LEG: {
                    this.transformToModel(modelPlayer.field_3392, flip, stack);
                    y = -0.35f;
                    break;
                }
                case LEFT_LEG: {
                    this.transformToModel(modelPlayer.field_3397, flip, stack);
                    y = -0.35f;
                    break;
                }
            }
        }
        return y;
    }

    private void transformToModel(class_630 model, boolean flip, RenderStack stack) {
        if (flip) {
            stack.rotateZ(180.0f);
        }
        stack.translate(model.field_3657 * 0.0625f, model.field_3656 * 0.0625f, model.field_3655 * 0.0625f);
        stack.rotate(model.field_3654 * 57.295776f, model.field_3675 * 57.295776f, model.field_3674 * 57.295776f);
        if (flip) {
            stack.rotateZ(180.0f);
        }
    }

    public static class_742 getPlayerByName(String name) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return null;
        }
        for (class_742 player : world.method_18456()) {
            if (!player.method_5477().getString().equals(name)) continue;
            return player;
        }
        return null;
    }
}

