/*
 * Decompiled with CFR 0.152.
 */
package v1_21_4.morecosmetics.nametags;

import com.cosmeticsmod.morecosmetics.nametags.font.FontData;
import com.cosmeticsmod.morecosmetics.nametags.font.FontImage;
import com.cosmeticsmod.morecosmetics.nametags.font.Glyph;
import com.cosmeticsmod.morecosmetics.utils.SharedVars;
import com.cosmeticsmod.morecosmetics.utils.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1044;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import v1_21_4.morecosmetics.models.renderer.StackHolder;
import v1_21_4.morecosmetics.models.textures.CustomImage;

@Environment(value=EnvType.CLIENT)
public class FontImageRenderer
extends FontImage {
    private final CustomImage texture;
    private final class_2960 id;
    private boolean lightning;
    private int light;
    private float posX;
    private float posY;
    private float red;
    private float r;
    private float green;
    private float g;
    private float blue;
    private float b;
    private float alpha;

    public FontImageRenderer(FontData fontData, int[] colorCode) {
        super(fontData, colorCode);
        this.id = class_2960.method_60654((String)("cmf/" + fontData.id));
        this.texture = new CustomImage(this.id, fontData.image);
        class_310.method_1551().method_1531().method_4616(this.id, (class_1044)this.texture);
    }

    public void enableLightning(int light) {
        this.light = light;
        this.lightning = true;
    }

    public void disableLightning() {
        this.lightning = false;
    }

    @Override
    public int renderString(String text, float x, float y, int color, boolean dropShadow) {
        if (text == null) {
            return 0;
        }
        if ((color & 0xFC000000) == 0) {
            color |= 0xFF000000;
        }
        if (dropShadow) {
            color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        }
        this.red = this.r = (float)(color >> 16 & 0xFF) / 255.0f;
        this.green = this.g = (float)(color >> 8 & 0xFF) / 255.0f;
        this.blue = this.b = (float)(color & 0xFF) / 255.0f;
        this.alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        this.posX = x / this.scale;
        this.posY = y / this.scale - (float)this.fontData.height * this.scale;
        this.renderStringAtPos(text, dropShadow);
        return (int)((this.posX + (float)this.fontData.offset) * this.scale);
    }

    private void renderStringAtPos(String text, boolean shadow) {
        StackHolder stack = StackHolder.getInstance();
        stack.push();
        stack.scale(this.scale, this.scale, this.scale);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.bindTexture((int)this.texture.method_4624());
        RenderSystem.setShaderTexture((int)0, (int)this.texture.method_4624());
        String lookup = text.toLowerCase();
        for (int i = 0; i < text.length(); ++i) {
            char c0 = text.charAt(i);
            if (c0 == '\u00a7' && i + 1 < text.length()) {
                int i1 = "0123456789abcdefklmnor".indexOf(lookup.charAt(i + 1));
                if (i1 < 16) {
                    this.resetStyles();
                    if (i1 < 0) {
                        i1 = 15;
                    }
                    if (shadow) {
                        i1 += 16;
                    }
                    int j1 = this.colorCode[i1];
                    this.r = (float)(j1 >> 16) / 255.0f;
                    this.g = (float)(j1 >> 8 & 0xFF) / 255.0f;
                    this.b = (float)(j1 & 0xFF) / 255.0f;
                } else if (i1 == 16) {
                    this.randomStyle = true;
                } else if (i1 == 17) {
                    this.boldStyle = true;
                } else if (i1 == 18) {
                    this.strikethroughStyle = true;
                } else if (i1 == 19) {
                    this.underlineStyle = true;
                } else if (i1 == 20) {
                    this.italicStyle = true;
                } else {
                    this.resetStyles();
                    this.r = this.red;
                    this.g = this.green;
                    this.b = this.blue;
                }
                ++i;
                continue;
            }
            this.posX += this.drawChar(c0, this.posX, this.posY);
        }
        stack.pop();
    }

    private float drawChar(char ch, float x, float y) {
        StackHolder stack = StackHolder.getInstance();
        Glyph glyph = this.getGlyph(ch);
        if (glyph == null) {
            stack.push();
            stack.scale(1.0f / this.scale, 1.0f / this.scale, 1.0f / this.scale);
            class_4597.class_4598 consumerProvider = class_310.method_1551().method_22940().method_23000();
            class_310.method_1551().field_1772.method_27521(Character.toString(ch), x * this.scale + 0.5f, (y + (float)this.fontData.height * this.scale) * this.scale, Utils.toRGB(this.r, this.g, this.b, this.alpha), false, ((class_4587)stack.get()).method_23760().method_23761(), (class_4597)consumerProvider, class_327.class_6415.field_33993, 0, this.lightning ? SharedVars.LIGHT : 0xF000F0);
            consumerProvider.method_22993();
            stack.pop();
            RenderSystem.bindTexture((int)this.texture.method_4624());
            RenderSystem.setShaderTexture((int)0, (int)this.texture.method_4624());
            return this.getDefaultWidth(ch);
        }
        float iX = (float)glyph.x / (float)this.imageSize;
        float iY = (float)glyph.y / (float)this.imageSize;
        float iWidth = (float)(glyph.width - 4) / (float)this.imageSize;
        float iHeight = (float)(glyph.height - 4) / (float)this.imageSize;
        float width = glyph.width - 4;
        float height = glyph.height - 4;
        float f = glyph.width - this.fontData.offset;
        Matrix4f matrix = ((class_4587)stack.get()).method_23760().method_23761();
        if (this.lightning) {
            int overlay = class_4608.field_21444;
            class_4597.class_4598 consumerProvider = class_310.method_1551().method_22940().method_23000();
            class_4588 bufferBuilder = consumerProvider.getBuffer(class_1921.method_23580((class_2960)this.id));
            bufferBuilder.method_22918(matrix, x + width, y, 0.0f).method_22915(this.r, this.g, this.b, this.alpha).method_22913(iX + iWidth, iY).method_22922(overlay).method_60803(this.light).method_22914(1.0f, 1.0f, 1.0f);
            bufferBuilder.method_22918(matrix, x, y, 0.0f).method_22915(this.r, this.g, this.b, this.alpha).method_22913(iX, iY).method_22922(overlay).method_60803(this.light).method_22914(1.0f, 1.0f, 1.0f);
            bufferBuilder.method_22918(matrix, x, y + height, 0.0f).method_22915(this.r, this.g, this.b, this.alpha).method_22913(iX, iY + iHeight).method_22922(overlay).method_60803(this.light).method_22914(1.0f, 1.0f, 1.0f);
            bufferBuilder.method_22918(matrix, x + width, y + height, 0.0f).method_22915(this.r, this.g, this.b, this.alpha).method_22913(iX + iWidth, iY + iHeight).method_22922(overlay).method_60803(this.light).method_22914(1.0f, 1.0f, 1.0f);
        } else {
            RenderSystem.setShader((class_10156)class_10142.field_53880);
            class_289 tessellator = class_289.method_1348();
            class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            bufferBuilder.method_22918(matrix, x + width, y, 0.0f).method_22913(iX + iWidth, iY).method_22915(this.r, this.g, this.b, this.alpha);
            bufferBuilder.method_22918(matrix, x, y, 0.0f).method_22913(iX, iY).method_22915(this.r, this.g, this.b, this.alpha);
            bufferBuilder.method_22918(matrix, x, y + height, 0.0f).method_22913(iX, iY + iHeight).method_22915(this.r, this.g, this.b, this.alpha);
            bufferBuilder.method_22918(matrix, x + width, y + height, 0.0f).method_22913(iX + iWidth, iY + iHeight).method_22915(this.r, this.g, this.b, this.alpha);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        }
        return f;
    }

    @Override
    public int getDefaultWidth(char ch) {
        return (int)((float)class_310.method_1551().field_1772.method_1727(Character.toString(ch)) / this.scale);
    }
}

