/*
 * Decompiled with CFR 0.152.
 */
package v1_21_4.morecosmetics.nametags;

import com.cosmeticsmod.morecosmetics.MoreCosmetics;
import com.cosmeticsmod.morecosmetics.models.renderer.RenderStack;
import com.cosmeticsmod.morecosmetics.nametags.EnumNametag;
import com.cosmeticsmod.morecosmetics.nametags.Nametag;
import com.cosmeticsmod.morecosmetics.nametags.NametagHandler;
import com.cosmeticsmod.morecosmetics.nametags.font.CustomFontRenderer;
import com.cosmeticsmod.morecosmetics.nametags.font.FontData;
import com.cosmeticsmod.morecosmetics.nametags.font.FontImage;
import com.cosmeticsmod.morecosmetics.user.CosmeticUser;
import com.cosmeticsmod.morecosmetics.utils.CompatibilityManager;
import com.cosmeticsmod.morecosmetics.utils.ModConfig;
import com.cosmeticsmod.morecosmetics.utils.RainbowHandler;
import com.cosmeticsmod.morecosmetics.utils.SharedVars;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_8646;
import org.joml.Matrix4f;
import v1_21_4.morecosmetics.DrawUtils;
import v1_21_4.morecosmetics.models.renderer.StackHolder;
import v1_21_4.morecosmetics.models.textures.CustomTextureManager;
import v1_21_4.morecosmetics.nametags.FontImageRenderer;

@Environment(value=EnvType.CLIENT)
public class NametagRenderer
extends NametagHandler {
    public static final RenderStack<class_4587> STACK = StackHolder.getInstance();
    private final CustomTextureManager ctm = CustomTextureManager.getGlobalInstance();
    private class_327 textRenderer;
    private class_310 mc;
    private static boolean layerRegistered;

    @Override
    public FontImage addFont(Integer id, FontData fontData) {
        FontImageRenderer image = new FontImageRenderer(fontData, this.colorCode);
        this.fontRendererMap.put(id, image);
        return image;
    }

    @Override
    public void resetLogo(String id) {
        this.ctm.getImageLocations().remove(id);
    }

    @Override
    public void renderNametag(Object stack, Object entity, double x, double y, double z) {
        if (entity instanceof class_742) {
            if (!layerRegistered) {
                layerRegistered = true;
                MoreCosmetics.getInstance().getModelHandler().registerLayer();
            }
            class_742 player = (class_742)entity;
            this.renderPlayerNametag((class_4587)stack, (class_1297)player, x, y, z, SharedVars.PARTIAL_TICKS);
        }
    }

    public void renderPlayerNametag(class_4587 matrixStack, class_1297 entity, double x, double y, double z, float partialTicks) {
        boolean hasNametag;
        StackHolder.update(matrixStack);
        if (!class_310.method_1498()) {
            return;
        }
        this.mc = class_310.method_1551();
        this.textRenderer = this.mc.field_1772;
        CosmeticUser cosmeticUser = this.userHandler.getUser(entity.method_5667());
        boolean showName = CompatibilityManager.shouldShowName() && ModConfig.getConfig().showName && entity == this.mc.field_1724;
        boolean bl = hasNametag = NametagHandler.isNametagEnabled() && ModConfig.getConfig().nametags && cosmeticUser != null && cosmeticUser.hasNametag();
        if (showName || hasNametag) {
            class_746 living = this.mc.field_1724;
            if (living == null) {
                return;
            }
            double distance = entity.method_5739((class_1297)living);
            if (distance <= 2500.0 && !entity.method_5756((class_1657)this.mc.field_1724)) {
                y = 0.25;
                if (distance < 100.0 && this.mc.field_1687.method_8428().method_1189(class_8646.field_45158) != null) {
                    Objects.requireNonNull(this.textRenderer);
                    y += (double)(9.0f * 1.15f * 0.02666667f);
                }
                if (cosmeticUser != null) {
                    y += (double)cosmeticUser.getNametagHeight();
                }
                if (DrawUtils.inPreview()) {
                    STACK.push();
                    STACK.rotateY(180.0f);
                }
                if (showName) {
                    this.renderName(entity, 0.0, y, 0.0, partialTicks == 1.0f);
                }
                if (hasNametag && !entity.method_5715()) {
                    this.renderNametag(entity, cosmeticUser.getNametag(), 0.0, y, 0.0, partialTicks == 1.0f);
                }
                if (DrawUtils.inPreview()) {
                    STACK.pop();
                }
            }
        }
    }

    private void renderName(class_1297 entity, double x, double y, double z, boolean gui) {
        boolean sneaking = entity.method_5715();
        STACK.push();
        STACK.translate((float)x, (float)y + entity.method_17682() + 0.25f, (float)z);
        STACK.get().method_22907(this.mc.method_1561().method_24197());
        STACK.scale(gui ? -0.025f : 0.025f, -0.025f, 0.025f);
        float g = class_310.method_1551().field_1690.method_19343(0.25f);
        int j = (int)(g * 255.0f) << 24;
        class_2561 text = entity.method_5476();
        float h = -this.textRenderer.method_27525((class_5348)text) / 2;
        Matrix4f matrix4f = STACK.get().method_23760().method_23761();
        class_4597.class_4598 consumerProvider = class_310.method_1551().method_22940().method_23000();
        this.textRenderer.method_27522(text, h, 0.0f, 0x20FFFFFF, false, matrix4f, (class_4597)consumerProvider, class_327.class_6415.field_33994, j, SharedVars.LIGHT);
        if (!sneaking) {
            this.textRenderer.method_27522(text, h, 0.0f, -1, false, matrix4f, (class_4597)consumerProvider, class_327.class_6415.field_33993, 0, SharedVars.LIGHT);
        }
        STACK.pop();
    }

    private void renderNametag(class_1297 entity, Nametag tag, double x, double y, double z, boolean gui) {
        String nametag = "\u00a7f" + tag.getTag();
        float scale = (float)tag.getScale();
        STACK.push();
        STACK.translate(0.0f, (float)y + entity.method_17682() + 0.5f, 0.0f);
        if (scale != 1.0f) {
            float yTrans = Math.abs(1.0 - (double)scale) == 0.25 ? 0.075f : 0.1f;
            STACK.translate(0.0f, scale > 1.0f ? yTrans : -yTrans, 0.0f);
            STACK.scale(scale, scale, scale);
        }
        STACK.get().method_22907(this.mc.method_1561().method_24197());
        STACK.scale(gui ? -0.025f : 0.025f, -0.025f, 0.025f);
        if (tag.getMode() == EnumNametag.SWITCHING && tag.hasSecondTag() && System.currentTimeMillis() % 2000L > 1000L) {
            nametag = "\u00a7f" + tag.getSecondTag();
        }
        CustomFontRenderer renderer = null;
        int pos = 0;
        if (tag.hasFont() && this.fontRendererMap.containsKey(tag.getFont())) {
            renderer = (CustomFontRenderer)this.fontRendererMap.get(tag.getFont());
            pos = renderer.getStringWidth(nametag) / 2;
        } else {
            pos = this.textRenderer.method_1727(nametag) / 2;
        }
        if (tag.hasLogo()) {
            this.renderLogo(tag.getLogoURL(), pos);
        }
        this.drawLine(nametag, 0, renderer, pos, true, RainbowHandler.RAINBOW_VALUE);
        if (tag.getMode() == EnumNametag.DOUBLE && tag.hasSecondTag()) {
            String stag = "\u00a7f" + tag.getSecondTag();
            pos = renderer != null ? renderer.getStringWidth(stag) / 2 : this.textRenderer.method_1727(stag) / 2;
            this.drawLine(stag, -10, renderer, pos, true, RainbowHandler.RAINBOW_VALUE);
        }
        STACK.pop();
    }

    private void renderLogo(String url, int pos) {
        class_2960 loc = this.ctm.getTexture(url, url);
        if (loc == null) {
            return;
        }
        class_4597.class_4598 consumerProvider = class_310.method_1551().method_22940().method_23000();
        DrawUtils.drawTextureWithLight(-pos - 10, -0.5f, 255.0f, 255.0f, 8.0f, 8.0f, -1, SharedVars.LIGHT, loc, (class_4597)consumerProvider);
    }

    private void drawLine(String nametag, int height, CustomFontRenderer renderer, int pos, boolean shadow, int color) {
        STACK.push();
        STACK.translate(0.0f, height, 0.0f);
        if (shadow) {
            RenderSystem.disableDepthTest();
            DrawUtils.abstractParentFill(STACK.get(), -pos - 1, 8, pos + 1, -1, 0x3F000000);
            RenderSystem.enableDepthTest();
        }
        if (renderer != null) {
            this.drawString(renderer, nametag, color);
        } else {
            Matrix4f matrix4f = STACK.get().method_23760().method_23761();
            class_4597.class_4598 consumerProvider = class_310.method_1551().method_22940().method_23000();
            this.textRenderer.method_27521(nametag, (float)(-this.textRenderer.method_1727(nametag)) / 2.0f, 0.0f, RainbowHandler.RAINBOW_VALUE, false, matrix4f, (class_4597)consumerProvider, class_327.class_6415.field_33993, 0, SharedVars.LIGHT);
        }
        STACK.pop();
    }

    private void drawString(CustomFontRenderer renderer, String text, int color) {
        ((FontImageRenderer)renderer).enableLightning(SharedVars.LIGHT);
        renderer.renderString(text, (float)(-renderer.getStringWidth(text)) / 2.0f, 0.0f, color, false);
        ((FontImageRenderer)renderer).disableLightning();
    }
}

