/*
 * Decompiled with CFR 0.152.
 */
package dev.igorilic.redstonemanager;

import dev.igorilic.redstonemanager.Config;
import dev.igorilic.redstonemanager.block.ModBlocks;
import dev.igorilic.redstonemanager.block.entity.ModBlockEntities;
import dev.igorilic.redstonemanager.component.ModDataComponents;
import dev.igorilic.redstonemanager.item.ModCreativeModTabs;
import dev.igorilic.redstonemanager.item.ModItemProperties;
import dev.igorilic.redstonemanager.item.ModItems;
import dev.igorilic.redstonemanager.network.PacketHandler;
import dev.igorilic.redstonemanager.screen.ModMenuTypes;
import dev.igorilic.redstonemanager.screen.custom.ManagerScreen;
import dev.igorilic.redstonemanager.util.RMLogger;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;

@Mod(value="redstonemanager")
public class RedstoneManager {
    public static final String MOD_ID = "redstonemanager";

    public RedstoneManager(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        ModCreativeModTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModDataComponents.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        PacketHandler.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC, "redstonemanager.toml");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        RMLogger.info("HELLO FROM COMMON SETUP", new Object[0]);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        RMLogger.info("HELLO from server starting", new Object[0]);
    }

    @EventBusSubscriber(modid="redstonemanager", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ModItemProperties.addCustomItemProperties();
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)ModMenuTypes.MANAGER_MENU.get(), ManagerScreen::new);
        }
    }
}

