/*
 * Decompiled with CFR 0.152.
 */
package dev.igorilic.redstonemanager.block.entity;

import dev.igorilic.redstonemanager.Config;
import dev.igorilic.redstonemanager.block.entity.ModBlockEntities;
import dev.igorilic.redstonemanager.component.ModDataComponents;
import dev.igorilic.redstonemanager.item.custom.RedstoneLinkerItem;
import dev.igorilic.redstonemanager.network.PacketHandler;
import dev.igorilic.redstonemanager.network.PacketLeverStateResponse;
import dev.igorilic.redstonemanager.screen.custom.ManagerMenu;
import dev.igorilic.redstonemanager.util.IUpdatable;
import dev.igorilic.redstonemanager.util.LinkerGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedstoneManagerBlockEntity
extends BlockEntity
implements MenuProvider {
    private final Map<String, LinkerGroup> items = new HashMap<String, LinkerGroup>();

    public RedstoneManagerBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.MANAGER_BE.get(), pos, blockState);
    }

    public void swapLinker(String groupName, ItemStack existingItem, ItemStack inHand) {
        if (!this.items.containsKey(groupName)) {
            return;
        }
        if (existingItem.isEmpty() || inHand.isEmpty()) {
            return;
        }
        if (!(existingItem.getItem() instanceof RedstoneLinkerItem) || !(inHand.getItem() instanceof RedstoneLinkerItem)) {
            return;
        }
        LinkerGroup group = this.items.get(groupName);
        int existingItemIndex = group.findLinkerIndex(existingItem);
        if (existingItemIndex == -1) {
            return;
        }
        this.items.get(groupName).getItems().set(existingItemIndex, inHand.copy());
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public Map<String, LinkerGroup> getItems() {
        return Collections.unmodifiableMap(this.items);
    }

    public void createGroup(String groupName, ServerPlayer player) {
        this.items.computeIfAbsent(groupName, k -> new LinkerGroup(groupName)).addItem(ItemStack.EMPTY);
        this.updateGroupPoweredState(groupName);
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void addItemToGroup(String groupName, ItemStack item) {
        if (!(item.getItem() instanceof RedstoneLinkerItem)) {
            return;
        }
        this.items.computeIfAbsent(groupName, k -> new LinkerGroup(groupName)).addItem(item);
        this.updateGroupPoweredState(groupName);
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void renameGroup(String oldName, String newName) {
        if (!this.items.containsKey(oldName)) {
            return;
        }
        if (newName.isEmpty()) {
            return;
        }
        LinkerGroup group = this.items.get(oldName);
        group.setGroupName(newName);
        this.items.remove(oldName);
        this.items.put(newName, group);
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void deleteGroup(String groupName) {
        if (!this.items.containsKey(groupName)) {
            return;
        }
        LinkerGroup group = this.items.get(groupName);
        List<ItemStack> stacks = group.getItems();
        if (!stacks.isEmpty()) {
            SimpleContainer inv = new SimpleContainer(stacks.size());
            int index = 0;
            for (ItemStack stack : stacks) {
                inv.setItem(index, stack);
                ++index;
            }
            if (this.level != null) {
                Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
            }
        }
        this.items.remove(groupName);
    }

    private void updateGroupPoweredState(String groupName) {
        this.updateGroupPoweredState(groupName, true);
    }

    public void updateGroupPoweredState() {
        for (LinkerGroup group : this.items.values()) {
            this.updateGroupPoweredState(group.getGroupName(), true);
        }
        this.setChanged();
    }

    private ServerLevel resolveLevel(ResourceLocation dimId) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel sl = (ServerLevel)level;
        MinecraftServer srv = sl.getServer();
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimId);
        return srv.getLevel(key);
    }

    private void updateGroupPoweredState(String groupName, Boolean changed) {
        ServerLevel current;
        block8: {
            block7: {
                Level level = this.level;
                if (!(level instanceof ServerLevel)) break block7;
                current = (ServerLevel)level;
                if (this.items.containsKey(groupName)) break block8;
            }
            return;
        }
        boolean isOn = false;
        for (ItemStack stack : this.items.get(groupName).getItems()) {
            BlockState state;
            if (!(stack.getItem() instanceof RedstoneLinkerItem)) continue;
            BlockPos leverPos = (BlockPos)stack.get(ModDataComponents.COORDINATES);
            ResourceLocation dimension = (ResourceLocation)stack.get(ModDataComponents.DIMENSION);
            ServerLevel target = Objects.equals(current.dimension().location(), dimension) ? current : this.resolveLevel(dimension);
            if (target == null || leverPos == null || !LinkerGroup.canLink(state = target.getBlockState(leverPos))) continue;
            if (((Boolean)state.getValue((Property)LeverBlock.POWERED)).booleanValue()) {
                isOn = true;
            }
            List<String> otherGroups = this.findAllGroupsForLever(stack);
            for (String otherGroup : otherGroups) {
                if (otherGroup.equals(groupName) || !changed.booleanValue()) continue;
                this.updateGroupPoweredState(otherGroup, false);
            }
        }
        this.items.get(groupName).setPowered(isOn);
        if (changed.booleanValue()) {
            this.setChanged();
        }
    }

    public void removeItemFromGroup(String groupName, ItemStack item) {
        boolean isEmpty;
        if (!this.items.containsKey(groupName)) {
            return;
        }
        if (!(item.getItem() instanceof RedstoneLinkerItem)) {
            return;
        }
        this.items.get(groupName).removeItem(item);
        boolean bl = isEmpty = this.items.get(groupName).getItems().isEmpty() || this.items.get(groupName).getItems().stream().allMatch(ItemStack::isEmpty);
        if (isEmpty && ((Boolean)Config.DELETE_EMPTY_GROUPS.get()).booleanValue()) {
            this.items.remove(groupName);
        } else {
            this.items.get(groupName).addItem(ItemStack.EMPTY);
        }
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getAllItemSize() {
        return this.items.values().stream().map(LinkerGroup::getItems).mapToInt(List::size).sum();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ListTag groupList = new ListTag();
        for (Map.Entry<String, LinkerGroup> entry : this.items.entrySet()) {
            CompoundTag groupTag = new CompoundTag();
            groupTag.putString("Name", entry.getKey());
            groupTag.putBoolean("IsPowered", entry.getValue().isPowered());
            ListTag itemList = new ListTag();
            for (ItemStack stack : entry.getValue().getItems()) {
                if (stack == ItemStack.EMPTY) continue;
                itemList.add((Object)stack.save(registries));
            }
            groupTag.put("Links", (Tag)itemList);
            groupList.add((Object)groupTag);
        }
        tag.put("Groups", (Tag)groupList);
        this.setChanged();
        if (this.level != null && this.level.isClientSide) {
            Minecraft mc = Minecraft.getInstance();
            mc.execute(() -> {
                Screen patt0$temp = mc.screen;
                if (patt0$temp instanceof IUpdatable) {
                    IUpdatable ui = (IUpdatable)patt0$temp;
                    ui.update(this.items);
                }
            });
        }
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items.clear();
        if (tag.contains("Groups", 9)) {
            ListTag groupList = tag.getList("Groups", 10);
            for (Tag groupTagBase : groupList) {
                CompoundTag groupTag = (CompoundTag)groupTagBase;
                String name = groupTag.getString("Name");
                boolean isPowered = groupTag.getBoolean("IsPowered");
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                ListTag itemList = groupTag.getList("Links", 10);
                for (Tag itemTagBase : itemList) {
                    CompoundTag itemTag = (CompoundTag)itemTagBase;
                    ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)itemTag);
                    if (stack == ItemStack.EMPTY) continue;
                    stacks.add(stack);
                }
                this.items.put(name, new LinkerGroup(name, isPowered, stacks));
            }
        }
        this.setChanged();
        if (this.level != null && this.level.isClientSide) {
            Minecraft mc = Minecraft.getInstance();
            mc.execute(() -> {
                Screen patt0$temp = mc.screen;
                if (patt0$temp instanceof IUpdatable) {
                    IUpdatable ui = (IUpdatable)patt0$temp;
                    ui.update(this.items);
                }
            });
        }
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.getAllItemSize());
        int index = 0;
        for (Map.Entry<String, LinkerGroup> entry : this.items.entrySet()) {
            for (ItemStack stack : entry.getValue().getItems()) {
                inv.setItem(index, stack);
                ++index;
            }
        }
        if (this.level != null) {
            Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
        }
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"gui.redstonemanager.manager");
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, @NotNull Inventory inventory, @NotNull Player player) {
        return new ManagerMenu(i, inventory, this);
    }

    public void toggleLinkedLever(ItemStack stack, String group, ServerPlayer player) {
        ServerLevel target;
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel current = (ServerLevel)level;
        ResourceLocation dimension = (ResourceLocation)stack.get(ModDataComponents.DIMENSION);
        ServerLevel serverLevel = target = Objects.equals(current.dimension().location(), dimension) ? current : this.resolveLevel(dimension);
        if (target == null) {
            return;
        }
        BlockPos leverPos = (BlockPos)stack.get(ModDataComponents.COORDINATES);
        if (leverPos == null) {
            return;
        }
        BlockState state = target.getBlockState(leverPos);
        if (!LinkerGroup.canLink(state)) {
            return;
        }
        boolean isPowered = (Boolean)state.getValue((Property)LeverBlock.POWERED);
        RedstoneManagerBlockEntity.flipLeverVanilla(target, leverPos);
        this.updateGroupPoweredState(group);
        PacketHandler.sendToClient(player, new PacketLeverStateResponse(leverPos, true, !isPowered));
        this.playSound(SoundEvents.LEVER_CLICK, 0.3f, !isPowered ? 0.6f : 0.5f);
        this.setChanged();
    }

    public void toggleAllLinkedLever(String groupName, ServerPlayer player) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        if (!this.items.containsKey(groupName)) {
            return;
        }
        boolean target = !this.items.get(groupName).isPowered();
        for (ItemStack stack : this.items.get(groupName).getItems()) {
            ServerLevel targetDimension;
            BlockPos pos;
            if (!(stack.getItem() instanceof RedstoneLinkerItem) || (pos = (BlockPos)stack.get(ModDataComponents.COORDINATES)) == null) continue;
            ResourceLocation dimension = (ResourceLocation)stack.get(ModDataComponents.DIMENSION);
            ServerLevel serverLevel = targetDimension = Objects.equals(this.level.dimension().location(), dimension) ? sl : this.resolveLevel(dimension);
            if (targetDimension == null) {
                return;
            }
            BlockState st = targetDimension.getBlockState(pos);
            if (!LinkerGroup.canLink(st) || (Boolean)st.getValue((Property)LeverBlock.POWERED) == target) continue;
            RedstoneManagerBlockEntity.flipLeverVanilla(targetDimension, pos);
            PacketHandler.sendToClient(player, new PacketLeverStateResponse(pos, true, target));
        }
        this.items.get(groupName).setPowered(target);
        this.playSound(SoundEvents.LEVER_CLICK, 0.3f, target ? 0.6f : 0.5f);
        this.updateGroupPoweredState(groupName);
        this.setChanged();
    }

    public List<String> findAllGroupsForLever(ItemStack item) {
        ArrayList<String> groups = new ArrayList<String>();
        for (LinkerGroup group : this.items.values()) {
            int index = group.findLinkerIndex(item);
            if (index == -1) continue;
            groups.add(group.getGroupName());
        }
        return groups;
    }

    public void playSound(SoundEvent soundEvent, float volume, float pitch) {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.playSound(null, this.getBlockPos(), soundEvent, SoundSource.BLOCKS, volume, pitch);
    }

    private static Direction connectedDir(BlockState s) {
        AttachFace face = (AttachFace)s.getValue((Property)LeverBlock.FACE);
        Direction facing = (Direction)s.getValue((Property)LeverBlock.FACING);
        return switch (face) {
            default -> throw new MatchException(null, null);
            case AttachFace.FLOOR -> Direction.UP;
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.WALL -> facing;
        };
    }

    private static void flipLeverVanilla(ServerLevel level, BlockPos pos) {
        BlockState old = level.getBlockState(pos);
        if (!(old.getBlock() instanceof LeverBlock)) {
            return;
        }
        BlockState toggled = (BlockState)old.cycle((Property)LeverBlock.POWERED);
        level.setBlock(pos, toggled, 3);
        level.updateNeighborsAt(pos, toggled.getBlock());
        level.updateNeighbourForOutputSignal(pos, toggled.getBlock());
        Direction out = RedstoneManagerBlockEntity.connectedDir(toggled).getOpposite();
        BlockPos attached = pos.relative(out);
        level.updateNeighborsAt(attached, toggled.getBlock());
        level.updateNeighbourForOutputSignal(attached, toggled.getBlock());
        level.blockUpdated(pos, toggled.getBlock());
        level.gameEvent(null, (Holder)((Boolean)toggled.getValue((Property)LeverBlock.POWERED) != false ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE), pos);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }
}

