/*
 * Decompiled with CFR 0.152.
 */
package dev.igorilic.redstonemanager.item.custom;

import dev.igorilic.redstonemanager.component.ModDataComponents;
import dev.igorilic.redstonemanager.util.LinkerGroup;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RedstoneLinkerItem
extends Item {
    public RedstoneLinkerItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (!level.isClientSide && entity instanceof Player && !stack.has(ModDataComponents.ITEM_UUID)) {
            stack.set(ModDataComponents.ITEM_UUID, (Object)UUID.randomUUID().toString());
        }
    }

    @NotNull
    public ItemStack getDefaultInstance() {
        ItemStack stack = new ItemStack((ItemLike)this);
        if (!stack.has(ModDataComponents.ITEM_UUID)) {
            stack.set(ModDataComponents.ITEM_UUID, (Object)UUID.randomUUID().toString());
        }
        return super.getDefaultInstance();
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!level.isClientSide) {
            if (context.getPlayer() != null) {
                if (context.getPlayer().isCrouching()) {
                    if (LinkerGroup.canLink(level.getBlockState(context.getClickedPos()))) {
                        context.getItemInHand().set(ModDataComponents.COORDINATES, (Object)context.getClickedPos());
                        context.getItemInHand().set(ModDataComponents.DIMENSION, (Object)level.dimension().location());
                        level.playSound(null, context.getClickedPos(), SoundEvents.STONE_BUTTON_CLICK_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    context.getPlayer().sendSystemMessage((Component)Component.translatable((String)"message.redstonemanager.connection_cleared"));
                    context.getItemInHand().set(ModDataComponents.COORDINATES, null);
                    context.getItemInHand().set(ModDataComponents.DIMENSION, null);
                }
            }
            context.getPlayer().getInventory().setChanged();
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext context, List<Component> tooltipComponent, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponent.add((Component)Component.translatable((String)"tooltip.redstonemanager.rm_linker.right_click"));
        tooltipComponent.add((Component)Component.translatable((String)"tooltip.redstonemanager.rm_linker.shift_right_click"));
        if (itemStack.get(ModDataComponents.COORDINATES) != null) {
            BlockPos blockPos = (BlockPos)itemStack.get(ModDataComponents.COORDINATES);
            assert (blockPos != null);
            tooltipComponent.add((Component)Component.translatable((String)"tooltip.redstonemanager.rm_linker.linked_to", (Object[])new Object[]{blockPos.toShortString()}));
        }
        if (itemStack.get(ModDataComponents.DIMENSION) != null) {
            ResourceLocation dimension = (ResourceLocation)itemStack.get(ModDataComponents.DIMENSION);
            assert (dimension != null);
            tooltipComponent.add((Component)Component.translatable((String)"tooltip.redstonemanager.rm_linker.linked_in", (Object[])new Object[]{dimension.toString()}));
        }
        super.appendHoverText(itemStack, context, tooltipComponent, tooltipFlag);
    }
}

