/*
 * Decompiled with CFR 0.152.
 */
package dev.igorilic.redstonemanager.screen.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class ConfirmActionScreen
extends Screen {
    private final Component confirmText;
    private final Component confirmLabel;
    private final Component confirmDesc;
    private final Consumer<Boolean> onConfirm;
    private final Screen parent;
    private Boolean hasDescription;

    protected ConfirmActionScreen(Component confirmText, Component confirmLabel, Consumer<Boolean> onConfirm, Screen parent) {
        super((Component)Component.literal((String)""));
        this.confirmText = confirmText;
        this.confirmLabel = confirmLabel;
        this.onConfirm = onConfirm;
        this.parent = parent;
        this.confirmDesc = Component.literal((String)"");
        this.hasDescription = false;
    }

    protected ConfirmActionScreen(Component confirmText, Component confirmDescription, Component confirmLabel, Consumer<Boolean> onConfirm, Screen parent) {
        super((Component)Component.literal((String)""));
        this.confirmText = confirmText;
        this.confirmDesc = confirmDescription;
        this.confirmLabel = confirmLabel;
        this.onConfirm = onConfirm;
        this.parent = parent;
        this.hasDescription = !this.confirmDesc.getString().isEmpty();
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        this.confirmText.plainCopy().withStyle(ChatFormatting.BOLD);
        StringWidget wgtConfirmText = new StringWidget(this.confirmText, this.font){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                float scale = 1.5f;
                PoseStack poseStack = guiGraphics.pose();
                poseStack.pushPose();
                poseStack.translate((float)this.getX(), (float)this.getY(), 0.0f);
                poseStack.scale(scale, scale, 1.0f);
                guiGraphics.drawString(ConfirmActionScreen.this.font, this.getMessage(), 0, 0, this.getColor(), true);
                poseStack.popPose();
            }
        };
        wgtConfirmText.setX(centerX - (int)((double)this.font.width((FormattedText)this.confirmText) / 1.5) + 5);
        wgtConfirmText.setY(centerY - (this.hasDescription != false ? 30 : 15));
        this.addRenderableWidget((GuiEventListener)wgtConfirmText);
        if (this.hasDescription.booleanValue()) {
            StringWidget wgDescriptionText = new StringWidget(this.confirmDesc, this.font);
            wgDescriptionText.setX(centerX - this.font.width((FormattedText)this.confirmDesc) / 2 + 40);
            wgDescriptionText.setY(centerY - 10);
            this.addRenderableWidget((GuiEventListener)wgDescriptionText);
        }
        Button btnAction = Button.builder((Component)this.confirmLabel, b -> {
            this.onConfirm.accept(true);
            Minecraft.getInstance().setScreen(this.parent);
        }).bounds(centerX - (this.font.width((FormattedText)this.confirmLabel) + 10) / 2 - 10, centerY + 10, this.font.width((FormattedText)this.confirmLabel) + 10, 20).build();
        MutableComponent cancelLabel = Component.translatable((String)"label.redstonemanager.manager.cancel");
        Button btnCancel = Button.builder((Component)cancelLabel, b -> {
            this.onConfirm.accept(false);
            Minecraft.getInstance().setScreen(this.parent);
        }).bounds(centerX - (this.font.width((FormattedText)this.confirmLabel) + 10) / 2 + 50, centerY + 10, this.font.width((FormattedText)cancelLabel) + 10, 20).build();
        this.addRenderableWidget((GuiEventListener)btnAction);
        this.addRenderableWidget((GuiEventListener)btnCancel);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int n;
        int padding = 16;
        int spacingBetweenLines = 6;
        float titleScale = 1.5f;
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int titleRawWidth = this.font.width((FormattedText)this.confirmText);
        int titleScaledWidth = (int)((float)titleRawWidth * titleScale);
        Objects.requireNonNull(this.font);
        int titleScaledHeight = (int)(9.0f * titleScale);
        if (this.hasDescription.booleanValue()) {
            Objects.requireNonNull(this.font);
            n = 9;
        } else {
            n = 0;
        }
        int descHeight = n;
        int descWidth = this.hasDescription != false ? this.font.width((FormattedText)this.confirmDesc) : 0;
        int maxContentWidth = Math.max(titleScaledWidth, descWidth);
        int textBlockHeight = titleScaledHeight + (this.hasDescription != false ? descHeight + spacingBetweenLines : 0);
        int buttonHeight = 20;
        int totalBoxWidth = maxContentWidth + padding * 2;
        int totalBoxHeight = textBlockHeight + spacingBetweenLines + buttonHeight + padding * 2;
        int x1 = centerX - totalBoxWidth / 2 + 15;
        int y1 = centerY - totalBoxHeight / 2;
        int x2 = centerX + totalBoxWidth / 2 + 15;
        int y2 = centerY + totalBoxHeight / 2;
        guiGraphics.fill(x1, y1, x2 + 45, y2, -584965598);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parent);
    }
}

