/*
 * Decompiled with CFR 0.152.
 */
package dev.igorilic.redstonemanager.screen.custom;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CreateEditGroupScreen
extends Screen {
    private Consumer<String> groupName;
    private String oldName;
    private Screen parent;
    private Button btnSave;
    private EditBox input;

    protected CreateEditGroupScreen(Consumer<String> groupName, String oldName, Screen parent) {
        super((Component)Component.translatable((String)"tooltip.redstonemanager.manager.create_group"));
        this.groupName = groupName;
        this.oldName = oldName;
        this.parent = parent;
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        MutableComponent header = this.oldName.isEmpty() ? Component.translatable((String)"tooltip.redstonemanager.manager.create_group") : Component.translatable((String)"tooltip.redstonemanager.manager.edit_group");
        StringWidget wgHeader = new StringWidget((Component)header, this.font);
        wgHeader.setX(centerX - wgHeader.getWidth() / 2);
        wgHeader.setY(centerY - 33);
        this.addRenderableWidget((GuiEventListener)wgHeader);
        this.input = new EditBox(this.font, centerX - 75, centerY - 17, 150, 20, (Component)Component.literal((String)""));
        if (!this.oldName.isEmpty()) {
            this.input.setValue(this.oldName);
        }
        this.addRenderableWidget((GuiEventListener)this.input);
        MutableComponent btnLabel = this.oldName.isEmpty() ? Component.translatable((String)"label.redstonemanager.manager.create") : Component.translatable((String)"label.redstonemanager.manager.save");
        this.btnSave = Button.builder((Component)btnLabel, b -> this.groupNameSubmit()).bounds(centerX - 23, centerY + 10, 46, 20).build();
        this.addRenderableWidget((GuiEventListener)this.btnSave);
        this.setInitialFocus((GuiEventListener)this.input);
        this.input.setFocused(true);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int padding = 16;
        int spacingBetweenLines = 6;
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int textHeight = 9;
        int buttonHeight = 20;
        int inputWidth = 150;
        int boxHeight = textHeight + spacingBetweenLines + buttonHeight + padding * 4;
        int boxWidth = inputWidth + padding * 4;
        int x1 = centerX - boxWidth / 2;
        int y1 = centerY - boxHeight / 2;
        int x2 = centerX + boxWidth / 2;
        int y2 = centerY + boxHeight / 2;
        guiGraphics.fill(x1, y1, x2, y2 - 5, -581610155);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parent);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (keyCode == 257 || keyCode == 335) {
            this.groupNameSubmit();
            return true;
        }
        if (this.input.isFocused() && (this.input.keyPressed(keyCode, scanCode, modifiers) || this.input.canConsumeInput())) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void groupNameSubmit() {
        this.groupName.accept(this.input.getValue());
        Minecraft.getInstance().setScreen(this.parent);
    }
}

