/*
 * Decompiled with CFR 0.152.
 */
package dev.igorilic.redstonemanager.screen.custom;

import dev.igorilic.redstonemanager.block.ModBlocks;
import dev.igorilic.redstonemanager.block.entity.RedstoneManagerBlockEntity;
import dev.igorilic.redstonemanager.item.custom.RedstoneLinkerItem;
import dev.igorilic.redstonemanager.screen.ModMenuTypes;
import dev.igorilic.redstonemanager.util.ClickAction;
import dev.igorilic.redstonemanager.util.Interact;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ManagerMenu
extends AbstractContainerMenu
implements Interact {
    public final RedstoneManagerBlockEntity blockEntity;
    private final Level level;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;

    public ManagerMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public ManagerMenu(int containerId, Inventory inv, BlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.MANAGER_MENU.get(), containerId);
        this.blockEntity = (RedstoneManagerBlockEntity)blockEntity;
        this.level = inv.player.level();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        if (!(sourceStack.getItem() instanceof RedstoneLinkerItem)) {
            return ItemStack.EMPTY;
        }
        if (pIndex < 36) {
            String groupName = "Default";
            if (this.blockEntity.getItems().entrySet().stream().findFirst().isPresent()) {
                groupName = (String)((Map.Entry)this.blockEntity.getItems().entrySet().stream().findFirst().get()).getKey();
            }
            this.blockEntity.addItemToGroup(groupName, sourceStack);
            sourceSlot.set(ItemStack.EMPTY);
            return ItemStack.EMPTY;
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@NotNull Player player) {
        return ManagerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)ModBlocks.RM_MANAGER_BLOCK.get()));
    }

    public void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 160 + i * 18));
            }
        }
    }

    public void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 218));
        }
    }

    @Override
    public void clicked(ItemStack itemStack, CompoundTag extraData, ClickAction clickType, int button, String groupName) {
        ClickAction clickAction = clickType;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"PICKUP", "PUT_INTO_MANAGER", "SWAP", "QUICK_MOVE"}, (ClickAction)clickAction, n)) {
            case 0: {
                ItemStack result;
                if (!this.getCarried().isEmpty() || itemStack == null || (result = itemStack.copy()).isEmpty()) break;
                this.setCarried(result);
                this.blockEntity.removeItemFromGroup(groupName, itemStack);
                break;
            }
            case 1: {
                ItemStack result;
                if (this.getCarried().isEmpty() || !itemStack.isEmpty() || (result = this.getCarried().copy()).isEmpty()) break;
                this.setCarried(ItemStack.EMPTY);
                this.blockEntity.addItemToGroup(groupName, result);
                break;
            }
            case 2: {
                ItemStack result;
                if (this.getCarried().isEmpty() || itemStack == null || (result = this.getCarried().copy()).isEmpty()) break;
                this.blockEntity.swapLinker(groupName, itemStack, result);
                this.setCarried(itemStack);
                break;
            }
            case 3: {
                ItemStack itemToRemove = itemStack.copy();
                if (!this.moveItemStackTo(itemStack, 0, 36, false)) break;
                this.blockEntity.removeItemFromGroup(groupName, itemToRemove);
                this.setCarried(ItemStack.EMPTY);
                break;
            }
        }
    }
}

